/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Random;
import org.bukkit.Material;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayout;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.structure.stronghold.HallwayPopulator;
import org.terraform.structure.stronghold.LibraryRoomPopulator;
import org.terraform.structure.stronghold.NetherPortalRoomPopulator;
import org.terraform.structure.stronghold.PortalRoomPopulator;
import org.terraform.structure.stronghold.PrisonRoomPopulator;
import org.terraform.structure.stronghold.SilverfishDenPopulator;
import org.terraform.structure.stronghold.StairwayRoomPopulator;
import org.terraform.structure.stronghold.StairwayTopPopulator;
import org.terraform.structure.stronghold.StrongholdPathPopulator;
import org.terraform.structure.stronghold.SupplyRoomPopulator;
import org.terraform.structure.stronghold.TrapChestRoomPopulator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.MazeSpawner;

public class StrongholdPopulator
extends SingleMegaChunkStructurePopulator {
    private static boolean debugSpawnMessage = false;
    private int[][] POSITIONS;

    private static int[] randomCircleCoords(Random rand, int radius) {
        double angle = rand.nextDouble() * Math.PI * 2.0;
        int x = (int)(Math.cos(angle) * (double)radius);
        int z = (int)(Math.sin(angle) * (double)radius);
        return new int[]{x, z};
    }

    private static boolean areCoordsEqual(int[] a2, int x, int z) {
        return a2[0] == x && a2[1] == z;
    }

    public int[][] strongholdPositions(TerraformWorld tw) {
        if (this.POSITIONS == null) {
            int i;
            this.POSITIONS = new int[128][2];
            int pos = 0;
            int radius = 1408;
            Random rand = tw.getHashedRand(1L, 1, 1);
            for (i = 0; i < 3; ++i) {
                int[] coords = StrongholdPopulator.randomCircleCoords(rand, radius);
                if (!debugSpawnMessage) {
                    TerraformGeneratorPlugin.logger.info("Will spawn stronghold at: " + coords[0] + ", " + coords[1]);
                    debugSpawnMessage = true;
                }
                this.POSITIONS[pos++] = coords;
            }
            radius += 3072;
            for (i = 0; i < 6; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 10; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 15; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 21; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 28; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 36; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
            radius += 3072;
            for (i = 0; i < 9; ++i) {
                this.POSITIONS[pos++] = StrongholdPopulator.randomCircleCoords(rand, radius);
            }
        }
        return this.POSITIONS;
    }

    @Override
    public boolean canSpawn(TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        int[][] positions = this.strongholdPositions(tw);
        for (int x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
            for (int z = chunkZ * 16; z < chunkZ * 16 + 16; ++z) {
                for (int[] pos : positions) {
                    if (!StrongholdPopulator.areCoordsEqual(pos, x, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void populate(TerraformWorld tw, PopulatorDataAbstract data) {
        if (!TConfigOption.STRUCTURES_STRONGHOLD_ENABLED.getBoolean()) {
            return;
        }
        int[][] positions = this.strongholdPositions(tw);
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            block1: for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                for (int[] pos : positions) {
                    if (!StrongholdPopulator.areCoordsEqual(pos, x, z)) continue;
                    int y = GenUtils.randInt(TConfigOption.STRUCTURES_STRONGHOLD_MIN_Y.getInt(), TConfigOption.STRUCTURES_STRONGHOLD_MAX_Y.getInt());
                    if (y + 18 > GenUtils.getHighestGround(data, x, z) && y > TConfigOption.STRUCTURES_STRONGHOLD_FAILSAFE_Y.getInt()) {
                        y = TConfigOption.STRUCTURES_STRONGHOLD_FAILSAFE_Y.getInt();
                    }
                    this.spawnStronghold(tw, this.getHashedRandom(tw, data.getChunkX(), data.getChunkZ()), data, x, y, z);
                    continue block1;
                }
            }
        }
    }

    public void spawnStronghold(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int y, int z) {
        int numRooms = 70;
        int range = 100;
        Random hashedRand = tw.getHashedRand(x, y, z);
        RoomLayoutGenerator gen = new RoomLayoutGenerator(hashedRand, RoomLayout.RANDOM_BRUTEFORCE, numRooms, x, y, z, range);
        MazeSpawner mazeSpawner = new MazeSpawner();
        mazeSpawner.setMazePeriod(10);
        mazeSpawner.setMazePathWidth(3);
        mazeSpawner.setWidth(range + 20);
        mazeSpawner.setMazeHeight(4);
        mazeSpawner.setCovered(true);
        gen.setMazePathGenerator(mazeSpawner);
        gen.setPathPopulator(new StrongholdPathPopulator(tw.getHashedRand(x, y, z, 2L)));
        gen.setRoomMaxX(30);
        gen.setRoomMaxZ(30);
        gen.setRoomMaxHeight(15);
        gen.forceAddRoom(25, 25, 15);
        CubeRoom stairwayOne = gen.forceAddRoom(5, 5, 18);
        stairwayOne.setRoomPopulator(new StairwayRoomPopulator(random, false, false));
        gen.registerRoomPopulator(new PortalRoomPopulator(random, true, true));
        gen.registerRoomPopulator(new LibraryRoomPopulator(random, false, false));
        gen.registerRoomPopulator(new NetherPortalRoomPopulator(random, false, true));
        gen.registerRoomPopulator(new PrisonRoomPopulator(random, false, false));
        gen.registerRoomPopulator(new SilverfishDenPopulator(random, false, false));
        gen.registerRoomPopulator(new SupplyRoomPopulator(random, false, false));
        gen.registerRoomPopulator(new TrapChestRoomPopulator(random, false, false));
        gen.registerRoomPopulator(new HallwayPopulator(random, false, false));
        gen.generate();
        gen.fill(data, tw, Material.STONE_BRICKS, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS);
        gen.reset();
        mazeSpawner = new MazeSpawner();
        mazeSpawner.setMazePeriod(10);
        mazeSpawner.setMazePathWidth(3);
        mazeSpawner.setCovered(true);
        mazeSpawner.setMazeHeight(4);
        mazeSpawner.setWidth(range + 20);
        gen.setMazePathGenerator(mazeSpawner);
        gen.setCentY(y += 18);
        gen.setRand(tw.getHashedRand(x, y, z));
        gen.setPathPopulator(new StrongholdPathPopulator(tw.getHashedRand(x, y, z, 2L)));
        CubeRoom stairwayTwo = new CubeRoom(5, 5, 5, stairwayOne.getX(), y, stairwayOne.getZ());
        stairwayTwo.setRoomPopulator(new StairwayTopPopulator(random, false, false));
        gen.getRooms().add(stairwayTwo);
        gen.generate();
        gen.fill(data, tw, Material.STONE_BRICKS, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS);
    }

    public int[] getNearestFeature(TerraformWorld tw, int rawX, int rawZ) {
        double minDistanceSquared = Double.MAX_VALUE;
        int[] min = null;
        for (int[] loc : this.strongholdPositions(tw)) {
            double distSqr = Math.pow(loc[0] - rawX, 2.0) + Math.pow(loc[1] - rawZ, 2.0);
            if (min == null) {
                minDistanceSquared = distSqr;
                min = loc;
                continue;
            }
            if (!(distSqr < minDistanceSquared)) continue;
            minDistanceSquared = distSqr;
            min = loc;
        }
        return new int[]{min[0], min[1]};
    }

    public int[] getCoordsFromMegaChunk(TerraformWorld tw, MegaChunk mc) {
        int[][] positions;
        for (int[] pos : positions = this.strongholdPositions(tw)) {
            if (!mc.containsXZBlockCoords(pos[0], pos[1])) continue;
            return pos;
        }
        return null;
    }

    @Override
    public Random getHashedRandom(TerraformWorld world, int chunkX, int chunkZ) {
        return world.getHashedRand(1999222L, chunkX, chunkZ);
    }

    @Override
    public boolean isEnabled() {
        return TConfigOption.STRUCTURES_STRONGHOLD_ENABLED.getBoolean();
    }

    @Override
    public int getChunkBufferDistance() {
        return 0;
    }
}

