/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.TerraLootTable;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class StrongholdPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;

    public StrongholdPathPopulator(Random rand) {
        this.rand = rand;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        SimpleBlock ceil = ppd.base.getRelative(0, 1, 0);
        int depth = 0;
        while (!ceil.getType().isSolid()) {
            ceil = ceil.getRelative(0, 1, 0);
            if (++depth <= 10) continue;
            return;
        }
        if (ppd.dir == BlockFace.UP) {
            this.decorateCrossroads(ppd.base, Bisected.Half.BOTTOM);
            boolean isCrossroad = true;
            ArrayList<Wall> walls = new ArrayList<Wall>();
            for (Object face : BlockUtils.directBlockFaces) {
                if (!ppd.base.getRelative(face.getModX() * 2, 2, face.getModZ() * 2).getType().isSolid()) continue;
                isCrossroad = false;
                walls.add(new Wall(ppd.base.getRelative(face.getModX() * 2, 1, face.getModZ() * 2), face.getOppositeFace()));
            }
            this.decorateCrossroads(ceil, Bisected.Half.TOP);
            if (isCrossroad) {
                for (Object face : BlockUtils.xzDiagonalPlaneBlockFaces) {
                    new Wall(ppd.base.getRelative(0, 1, 0).getRelative((BlockFace)face)).LPillar(10, this.rand, Material.COBBLESTONE_WALL, Material.ANDESITE_WALL, Material.STONE_BRICK_WALL);
                }
            } else {
                for (Wall wall : walls) {
                    wall.setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getRelative(0, 1, 0).setType(Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                    wall.getRelative(0, 2, 0).setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getRelative(0, 1, 0).getLeft().setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    wall.getRelative(0, 1, 0).getRight().setType(Material.STONE, Material.SMOOTH_STONE, Material.ANDESITE);
                    new StairBuilder(Material.ANDESITE_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(wall.getDirection())).setHalf(Bisected.Half.TOP).apply(wall.getRight());
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(wall.getDirection())).setHalf(Bisected.Half.TOP).apply(wall.getLeft());
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getLeft(wall.getDirection())).setHalf(Bisected.Half.BOTTOM).apply(wall.getRight().getRelative(0, 2, 0));
                    new StairBuilder(Material.STONE_BRICK_STAIRS, Material.POLISHED_ANDESITE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(BlockUtils.getRight(wall.getDirection())).setHalf(Bisected.Half.BOTTOM).apply(wall.getLeft().getRelative(0, 2, 0));
                }
            }
        } else {
            if (!this.verifyPathway(new Wall(ppd.base, ppd.dir))) {
                return;
            }
            if (ppd.calcRemainder(2) == 0) {
                this.decoratePathways(ppd.base, ppd.dir, Bisected.Half.BOTTOM);
                Wall base = new Wall(ppd.base, ppd.dir);
                base.getRelative(0, 1, 0).getLeft(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getRelative(0, 1, 0).getRight(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getRelative(0, 2, 0).getLeft(2).setType(Material.CHISELED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                base.getRelative(0, 2, 0).getRight(2).setType(Material.CHISELED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                base.getRelative(0, 3, 0).getLeft(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                base.getRelative(0, 4, 0).getRight(2).setType(Material.SMOOTH_STONE, Material.POLISHED_ANDESITE);
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(BlockUtils.getLeft(ppd.dir)).setHalf(Bisected.Half.TOP).apply(base.getRelative(0, 4, 0).getLeft());
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(BlockUtils.getRight(ppd.dir)).setHalf(Bisected.Half.TOP).apply(base.getRelative(0, 4, 0).getRight());
                ceil.setType(Material.CHISELED_STONE_BRICKS);
            } else {
                Wall base = new Wall(ppd.base, ppd.dir);
                new SlabBuilder(BlockUtils.stoneBrickSlabs).setType(Slab.Type.TOP).apply(base.getRelative(0, 4, 0).getLeft());
                new SlabBuilder(BlockUtils.stoneBrickSlabs).setType(Slab.Type.TOP).apply(base.getRelative(0, 4, 0).getRight());
                if (GenUtils.chance(this.rand, 1, 50)) {
                    int i = GenUtils.randInt(this.rand, 0, 1);
                    Wall w = base.getRelative(0, 1, 0);
                    for (depth = 0; !w.get().getType().isSolid() && depth < 10; ++depth) {
                        if (i == 0) {
                            w = w.getLeft();
                        }
                        if (i != 1) continue;
                        w = w.getRight();
                    }
                    if (i == 1) {
                        w = w.getLeft();
                    }
                    if (i == 0) {
                        w = w.getRight();
                    }
                    SimpleBlock cBlock = w.get();
                    cBlock.setType(Material.CHEST);
                    Chest chest = (Chest)Bukkit.createBlockData((Material)Material.CHEST);
                    if (i == 0) {
                        chest.setFacing(BlockUtils.getAdjacentFaces(ppd.dir)[1]);
                    }
                    if (i == 1) {
                        chest.setFacing(BlockUtils.getAdjacentFaces(ppd.dir)[0]);
                    }
                    cBlock.setBlockData((BlockData)chest);
                    cBlock.getPopData().lootTableChest(cBlock.getX(), cBlock.getY(), cBlock.getZ(), TerraLootTable.STRONGHOLD_CORRIDOR);
                } else if (GenUtils.chance(this.rand, 4, 25)) {
                    this.setIronBars(ppd);
                }
            }
        }
        ceil = new Wall(ppd.base.getRelative(0, 1, 0), ppd.dir).findCeiling(10).get();
        if (ceil == null) {
            return;
        }
        if (GenUtils.chance(this.rand, 3, 25)) {
            for (int i = 0; i < GenUtils.randInt(this.rand, 1, 5); ++i) {
                this.dropDownBlock(ceil.getRelative(GenUtils.randInt(this.rand, -1, 1), 0, GenUtils.randInt(this.rand, -1, 1)));
            }
        }
        if (GenUtils.chance(this.rand, 1, 25)) {
            SimpleBlock webBase = ceil.getRelative(0, -1, 0);
            webBase.setType(Material.COBWEB);
            for (int i = 0; i < GenUtils.randInt(this.rand, 0, 3); ++i) {
                BlockFace face = CoralGenerator.getRandomBlockFace();
                if (face == BlockFace.UP) {
                    face = BlockFace.SELF;
                }
                webBase.getRelative(face).setType(Material.COBWEB);
            }
        }
    }

    private boolean verifyPathway(Wall base) {
        for (int h2 = 0; h2 <= 5; ++h2) {
            for (int width = -2; width <= 2; ++width) {
                Wall rel = base.getRelative(0, h2, 0);
                if (h2 == 0 || h2 == 5 || width == -2 || width == 2) {
                    if (!rel.getLeft(width).getType().isSolid()) {
                        return false;
                    }
                    if (rel.getRight(width).getType().isSolid()) continue;
                    return false;
                }
                if (rel.getLeft(width).getType().isSolid()) {
                    return false;
                }
                if (!rel.getRight(width).getType().isSolid()) continue;
                return false;
            }
        }
        return true;
    }

    private void decorateCrossroads(SimpleBlock core, Bisected.Half isCeil) {
        core.RSolSetType(Material.CHISELED_STONE_BRICKS);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            core.getRelative(face).RSolSetBlockData((BlockData)new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(face).setHalf(isCeil).get());
        }
    }

    private void decoratePathways(SimpleBlock core, BlockFace dir, Bisected.Half isCeil) {
        core.RSolSetType(Material.CHISELED_STONE_BRICKS);
        for (BlockFace face : BlockUtils.getAdjacentFaces(dir)) {
            core.getRelative(face).RSolSetBlockData((BlockData)new StairBuilder(Material.STONE_BRICK_STAIRS, Material.COBBLESTONE_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS, Material.ANDESITE_STAIRS).setFacing(face).setHalf(isCeil).get());
        }
    }

    private boolean setIronBars(PathPopulatorData ppd) {
        Wall wall = new Wall(ppd.base, ppd.dir).getRelative(0, 4, 0);
        wall.setType(Material.IRON_BARS);
        wall.getLeft().setType(Material.IRON_BARS);
        wall.getRight().setType(Material.IRON_BARS);
        wall.getLeft().downRPillar(new Random(), 4, Material.IRON_BARS);
        wall.getRight().downRPillar(new Random(), 4, Material.IRON_BARS);
        for (int h2 = 3; h2 >= 0; --h2) {
            Wall temp = wall.getRelative(0, -h2, 0);
            BlockUtils.correctSurroundingMultifacingData(temp.get());
            BlockUtils.correctSurroundingMultifacingData(temp.getLeft().get());
            BlockUtils.correctSurroundingMultifacingData(temp.getRight().get());
        }
        return true;
    }

    private void dropDownBlock(SimpleBlock block) {
        if (block.getType().isSolid()) {
            BlockData type = block.getBlockData();
            block.setType(Material.CAVE_AIR);
            int depth = 0;
            while (!block.getType().isSolid()) {
                block = block.getRelative(0, -1, 0);
                if (++depth <= 50) continue;
                return;
            }
            if (type instanceof Slab) {
                ((Slab)type).setType(Slab.Type.BOTTOM);
            } else if (type instanceof Stairs) {
                ((Stairs)type).setHalf(Bisected.Half.BOTTOM);
            }
            if (GenUtils.chance(1, 3)) {
                block.getRelative(0, 1, 0).setBlockData(BlockUtils.infestStone(type));
            } else {
                block.getRelative(0, 1, 0).setBlockData(type);
            }
        }
    }
}

