/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.version.OneOneSixBlockHandler;
import org.terraform.utils.version.Version;

public class PrisonRoomPopulator
extends RoomPopulatorAbstract {
    public PrisonRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    private static void dangleIronBarsDown(Random rand, int length, SimpleBlock base) {
        for (int i = 0; i < length; ++i) {
            if (Version.isAtLeast(16.0)) {
                base.setType(OneOneSixBlockHandler.getChainMaterial());
            } else {
                base.setType(Material.IRON_BARS);
            }
            base = base.getRelative(0, -1, 0);
        }
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int z;
        int x;
        int[] lowerCorner = room.getLowerCorner(1);
        int[] upperCorner = room.getUpperCorner(1);
        for (int i = 0; i < GenUtils.randInt(12, 25); ++i) {
            PrisonRoomPopulator.dangleIronBarsDown(this.rand, GenUtils.randInt(room.getHeight() / 4 - 1, room.getHeight() / 2), new SimpleBlock(data, GenUtils.randInt(lowerCorner[0], upperCorner[0]), room.getY() + room.getHeight() - 1, GenUtils.randInt(lowerCorner[1], upperCorner[1])));
        }
        Material[] slabs = new Material[]{Material.STONE_BRICK_SLAB, Material.MOSSY_STONE_BRICK_SLAB, Material.STONE_SLAB, Material.SMOOTH_STONE_SLAB};
        for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                data.setBlockData(x, room.getY() + room.getHeight() / 2, z, (BlockData)new SlabBuilder(slabs).setType(Slab.Type.TOP).get());
            }
        }
        lowerCorner = room.getLowerCorner(7);
        upperCorner = room.getUpperCorner(7);
        for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                data.setType(x, room.getY() + room.getHeight() / 2, z, Material.AIR);
            }
        }
        for (int[] coords : room.getAllCorners(6)) {
            new Wall(new SimpleBlock(data, coords[0], room.getY() + 1, coords[1])).Pillar(room.getHeight(), this.rand, Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS);
        }
        Object x2 = room.getFourWalls(data, 6).entrySet().iterator();
        while (x2.hasNext()) {
            Map.Entry entry = (Map.Entry)x2.next();
            Wall w = ((Wall)entry.getKey()).getRelative(0, room.getHeight() / 2, 0);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                if (!w.getType().isSolid()) {
                    if (i != (Integer)entry.getValue() / 2) {
                        w.setType(Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                    } else {
                        w.setType(slabs);
                    }
                    BlockUtils.correctSurroundingMultifacingData(w.get());
                }
                w = w.getLeft();
            }
        }
        BlockFace dir = BlockFace.NORTH;
        dir = room.getWidthX() > room.getWidthZ() ? (new BlockFace[]{BlockFace.WEST, BlockFace.EAST})[this.rand.nextInt(1)] : (new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH})[this.rand.nextInt(1)];
        for (int[] corner : room.getCornersAlongFace(dir, 7)) {
            Wall w = new Wall(new SimpleBlock(data, corner[0], room.getY() + 1, corner[1]), dir.getOppositeFace());
            w.getRear().getRelative(0, room.getHeight() / 2, 0).setType(Material.AIR);
            BlockUtils.correctSurroundingMultifacingData(w.getRear().getRelative(0, 1, 0).get());
            for (int i = 0; i < room.getHeight() / 2; ++i) {
                w.Pillar(room.getHeight() / 2 - i, this.rand, BlockUtils.stoneBricks);
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(dir).apply(w.getRelative(0, room.getHeight() / 2 - i - 1, 0));
                w = w.getFront();
            }
        }
        for (int[] corner : room.getCornersAlongFace(BlockFace.NORTH, 2)) {
            this.placePrisonCell(new SimpleBlock(data, corner[0], room.getY() + 1 + room.getHeight() / 2, corner[1]), BlockFace.SOUTH);
        }
        for (int[] corner : room.getCornersAlongFace(BlockFace.SOUTH, 2)) {
            this.placePrisonCell(new SimpleBlock(data, corner[0], room.getY() + 1 + room.getHeight() / 2, corner[1]), BlockFace.NORTH);
        }
        Object object = room.getFourWalls(data, 4).entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            Wall w = ((Wall)entry.getKey()).getRelative(0, room.getHeight() / 2, 0);
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                if (i == (Integer)entry.getValue() / 2) {
                    w.getRelative(0, 3, 0).LPillar(room.getHeight() / 2 - 2, this.rand, BlockUtils.stoneBricks);
                    if (this.rand.nextBoolean()) {
                        data.addEntity(w.getX(), w.getY(), w.getZ(), EntityType.SKELETON);
                    }
                } else if (i == (Integer)entry.getValue() / 2 + 1 || i == (Integer)entry.getValue() / 2 - 1) {
                    w.LPillar(room.getHeight() / 2, this.rand, BlockUtils.stoneBricks);
                } else {
                    w.LPillar(room.getHeight() / 2, this.rand, Material.IRON_BARS);
                    w.CorrectMultipleFacing(room.getHeight() / 2);
                }
                if (GenUtils.chance(this.rand, 1, 35)) {
                    new ChestBuilder(Material.CHEST).setFacing(w.getDirection()).setLootTable(TerraLootTable.STRONGHOLD_CORRIDOR).apply(w.getRear(3));
                }
                w = w.getLeft();
            }
        }
    }

    public void placePrisonCell(SimpleBlock location, BlockFace doorDir) {
        Wall w = new Wall(location);
        Material[] prisonMats = new Material[]{Material.STONE_BRICKS, Material.MOSSY_STONE_BRICKS, Material.CRACKED_STONE_BRICKS, Material.IRON_BARS};
        int width = 2;
        for (int nx : new int[]{-width, width}) {
            for (int nz = -width; nz <= width; ++nz) {
                w.getRelative(nx, 0, nz).LPillar(15, this.rand, prisonMats);
            }
        }
        for (int nz : new int[]{-width, width}) {
            for (int nx = -width; nx <= width; ++nx) {
                w.getRelative(nx, 0, nz).LPillar(15, this.rand, prisonMats);
            }
        }
        SimpleBlock door = w.getRelative(doorDir, width).get();
        BlockUtils.placeDoor(door.getPopData(), Material.IRON_DOOR, door.getX(), door.getY(), door.getZ(), doorDir);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getHeight() > 8 && room.getWidthX() > 14 && room.getWidthZ() > 14 && !room.isHuge();
    }
}

