/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class LibraryRoomPopulator
extends RoomPopulatorAbstract {
    public LibraryRoomPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int i;
        int l;
        int[] upperBounds = room.getUpperCorner();
        int[] lowerBounds = room.getLowerCorner();
        HashMap<Wall, Integer> walls = room.getFourWalls(data, 1);
        for (Map.Entry<Wall, Integer> entry : walls.entrySet()) {
            Wall wall = entry.getKey().clone();
            int other = 0;
            for (int i2 = 0; i2 < entry.getValue(); ++i2) {
                if (!wall.getRear().get().getType().toString().endsWith("STONE_BRICKS")) {
                    Wall temp = wall.getRelative(0, 1, 0);
                    for (int t = 0; t < room.getHeight() && !(temp = temp.getRelative(0, 1, 0)).getRear().get().getType().toString().endsWith("STONE_BRICKS"); ++t) {
                    }
                    temp.setType(Material.CHISELED_STONE_BRICKS);
                    temp.getRelative(0, 1, 0).LPillar(room.getHeight(), this.rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                } else if (other <= 2) {
                    wall.LPillar(room.getHeight(), this.rand, Material.BOOKSHELF);
                    ++other;
                } else {
                    other = 0;
                    wall.LPillar(room.getHeight(), this.rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                    wall.getFront().LPillar(room.getHeight(), this.rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
                }
                wall = wall.getLeft();
            }
        }
        int pHeight = room.getHeight() / 2;
        for (Map.Entry<Wall, Integer> entry : walls.entrySet()) {
            Wall wall = entry.getKey().clone();
            for (l = 0; l < entry.getValue(); ++l) {
                Wall pWall = wall.getFront().getRelative(0, pHeight - 1, 0);
                if (pWall.get().getType().toString().contains("COBBLE")) {
                    for (i = 0; i < 3; ++i) {
                        front = (pWall = pWall.getFront()).get();
                        if (!front.lsetType(Material.OAK_LOG)) continue;
                        Orientable o = (Orientable)Bukkit.createBlockData((Material)Material.OAK_LOG);
                        o.setAxis(BlockUtils.getAxisFromBlockFace(wall.getDirection()));
                        front.setBlockData((BlockData)o);
                    }
                } else {
                    if (GenUtils.chance(this.rand, 5, 100)) {
                        SimpleBlock cBlock = pWall.getRelative(0, 1, 0).get();
                        cBlock.setType(Material.CHEST);
                        Chest chest = (Chest)Bukkit.createBlockData((Material)Material.CHEST);
                        chest.setFacing(pWall.getDirection());
                        cBlock.setBlockData((BlockData)chest);
                        data.lootTableChest(cBlock.getX(), cBlock.getY(), cBlock.getZ(), TerraLootTable.STRONGHOLD_LIBRARY);
                    }
                    for (i = 0; i < 3; ++i) {
                        front = pWall.get();
                        if (!front.lsetType(Material.OAK_SLAB)) {
                            pWall = pWall.getFront();
                            continue;
                        }
                        Slab s = (Slab)Bukkit.createBlockData((Material)Material.OAK_SLAB);
                        s.setType(Slab.Type.TOP);
                        front.setBlockData((BlockData)s);
                        pWall = pWall.getFront();
                    }
                }
                wall = wall.getLeft();
            }
        }
        walls.clear();
        walls = room.getFourWalls(data, 4);
        for (Map.Entry<Wall, Integer> entry : walls.entrySet()) {
            Wall wall = entry.getKey().clone().getRelative(0, pHeight, 0);
            for (l = 0; l < entry.getValue(); ++l) {
                wall.setType(Material.OAK_FENCE);
                BlockUtils.correctSurroundingMultifacingData(wall.get());
                if (GenUtils.chance(this.rand, 1, 10)) {
                    wall.getRelative(0, 1, 0).setType(Material.TORCH);
                }
                wall = wall.getLeft();
            }
        }
        ArrayList<Wall> arrayList = new ArrayList<Wall>();
        Wall stairWallOne = new Wall(new SimpleBlock(data, lowerBounds[0] + 5, room.getY() + pHeight, upperBounds[1] - 5), BlockFace.NORTH);
        Wall stairWallTwo = new Wall(new SimpleBlock(data, upperBounds[0] - 5, room.getY() + pHeight, lowerBounds[1] + 5), BlockFace.SOUTH);
        Wall stairWallThree = new Wall(new SimpleBlock(data, lowerBounds[0] + 5, room.getY() + pHeight, lowerBounds[1] + 5), BlockFace.EAST);
        Wall stairWallFour = new Wall(new SimpleBlock(data, upperBounds[0] - 5, room.getY() + pHeight, upperBounds[1] - 5), BlockFace.WEST);
        arrayList.add(stairWallOne);
        arrayList.add(stairWallTwo);
        arrayList.add(stairWallThree);
        arrayList.add(stairWallFour);
        Collections.shuffle(arrayList, this.rand);
        i = GenUtils.randInt(this.rand, 1, 4);
        for (int s = 0; s < i; ++s) {
            Wall stairWall = (Wall)arrayList.get(s);
            stairWall.getRight().getRelative(0, 1, 0).setType(Material.AIR);
            stairWall.getFront().getRight().getRelative(0, 1, 0).setType(Material.AIR);
            while (stairWall.get().getY() > room.getY()) {
                stairWall.setType(Material.OAK_STAIRS);
                Stairs d = (Stairs)Bukkit.createBlockData((Material)Material.OAK_STAIRS);
                d.setFacing(BlockUtils.getAdjacentFaces(stairWall.getDirection())[1]);
                stairWall.get().setBlockData((BlockData)d);
                stairWall.getFront().setType(Material.OAK_STAIRS);
                stairWall.getFront().get().setBlockData((BlockData)d);
                stairWall = stairWall.getLeft().getRelative(0, -1, 0);
            }
        }
        SimpleBlock core = new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ());
        for (int nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                for (int ny = 0; ny < room.getHeight() - 1; ++ny) {
                    if (ny == pHeight || ny == 0 || ny == room.getHeight() - 2) {
                        core.getRelative(nx, ny, nz).setType(Material.CHISELED_STONE_BRICKS);
                        continue;
                    }
                    core.getRelative(nx, ny, nz).setType(Material.IRON_BARS);
                    BlockUtils.correctSurroundingMultifacingData(core.getRelative(nx, ny, nz));
                }
            }
        }
        BlockUtils.spawnPillar(this.rand, data, room.getX(), room.getY() + 1, room.getZ(), Material.BOOKSHELF, room.getHeight() - 2, room.getHeight() - 2);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.isHuge();
    }
}

