/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.stronghold;

import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.structure.stronghold.PrisonRoomPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.StairBuilder;

public class HallwayPopulator
extends RoomPopulatorAbstract {
    public HallwayPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        Wall w;
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            w = entry.getKey();
            boolean wasAir = false;
            for (int i = 0; i < entry.getValue(); ++i) {
                new StairBuilder(Material.STONE_BRICK_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w.getRelative(0, 4, 0));
                w.getRelative(0, 5, 0).LPillar(room.getHeight(), this.rand, BlockUtils.stoneBricks);
                if (!w.getRear().getRelative(0, 1, 0).getType().isSolid()) {
                    wasAir = true;
                    w.getRelative(0, 5, 0).setType(Material.CHISELED_STONE_BRICKS, Material.CHISELED_STONE_BRICKS, Material.COBBLESTONE);
                } else {
                    if (wasAir || !w.getLeft().getRear().getRelative(0, 1, 0).getType().isSolid()) {
                        w.getRear().Pillar(5, this.rand, Material.STONE, Material.SMOOTH_STONE);
                    }
                    wasAir = false;
                }
                w = w.getLeft();
            }
        }
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            w = entry.getKey().getRelative(0, room.getHeight() - 1, 0);
            for (int i = 0; i < entry.getValue(); ++i) {
                new StairBuilder(Material.ANDESITE_STAIRS, Material.STONE_BRICK_STAIRS, Material.MOSSY_STONE_BRICK_STAIRS).setFacing(w.getDirection().getOppositeFace()).setHalf(Bisected.Half.TOP).apply(w);
                w = w.getLeft();
            }
        }
        for (Object coords : (Object)room.getAllCorners(1)) {
            new Wall(new SimpleBlock(data, (int)coords[0], room.getY() + 1, (int)coords[1])).Pillar(room.getHeight() - 1, this.rand, BlockUtils.stoneBricks);
        }
        for (int i = 0; i < GenUtils.randInt(this.rand, room.getWidthX(), room.getWidthX() * room.getWidthZ() / 10); ++i) {
            int[] randomCoords = room.randomCoords(this.rand, 1);
            SimpleBlock ceil = new SimpleBlock(data, randomCoords[0], room.getY() + room.getHeight(), randomCoords[2]);
            if (GenUtils.chance(this.rand, 4, 25)) {
                for (int j = 0; j < GenUtils.randInt(this.rand, 1, 5); ++j) {
                    this.dropDownBlock(ceil.getRelative(GenUtils.randInt(this.rand, -1, 1), 0, GenUtils.randInt(this.rand, -1, 1)));
                }
            }
            if (!GenUtils.chance(this.rand, 1, 5)) continue;
            SimpleBlock webBase = ceil.getRelative(0, -1, 0);
            webBase.setType(Material.COBWEB);
            for (int j = 0; j < GenUtils.randInt(this.rand, 0, 3); ++j) {
                BlockFace face = CoralGenerator.getRandomBlockFace();
                if (face == BlockFace.UP) {
                    face = BlockFace.SELF;
                }
                if (webBase.getRelative(face).getType().isSolid()) continue;
                webBase.getRelative(face).setType(Material.COBWEB);
            }
        }
    }

    private void dropDownBlock(SimpleBlock block) {
        if (block.getType().isSolid()) {
            BlockData type = block.getBlockData();
            block.setType(Material.CAVE_AIR);
            int depth = 0;
            while (!block.getType().isSolid()) {
                block = block.getRelative(0, -1, 0);
                if (++depth <= 50) continue;
                return;
            }
            if (type instanceof Slab) {
                ((Slab)type).setType(Slab.Type.BOTTOM);
            } else if (type instanceof Stairs) {
                ((Stairs)type).setHalf(Bisected.Half.BOTTOM);
            }
            if (GenUtils.chance(1, 3)) {
                block.getRelative(0, 1, 0).setBlockData(BlockUtils.infestStone(type));
            } else {
                block.getRelative(0, 1, 0).setBlockData(type);
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return !new PrisonRoomPopulator(new Random(), false, false).canPopulate(room) && room.isBig() && !room.isHuge();
    }
}

