/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.small;

import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.schematic.SchematicParser;
import org.terraform.schematic.TerraSchematic;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class DesertWellPopulator {
    public void populate(TerraformWorld tw, Random random, PopulatorDataAbstract data, boolean badlandsWell) {
        int z;
        int height;
        if (!TConfigOption.STRUCTURES_DESERTWELL_ENABLED.getBoolean()) {
            return;
        }
        int x = data.getChunkX() * 16 + random.nextInt(16);
        if (!BlockUtils.isWet(new SimpleBlock(data, x, (height = GenUtils.getHighestGround(data, x, z = data.getChunkZ() * 16 + random.nextInt(16))) + 1, z))) {
            this.spawnDesertWell(tw, random, data, x, height, z, badlandsWell);
        }
    }

    public void spawnDesertWell(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int y, int z, boolean badlandsWell) {
        SimpleBlock core = new SimpleBlock(data, x, --y, z);
        TerraformGeneratorPlugin.logger.info("Spawning Desert Well at " + core.getCoords());
        try {
            TerraSchematic desertWell = TerraSchematic.load("desert_well", core);
            desertWell.parser = new DesertWellSchematicParser(random, badlandsWell);
            desertWell.apply();
            core = core.getRelative(1, 0, 1);
            for (int nx = -3; nx <= 3; ++nx) {
                for (int nz = -3; nz <= 3; ++nz) {
                    if (!badlandsWell) {
                        new Wall(core.getRelative(nx, -1, nz)).downLPillar(random, 10, Material.SANDSTONE, Material.CHISELED_SANDSTONE, Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE);
                        continue;
                    }
                    new Wall(core.getRelative(nx, -1, nz)).downLPillar(random, 10, Material.RED_SANDSTONE, Material.CHISELED_RED_SANDSTONE, Material.CUT_RED_SANDSTONE, Material.SMOOTH_RED_SANDSTONE);
                }
            }
            int depth = GenUtils.randInt(random, 5, 30);
            for (int i = 0; i < depth; ++i) {
                if (i < depth - 3) {
                    core.getRelative(0, -i, 0).setType(Material.CAVE_AIR);
                    continue;
                }
                core.getRelative(0, -i, 0).setType(Material.WATER);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static class DesertWellSchematicParser
    extends SchematicParser {
        private final Random rand;
        private final boolean badlandsWell;

        public DesertWellSchematicParser(Random rand, boolean badlandsWell) {
            this.rand = rand;
            this.badlandsWell = badlandsWell;
        }

        @Override
        public void applyData(SimpleBlock block, BlockData data) {
            if (this.badlandsWell) {
                if ((data = Bukkit.createBlockData((String)StringUtils.replace((String)data.getAsString(), (String)"sandstone", (String)"red_sandstone"))).getMaterial() == Material.RED_SANDSTONE && this.rand.nextInt(5) == 0) {
                    data = Bukkit.createBlockData((Material)Material.CHISELED_RED_SANDSTONE);
                    super.applyData(block, data);
                    return;
                }
                if (data.getMaterial() != Material.RED_SANDSTONE_STAIRS && data.getMaterial() != Material.RED_SANDSTONE_WALL && data.getMaterial().toString().contains("RED_SANDSTONE")) {
                    data = Bukkit.createBlockData((String)StringUtils.replace((String)data.getAsString(), (String)"red_sandstone", (String)GenUtils.randMaterial(this.rand, Material.RED_SANDSTONE, Material.SMOOTH_RED_SANDSTONE, Material.CUT_RED_SANDSTONE).name().toLowerCase(Locale.ENGLISH)));
                    super.applyData(block, data);
                } else {
                    super.applyData(block, data);
                }
                return;
            }
            if (data.getMaterial() == Material.SANDSTONE && this.rand.nextInt(5) == 0) {
                data = Bukkit.createBlockData((Material)Material.CHISELED_SANDSTONE);
                super.applyData(block, data);
                return;
            }
            if (data.getMaterial() != Material.SANDSTONE_STAIRS && data.getMaterial() != Material.SANDSTONE_WALL && data.getMaterial().toString().contains("SANDSTONE")) {
                data = Bukkit.createBlockData((String)StringUtils.replace((String)data.getAsString(), (String)"sandstone", (String)GenUtils.randMaterial(this.rand, Material.SANDSTONE, Material.SMOOTH_SANDSTONE, Material.CUT_SANDSTONE).name().toLowerCase(Locale.ENGLISH)));
                super.applyData(block, data);
            } else {
                super.applyData(block, data);
            }
        }
    }
}

