/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.room;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.CarvedRoom;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathGenerator;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomLayout;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.GenUtils;
import org.terraform.utils.MazeSpawner;

public class RoomLayoutGenerator {
    private final HashSet<PathGenerator> pathGens = new HashSet();
    private final HashSet<PathPopulatorData> pathPopulators = new HashSet();
    private final HashSet<CubeRoom> rooms = new HashSet();
    private final int[] upperBound;
    private final int[] lowerBound;
    private final ArrayList<RoomPopulatorAbstract> roomPops = new ArrayList();
    private final RoomLayout layout;
    boolean genPaths = true;
    boolean allowOverlaps = false;
    private int numRooms;
    private int centX;
    private int centY;
    private int centZ;
    private Random rand;
    private int range;
    private PathPopulatorAbstract pathPop;
    private boolean carveRooms = false;
    private float xCarveMul = 1.0f;
    private float yCarveMul = 1.0f;
    private float zCarveMul = 1.0f;
    private boolean pyramidish = false;
    private MazeSpawner mazePathGenerator;
    private int tile = -1;
    private int roomMaxHeight = 7;
    private int roomMinHeight = 5;
    private int roomMaxX = 15;
    private int roomMinX = 10;
    private int roomMaxZ = 15;
    private int roomMinZ = 10;

    public RoomLayoutGenerator(Random random, RoomLayout layout, int numRooms, int centX, int centY, int centZ, int range) {
        this.numRooms = numRooms;
        this.layout = layout;
        this.centX = centX;
        this.centY = centY;
        this.centZ = centZ;
        this.rand = random;
        this.range = range;
        this.upperBound = new int[]{centX + range / 2, centZ + range / 2};
        this.lowerBound = new int[]{centX - range / 2, centZ - range / 2};
    }

    public int[] getCenter() {
        return new int[]{this.centX, this.centY, this.centZ};
    }

    public void setPathPopulator(PathPopulatorAbstract pop) {
        this.pathPop = pop;
    }

    public void setCarveRooms(boolean carve) {
        this.carveRooms = carve;
    }

    public void setCarveRoomsMultiplier(float xMul, float yMul, float zMul) {
        this.xCarveMul = xMul;
        this.yCarveMul = yMul;
        this.zCarveMul = zMul;
    }

    public void registerRoomPopulator(RoomPopulatorAbstract pop) {
        this.roomPops.add(pop);
    }

    public void reset() {
        this.rooms.clear();
    }

    public void generate() {
        this.generate(true);
    }

    public void setPyramid(boolean pyramidish) {
        this.pyramidish = pyramidish;
    }

    public CubeRoom forceAddRoom(int widthX, int widthZ, int heightY) {
        if (this.layout == RoomLayout.RANDOM_BRUTEFORCE) {
            CubeRoom room = new CubeRoom(widthX, widthZ, heightY, this.centX + GenUtils.randInt(this.rand, -this.range / 2, this.range / 2), this.centY, this.centZ + GenUtils.randInt(this.rand, -this.range / 2, this.range / 2));
            boolean canAdd = false;
            block0: while (!canAdd) {
                canAdd = true;
                if (this.allowOverlaps) continue;
                for (CubeRoom other : this.rooms) {
                    if (!other.isOverlapping(room)) continue;
                    canAdd = false;
                    room = new CubeRoom(widthX, widthZ, heightY, this.centX + GenUtils.randInt(this.rand, -this.range / 2, this.range / 2), this.centY, this.centZ + GenUtils.randInt(this.rand, -this.range / 2, this.range / 2));
                    continue block0;
                }
            }
            this.rooms.add(room);
            return room;
        }
        return null;
    }

    public void generate(boolean normalise) {
        for (int i = 0; i < this.numRooms; ++i) {
            boolean canAdd;
            int widthX = GenUtils.randInt(this.rand, this.roomMinX, this.roomMaxX);
            int widthZ = GenUtils.randInt(this.rand, this.roomMinZ, this.roomMaxZ);
            int nx = GenUtils.randInt(this.rand, -this.range / 2, this.range / 2);
            int nz = GenUtils.randInt(this.rand, -this.range / 2, this.range / 2);
            if (normalise) {
                if (widthX < widthZ / 2) {
                    widthX = widthZ + GenUtils.randInt(this.rand, -2, 2);
                }
                if (widthZ < widthX / 2) {
                    widthZ = widthX + GenUtils.randInt(this.rand, -2, 2);
                }
            }
            int heightY = GenUtils.randInt(this.rand, this.roomMinHeight, this.roomMaxHeight);
            if (this.pyramidish) {
                double heightRange = 1.0 - (Math.pow(nx, 2.0) + Math.pow(nz, 2.0)) / Math.pow((float)this.range / 2.0f, 2.0);
                if (heightRange * (double)this.roomMaxHeight < (double)this.roomMinHeight) {
                    heightRange = (float)this.roomMinHeight / (float)this.roomMaxHeight;
                }
                heightY = GenUtils.randInt(this.rand, this.roomMinHeight, (int)((double)this.roomMaxHeight * heightRange));
            }
            if (normalise) {
                if (heightY > widthX) {
                    heightY = widthX + GenUtils.randInt(this.rand, -2, 2);
                }
                if (heightY < widthX / 3) {
                    heightY = widthX / 3 + GenUtils.randInt(this.rand, -2, 2);
                }
            }
            CubeRoom room = new CubeRoom(widthX, widthZ, heightY, nx + this.centX, this.centY, nz + this.centZ);
            if (this.layout == RoomLayout.RANDOM_BRUTEFORCE) {
                canAdd = true;
                if (!this.allowOverlaps) {
                    for (CubeRoom other : this.rooms) {
                        if (!other.isOverlapping(room)) continue;
                        canAdd = false;
                        break;
                    }
                }
                if (!canAdd) continue;
                this.rooms.add(room);
                continue;
            }
            if (this.layout != RoomLayout.OVERLAP_CONNECTED) continue;
            room.setX(this.centX + GenUtils.randInt(this.rand, -4, 4));
            room.setZ(this.centZ + GenUtils.randInt(this.rand, -4, 4));
            canAdd = true;
            for (CubeRoom other : this.rooms) {
                if (!other.envelopesOrIsInside(room)) continue;
                canAdd = false;
                break;
            }
            for (CubeRoom other : this.rooms) {
                if (other.isOverlapping(room)) continue;
                canAdd = false;
                break;
            }
            if (!canAdd) continue;
            this.rooms.add(room);
        }
    }

    public boolean anyOverlaps() {
        if (this.allowOverlaps) {
            return false;
        }
        for (CubeRoom room : this.rooms) {
            for (CubeRoom other : this.rooms) {
                if (other.isClone(room) || !room.isOverlapping(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInRoom(int[] coords) {
        for (CubeRoom room : this.rooms) {
            if (!room.isPointInside(coords)) continue;
            return true;
        }
        return false;
    }

    public void setGenPaths(boolean genPaths) {
        this.genPaths = genPaths;
    }

    public void setAllowOverlaps(boolean allowOverlaps) {
        this.allowOverlaps = allowOverlaps;
    }

    public void runRoomPopulators(PopulatorDataAbstract data, TerraformWorld tw) {
        Iterator<RoomPopulatorAbstract> it = this.roomPops.iterator();
        block0: while (it.hasNext()) {
            RoomPopulatorAbstract pops = it.next();
            if (!pops.isForceSpawn()) continue;
            for (CubeRoom room : this.rooms) {
                if (room.pop != null || !pops.canPopulate(room)) continue;
                room.setRoomPopulator(pops);
                if (!pops.isUnique()) continue block0;
                it.remove();
                continue block0;
            }
        }
        if (this.roomPops.isEmpty()) {
            return;
        }
        for (CubeRoom room : this.rooms) {
            if (room.pop == null) {
                List shuffled = (List)this.roomPops.clone();
                Collections.shuffle(shuffled, this.rand);
                for (RoomPopulatorAbstract roomPop : shuffled) {
                    if (!roomPop.canPopulate(room)) continue;
                    room.setRoomPopulator(roomPop);
                    if (!roomPop.isUnique()) break;
                    this.roomPops.remove(roomPop);
                    break;
                }
            }
            if (room.pop != null) {
                TerraformGeneratorPlugin.logger.info("Registered: " + room.pop.getClass().getName() + " at " + room.getX() + " " + room.getY() + " " + room.getZ() + " in a room of size " + room.getWidthX() + "x" + room.getWidthZ());
                room.populate(data);
                continue;
            }
            TerraformGeneratorPlugin.logger.info("Registered: plain room at " + room.getX() + " " + room.getY() + " " + room.getZ() + " in a room of size " + room.getWidthX() + "x" + room.getWidthZ());
        }
    }

    public void fill(PopulatorDataAbstract data, TerraformWorld tw, Material ... mat) {
        if (this.genPaths) {
            if (this.mazePathGenerator != null) {
                this.mazePathGenerator.setRand(this.rand);
                this.mazePathGenerator.setCore(new SimpleBlock(data, this.getCentX(), this.getCentY() + 1, this.getCentZ()));
                if (this.mazePathGenerator.getWidthX() == -1) {
                    this.mazePathGenerator.setWidthX(this.range);
                }
                if (this.mazePathGenerator.getWidthZ() == -1) {
                    this.mazePathGenerator.setWidthZ(this.range);
                }
                this.mazePathGenerator.prepareMaze();
                this.mazePathGenerator.carveMaze(false, mat);
            } else {
                for (CubeRoom room : this.rooms) {
                    SimpleBlock base = new SimpleBlock(data, room.getX() + room.getX() % (this.pathPop.getPathWidth() * 2 + 1), room.getY(), room.getZ() + room.getZ() % (this.pathPop.getPathWidth() * 2 + 1));
                    PathGenerator gen = new PathGenerator(base, mat, this.rand, this.upperBound, this.lowerBound, this.pathPop.getPathMaxBend());
                    if (this.pathPop != null) {
                        gen.setPopulator(this.pathPop);
                    }
                    while (!gen.isDead()) {
                        gen.next();
                    }
                    this.pathGens.add(gen);
                }
            }
        }
        for (CubeRoom room : this.rooms) {
            if (this.carveRooms) {
                if ((room = new CarvedRoom(room)).largerThanVolume(40000)) {
                    ((CarvedRoom)room).setFrequency(0.03f);
                }
                ((CarvedRoom)room).setxMultiplier(this.xCarveMul);
                ((CarvedRoom)room).setyMultiplier(this.yCarveMul);
                ((CarvedRoom)room).setzMultiplier(this.zCarveMul);
            }
            if (this.allowOverlaps) {
                room.fillRoom(data, this.tile, mat, Material.CAVE_AIR);
                continue;
            }
            room.fillRoom(data, this.tile, mat, Material.AIR);
        }
        if (this.mazePathGenerator != null && this.pathPop != null) {
            for (PathPopulatorData pPData : this.mazePathGenerator.pathPopDatas) {
                if (this.isInRoom(new int[]{pPData.base.getX(), pPData.base.getZ()})) continue;
                this.pathPop.populate(pPData);
            }
        } else {
            for (PathGenerator pGen : this.pathGens) {
                pGen.populate();
            }
        }
        if (this.roomPops.isEmpty()) {
            return;
        }
        this.runRoomPopulators(data, tw);
    }

    public void carveRoomsOnly(PopulatorDataAbstract data, TerraformWorld tw, Material ... mat) {
        for (CubeRoom room : this.rooms) {
            if (this.carveRooms) {
                if ((room = new CarvedRoom(room)).largerThanVolume(40000)) {
                    ((CarvedRoom)room).setFrequency(0.03f);
                }
                ((CarvedRoom)room).setxMultiplier(this.xCarveMul);
                ((CarvedRoom)room).setyMultiplier(this.yCarveMul);
                ((CarvedRoom)room).setzMultiplier(this.zCarveMul);
            }
            if (this.allowOverlaps) {
                room.fillRoom(data, this.tile, mat, Material.CAVE_AIR);
                continue;
            }
            room.fillRoom(data, this.tile, mat, Material.AIR);
        }
    }

    public void fillRoomsOnly(PopulatorDataAbstract data, TerraformWorld tw, Material ... mat) {
        this.carveRoomsOnly(data, tw, mat);
        if (this.roomPops.isEmpty()) {
            return;
        }
        this.runRoomPopulators(data, tw);
    }

    public void carvePathsOnly(PopulatorDataAbstract data, TerraformWorld tw, Material ... mat) {
        if (this.genPaths) {
            for (CubeRoom room : this.rooms) {
                SimpleBlock base = new SimpleBlock(data, room.getX(), room.getY(), room.getZ());
                PathGenerator gen = new PathGenerator(base, mat, this.rand, this.upperBound, this.lowerBound, this.pathPop.getPathMaxBend());
                if (this.pathPop != null) {
                    gen.setPopulator(this.pathPop);
                }
                while (!gen.isDead()) {
                    gen.next();
                }
                this.pathGens.add(gen);
            }
        }
    }

    public void populatePathsOnly() {
        for (PathGenerator pGen : this.pathGens) {
            pGen.populate();
        }
    }

    public void fillPathsOnly(PopulatorDataAbstract data, TerraformWorld tw, Material ... mat) {
        this.carvePathsOnly(data, tw, mat);
        this.populatePathsOnly();
    }

    public int getNumRooms() {
        return this.numRooms;
    }

    public void setNumRooms(int numRooms) {
        this.numRooms = numRooms;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getRoomMaxHeight() {
        return this.roomMaxHeight;
    }

    public void setRoomMaxHeight(int roomMaxHeight) {
        this.roomMaxHeight = roomMaxHeight;
    }

    public int getRoomMinHeight() {
        return this.roomMinHeight;
    }

    public void setRoomMinHeight(int roomMinHeight) {
        this.roomMinHeight = roomMinHeight;
    }

    public HashSet<CubeRoom> getRooms() {
        return this.rooms;
    }

    public int getRoomMaxX() {
        return this.roomMaxX;
    }

    public void setRoomMaxX(int roomMaxX) {
        this.roomMaxX = roomMaxX;
    }

    public int getRoomMinX() {
        return this.roomMinX;
    }

    public void setRoomMinX(int roomMinX) {
        this.roomMinX = roomMinX;
    }

    public int getRoomMaxZ() {
        return this.roomMaxZ;
    }

    public void setRoomMaxZ(int roomMaxZ) {
        this.roomMaxZ = roomMaxZ;
    }

    public int getRoomMinZ() {
        return this.roomMinZ;
    }

    public void setRoomMinZ(int roomMinZ) {
        this.roomMinZ = roomMinZ;
    }

    public int getCentX() {
        return this.centX;
    }

    public void setCentX(int centX) {
        this.centX = centX;
    }

    public int getCentY() {
        return this.centY;
    }

    public void setCentY(int centY) {
        this.centY = centY;
    }

    public int getCentZ() {
        return this.centZ;
    }

    public void setCentZ(int centZ) {
        this.centZ = centZ;
    }

    public Random getRand() {
        return this.rand;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public PathPopulatorAbstract getPathPop() {
        return this.pathPop;
    }

    public void setTile(int tile) {
        this.tile = tile;
    }

    public void setMazePathGenerator(MazeSpawner mazePathGenerator) {
        this.mazePathGenerator = mazePathGenerator;
    }

    public HashSet<PathPopulatorData> getPathPopulators() {
        if (this.pathPopulators.isEmpty()) {
            for (PathGenerator pGen : this.pathGens) {
                this.pathPopulators.addAll(pGen.path);
            }
        }
        return this.pathPopulators;
    }

    public boolean isPointInPath(Wall w, int rearOffset, int includeWidth) {
        if (this.getPathPopulators().contains(new PathPopulatorData(w.getRear(rearOffset).getAtY(this.centY), 3))) {
            return true;
        }
        if (includeWidth != 0) {
            for (int i = 1; i < includeWidth; ++i) {
                if (this.getPathPopulators().contains(new PathPopulatorData(w.getRear(rearOffset).getLeft(i).getAtY(this.centY), 3))) {
                    return true;
                }
                if (!this.getPathPopulators().contains(new PathPopulatorData(w.getRear(rearOffset).getRight(i).getAtY(this.centY), 3))) continue;
                return true;
            }
        }
        return false;
    }
}

