/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.room;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PathGenerator {
    private final int[] upperBound;
    private final int[] lowerBound;
    HashSet<PathPopulatorData> path = new HashSet();
    PathPopulatorAbstract populator;
    Random rand;
    Material[] mat;
    private SimpleBlock base;
    private BlockFace dir;
    private int maxNoBend = 15;
    private int straightInARow = 0;
    private int length = 0;
    private int pathWidth = 3;
    private int pathHeight = 3;
    private boolean dead = false;

    public PathGenerator(SimpleBlock origin, Material[] mat, Random rand, int[] upperBound, int[] lowerBound, int maxNoBend) {
        this.base = origin;
        this.rand = rand;
        this.dir = BlockUtils.directBlockFaces[GenUtils.randInt(rand, 0, 3)];
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.mat = mat;
        this.maxNoBend = maxNoBend != -1 ? maxNoBend : (int)((double)(upperBound[0] - lowerBound[0]) * 0.5);
    }

    public boolean isDead() {
        return this.dead;
    }

    private boolean isOutOfBounds(SimpleBlock base) {
        return base.getX() >= this.upperBound[0] + 10 || base.getZ() >= this.upperBound[1] + 10 || base.getX() <= this.lowerBound[0] - 10 || base.getZ() <= this.lowerBound[1] - 10;
    }

    public void die() {
        this.dead = true;
        this.wall();
        PathPopulatorData candidate = new PathPopulatorData(this.base, this.dir, this.pathWidth, false);
        candidate.isEnd = true;
        if (!this.path.contains(candidate)) {
            this.path.add(candidate);
        } else {
            this.path.remove(candidate);
            candidate.isOverlapped = true;
            this.path.add(candidate);
        }
    }

    public void populate() {
        if (this.populator != null) {
            for (PathPopulatorData pathPopulatorData : this.path) {
                this.populator.populate(pathPopulatorData);
            }
        }
    }

    public void next() {
        PathPopulatorData candidate;
        if (this.length > this.upperBound[0] - this.lowerBound[0]) {
            this.die();
            return;
        }
        if (this.isOutOfBounds(this.base)) {
            this.die();
            return;
        }
        BlockFace oldDir = this.dir;
        if (this.length % (1 + 2 * this.pathWidth) == 0) {
            int i;
            int cover;
            while (this.isOutOfBounds(this.base.getRelative(this.dir))) {
                this.straightInARow = 0;
                cover = this.pathWidth - 1;
                if (cover == 0) {
                    cover = 1;
                }
                for (i = 0; i < cover; ++i) {
                    this.setHall();
                    this.base = this.base.getRelative(this.dir);
                }
                for (i = 0; i < cover; ++i) {
                    this.base = this.base.getRelative(this.dir.getOppositeFace());
                }
                this.dir = BlockUtils.getTurnBlockFace(this.rand, this.dir);
            }
            ++this.straightInARow;
            if (this.straightInARow > this.maxNoBend || GenUtils.chance(this.rand, 1, 500)) {
                this.straightInARow = 0;
                cover = this.pathWidth - 1;
                if (cover == 0) {
                    cover = 1;
                }
                for (i = 0; i < cover; ++i) {
                    this.setHall();
                    this.base = this.base.getRelative(this.dir);
                }
                for (i = 0; i < cover; ++i) {
                    this.base = this.base.getRelative(this.dir.getOppositeFace());
                }
                this.dir = BlockUtils.getTurnBlockFace(this.rand, this.dir);
            }
        }
        if (!this.populator.customCarve(this.base, this.dir, this.pathWidth)) {
            this.setHall();
        }
        if (!this.path.contains(candidate = new PathPopulatorData(this.base, this.dir, this.pathWidth, oldDir != this.dir))) {
            this.path.add(candidate);
        } else {
            this.path.remove(candidate);
            candidate.isOverlapped = true;
            this.path.add(candidate);
        }
        oldDir = this.dir;
        this.base = this.base.getRelative(this.dir);
        ++this.length;
    }

    private void wall() {
        if (this.mat[0] == Material.BARRIER) {
            return;
        }
        for (int h2 = 1; h2 <= this.pathHeight; ++h2) {
            if (this.base.getRelative(0, h2, 0).getType() == Material.CAVE_AIR) continue;
            this.base.getRelative(0, h2, 0).setType(GenUtils.randMaterial(this.mat));
        }
        for (BlockFace f : BlockUtils.getAdjacentFaces(this.dir)) {
            SimpleBlock rel = this.base;
            for (int i = 0; i <= this.pathWidth / 2; ++i) {
                rel = rel.getRelative(f);
                for (int h3 = 1; h3 <= this.pathHeight; ++h3) {
                    if (rel.getRelative(0, h3, 0).getType() == Material.CAVE_AIR) continue;
                    rel.getRelative(0, h3, 0).setType(GenUtils.randMaterial(this.mat));
                }
            }
        }
    }

    private void setHall() {
        if (this.mat[0] == Material.BARRIER) {
            return;
        }
        if (this.base.getType() != Material.CAVE_AIR) {
            this.base.setType(GenUtils.randMaterial(this.mat));
        }
        Wall w = new Wall(this.base).getRelative(0, 1, 0);
        w.Pillar(this.pathHeight, this.rand, Material.CAVE_AIR);
        if (this.base.getRelative(0, this.pathHeight + 1, 0).getType() != Material.CAVE_AIR) {
            this.base.getRelative(0, this.pathHeight + 1, 0).setType(GenUtils.randMaterial(this.mat));
        }
        for (BlockFace f : BlockUtils.getAdjacentFaces(this.dir)) {
            SimpleBlock rel = this.base;
            for (int i = 0; i <= this.pathWidth / 2; ++i) {
                rel = rel.getRelative(f);
                if (i == this.pathWidth / 2) {
                    for (int h2 = 1; h2 <= this.pathHeight; ++h2) {
                        if (rel.getRelative(0, h2, 0).getType() == Material.CAVE_AIR) continue;
                        rel.getRelative(0, h2, 0).setType(GenUtils.randMaterial(this.mat));
                    }
                    continue;
                }
                if (rel.getType() != Material.CAVE_AIR) {
                    rel.setType(GenUtils.randMaterial(this.mat));
                }
                w = new Wall(rel).getRelative(0, 1, 0);
                w.Pillar(this.pathHeight, this.rand, Material.CAVE_AIR);
                if (rel.getRelative(0, this.pathHeight + 1, 0).getType() == Material.CAVE_AIR) continue;
                rel.getRelative(0, this.pathHeight + 1, 0).setType(GenUtils.randMaterial(this.mat));
            }
        }
    }

    public void generateStraightPath(SimpleBlock start, BlockFace direction, int length) {
        ArrayList<PathPopulatorData> pathPopulatorDatas = new ArrayList<PathPopulatorData>();
        if (direction == null) {
            direction = this.dir;
        }
        if (start == null) {
            start = this.base;
        }
        for (int i = 0; i < length; ++i) {
            if (!this.populator.customCarve(start, direction, this.pathWidth)) {
                this.setHall();
            }
            start = start.getRelative(direction);
            pathPopulatorDatas.add(new PathPopulatorData(start, direction, this.pathWidth, false));
        }
        if (this.populator != null) {
            for (PathPopulatorData pathPopulatorData : pathPopulatorDatas) {
                this.populator.populate(pathPopulatorData);
            }
        }
    }

    public void setPopulator(PathPopulatorAbstract populator) {
        this.populator = populator;
        this.pathWidth = populator.getPathWidth();
        this.pathHeight = populator.getPathHeight();
    }
}

