/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.room;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.GenUtils;

public class CubeRoom {
    int widthX;
    int widthZ;
    int height;
    int x;
    int y;
    int z;
    RoomPopulatorAbstract pop;
    boolean isActivated = false;

    public CubeRoom(int widthX, int widthZ, int height, int x, int y, int z) {
        this.widthX = widthX;
        this.widthZ = widthZ;
        this.height = height;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public AbstractMap.SimpleEntry<Wall, Integer> getWall(PopulatorDataAbstract data, BlockFace face, int padding) {
        Wall wall;
        int[] lowerBounds = this.getLowerCorner();
        int[] upperBounds = this.getUpperCorner();
        int length = 0;
        switch (face) {
            case SOUTH: {
                wall = new Wall(new SimpleBlock(data, lowerBounds[0] + padding, this.y + 1, upperBounds[1] - padding), BlockFace.NORTH);
                length = this.widthX - 2 * padding;
                break;
            }
            case NORTH: {
                wall = new Wall(new SimpleBlock(data, upperBounds[0] - padding, this.y + 1, lowerBounds[1] + padding), BlockFace.SOUTH);
                length = this.widthX - 2 * padding;
                break;
            }
            case WEST: {
                wall = new Wall(new SimpleBlock(data, lowerBounds[0] + padding, this.y + 1, lowerBounds[1] + padding), BlockFace.EAST);
                length = this.widthZ - 2 * padding;
                break;
            }
            case EAST: {
                wall = new Wall(new SimpleBlock(data, upperBounds[0] - padding, this.y + 1, upperBounds[1] - padding), BlockFace.WEST);
                length = this.widthZ - 2 * padding;
                break;
            }
            default: {
                wall = null;
                TerraformGeneratorPlugin.logger.error("Invalid wall direction requested!");
            }
        }
        AbstractMap.SimpleEntry<Object, Integer> walls = new AbstractMap.SimpleEntry<Object, Integer>(wall, length);
        return walls;
    }

    public HashMap<Wall, Integer> getFourWalls(PopulatorDataAbstract data, int padding) {
        int[] lowerBounds = this.getLowerCorner();
        int[] upperBounds = this.getUpperCorner();
        HashMap<Wall, Integer> walls = new HashMap<Wall, Integer>();
        Wall north = new Wall(new SimpleBlock(data, lowerBounds[0] + padding, this.y + 1, upperBounds[1] - padding), BlockFace.NORTH);
        Wall south = new Wall(new SimpleBlock(data, upperBounds[0] - padding, this.y + 1, lowerBounds[1] + padding), BlockFace.SOUTH);
        Wall east = new Wall(new SimpleBlock(data, lowerBounds[0] + padding, this.y + 1, lowerBounds[1] + padding), BlockFace.EAST);
        Wall west = new Wall(new SimpleBlock(data, upperBounds[0] - padding, this.y + 1, upperBounds[1] - padding), BlockFace.WEST);
        walls.put(north, this.widthX - 2 * padding);
        walls.put(south, this.widthX - 2 * padding);
        walls.put(east, this.widthZ - 2 * padding);
        walls.put(west, this.widthZ - 2 * padding);
        return walls;
    }

    public void setRoomPopulator(RoomPopulatorAbstract pop) {
        this.pop = pop;
    }

    public void populate(PopulatorDataAbstract data) {
        if (this.pop != null) {
            this.pop.populate(data, this);
        }
    }

    public void fillRoom(PopulatorDataAbstract data, Material ... mat) {
        this.fillRoom(data, -1, mat, Material.AIR);
    }

    public void fillRoom(PopulatorDataAbstract data, int tile, Material[] mat, Material fillMat) {
        int nz;
        int ny;
        int nx;
        int tileIndex = 0;
        if (mat[0] != Material.BARRIER) {
            for (nx = this.x - this.widthX / 2; nx <= this.x + this.widthX / 2; ++nx) {
                for (ny = this.y; ny <= this.y + this.height; ++ny) {
                    for (nz = this.z - this.widthZ / 2; nz <= this.z + this.widthZ / 2; ++nz) {
                        if (data.getType(nx, ny, nz) == Material.CAVE_AIR) continue;
                        if (tile == -1) {
                            data.setType(nx, ny, nz, GenUtils.randMaterial(mat));
                            continue;
                        }
                        data.setType(nx, ny, nz, mat[Math.abs(nz + this.widthZ / 2 + ny + nx + this.widthX / 2 - tileIndex) % mat.length]);
                        if (++tileIndex != 2) continue;
                        tileIndex = 0;
                    }
                }
            }
        }
        for (nx = this.x - this.widthX / 2 + 1; nx <= this.x + this.widthX / 2 - 1; ++nx) {
            for (ny = this.y + 1; ny <= this.y + this.height - 1; ++ny) {
                for (nz = this.z - this.widthZ / 2 + 1; nz <= this.z + this.widthZ / 2 - 1; ++nz) {
                    data.setType(nx, ny, nz, fillMat);
                }
            }
        }
    }

    public int[] getCenter() {
        return new int[]{this.x, this.y, this.z};
    }

    public SimpleBlock getCenterSimpleBlock(PopulatorDataAbstract data) {
        return new SimpleBlock(data, this.x, this.y, this.z);
    }

    public double centralDistanceSquared(int[] other) {
        return Math.pow(this.x - other[0], 2.0) + Math.pow(this.y - other[1], 2.0) + Math.pow(this.z - other[2], 2.0);
    }

    public CubeRoom getCloneSubsetRoom(int paddingX, int paddingZ) {
        return new CubeRoom(this.widthX - paddingX * 2, this.widthZ - paddingZ * 2, this.height, this.x, this.y, this.z);
    }

    public boolean isClone(CubeRoom other) {
        return this.x == other.x && this.y == other.y && this.z == other.z && this.widthX == other.widthX && this.height == other.height && this.widthZ == other.widthZ;
    }

    public boolean isOverlapping(CubeRoom room) {
        return Math.abs(room.x - this.x) < Math.abs(room.widthX + this.widthX) / 2 && Math.abs(room.z - this.z) < Math.abs(room.widthZ + this.widthZ) / 2;
    }

    public int[] randomCoords(Random rand) {
        return this.randomCoords(rand, 0);
    }

    public int[] randomCoords(Random rand, int pad) {
        return GenUtils.randomCoords(rand, new int[]{this.x - this.widthX / 2 + pad, this.y + pad, this.z - this.widthZ / 2 + pad}, new int[]{this.x + this.widthX / 2 - pad, this.y + this.height - 1 - pad, this.z + this.widthZ / 2 - pad});
    }

    public boolean isPointInside(int[] point, int pad) {
        int[] boundOne = this.getUpperCorner(pad);
        int[] boundTwo = this.getLowerCorner(pad);
        if (boundOne[0] >= point[0] && boundOne[1] >= point[1]) {
            return boundTwo[0] <= point[0] && boundTwo[1] <= point[1];
        }
        return false;
    }

    public boolean isPointInside(int[] point) {
        int[] boundOne = this.getUpperCorner();
        int[] boundTwo = this.getLowerCorner();
        if (boundOne[0] >= point[0] && boundOne[1] >= point[1]) {
            return boundTwo[0] <= point[0] && boundTwo[1] <= point[1];
        }
        return false;
    }

    public boolean isPointInside(SimpleLocation loc) {
        int[] boundOne = this.getUpperCorner();
        int[] boundTwo = this.getLowerCorner();
        if (boundOne[0] >= loc.getX() && boundOne[1] >= loc.getZ()) {
            return boundTwo[0] <= loc.getX() && boundTwo[1] <= loc.getZ();
        }
        return false;
    }

    public SimpleLocation getSimpleLocation() {
        return new SimpleLocation(this.getX(), this.getY(), this.getZ());
    }

    public boolean isPointInside(SimpleBlock point) {
        int[] boundOne = this.getUpperCorner();
        int[] boundTwo = this.getLowerCorner();
        if (boundOne[0] >= point.getX() && boundOne[1] >= point.getZ()) {
            return boundTwo[0] <= point.getX() && boundTwo[1] <= point.getZ();
        }
        return false;
    }

    public boolean isInside(CubeRoom other) {
        for (int[] corner : this.getAllCorners()) {
            if (other.isPointInside(corner)) continue;
            return false;
        }
        return true;
    }

    public boolean envelopesOrIsInside(CubeRoom other) {
        return this.isInside(other) || other.isInside(this);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public int[][] getAllCorners() {
        return this.getAllCorners(0);
    }

    public int[][] getAllCorners(int padding) {
        int[][] corners = new int[4][2];
        corners[0] = new int[]{this.x + this.widthX / 2 - padding, this.z + this.widthZ / 2 - padding};
        corners[1] = new int[]{this.x - this.widthX / 2 + padding, this.z + this.widthZ / 2 - padding};
        corners[2] = new int[]{this.x + this.widthX / 2 - padding, this.z - this.widthZ / 2 + padding};
        corners[3] = new int[]{this.x - this.widthX / 2 + padding, this.z - this.widthZ / 2 + padding};
        return corners;
    }

    public int[][] getCornersAlongFace(BlockFace face, int padding) {
        int[][] corners = new int[2][2];
        if (face == BlockFace.NORTH) {
            corners[0] = new int[]{this.x - this.widthX / 2 + padding, this.z - this.widthZ / 2 + padding};
            corners[1] = new int[]{this.x + this.widthX / 2 - padding, this.z - this.widthZ / 2 + padding};
        } else if (face == BlockFace.SOUTH) {
            corners[0] = new int[]{this.x - this.widthX / 2 + padding, this.z + this.widthZ / 2 - padding};
            corners[1] = new int[]{this.x + this.widthX / 2 - padding, this.z + this.widthZ / 2 - padding};
        } else if (face == BlockFace.WEST) {
            corners[0] = new int[]{this.x - this.widthX / 2 + padding, this.z - this.widthZ / 2 + padding};
            corners[1] = new int[]{this.x - this.widthX / 2 + padding, this.z + this.widthZ / 2 - padding};
        } else if (face == BlockFace.EAST) {
            corners[0] = new int[]{this.x + this.widthX / 2 - padding, this.z - this.widthZ / 2 + padding};
            corners[1] = new int[]{this.x + this.widthX / 2 - padding, this.z + this.widthZ / 2 - padding};
        }
        return corners;
    }

    public int[] getUpperCorner() {
        return new int[]{this.x + this.widthX / 2, this.z + this.widthZ / 2};
    }

    public int[] getLowerCorner() {
        return new int[]{this.x - this.widthX / 2, this.z - this.widthZ / 2};
    }

    public int[] getUpperCorner(int pad) {
        int Z = this.z - pad + this.widthZ / 2;
        int X = this.x - pad + this.widthX / 2;
        if (pad > this.widthZ / 2) {
            Z = this.z;
        }
        if (pad > this.widthX / 2) {
            X = this.x;
        }
        return new int[]{X, Z};
    }

    public int[] getLowerCorner(int pad) {
        int Z = this.z + pad - this.widthZ / 2;
        int X = this.x + pad - this.widthX / 2;
        if (pad > this.widthZ / 2) {
            Z = this.z;
        }
        if (pad > this.widthX / 2) {
            X = this.x;
        }
        return new int[]{X, Z};
    }

    public void purgeRoomContents(PopulatorDataAbstract data, int padding) {
        int[] lowerCorner = this.getLowerCorner(padding);
        int[] upperCorner = this.getUpperCorner(padding);
        int lowestY = this.y + padding;
        int upperY = this.y + this.height - padding;
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                for (int y = lowestY; y <= upperY; ++y) {
                    data.setType(x, y, z, Material.AIR);
                }
            }
        }
    }

    public boolean isBig() {
        return this.widthX * this.widthZ * this.height >= 2000;
    }

    public boolean isHuge() {
        return this.widthX * this.widthZ * this.height >= 7000;
    }

    public boolean largerThanVolume(int vol) {
        return this.widthX * this.widthZ * this.height >= vol;
    }

    public int getWidthX() {
        return this.widthX;
    }

    public void setWidthX(int widthX) {
        this.widthX = widthX;
    }

    public int getWidthZ() {
        return this.widthZ;
    }

    public void setWidthZ(int widthZ) {
        this.widthZ = widthZ;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public RoomPopulatorAbstract getPop() {
        return this.pop;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void debugRedGround(PopulatorDataAbstract data) {
        int[] lowerCorner = this.getLowerCorner();
        int[] upperCorner = this.getUpperCorner();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                data.setType(x, GenUtils.getHighestGround(data, x, z), z, Material.RED_WOOL);
            }
        }
    }
}

