/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.pyramid.Antechamber;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BannerUtils;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class WarAntechamber
extends Antechamber {
    public WarAntechamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        super.populate(data, room);
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            Wall w = entry.getKey().getRelative(0, 2, 0);
            for (int i = 0; i < entry.getValue(); ++i) {
                if (w.getRear().getType().isSolid() && !w.getType().isSolid() && GenUtils.chance(this.rand, 3, 10)) {
                    BannerUtils.generateBanner(this.rand, w.get(), w.getDirection(), true);
                }
                w = w.getLeft();
            }
        }
        Wall w = new Wall(new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ()));
        w.LPillar(room.getHeight(), this.rand, Material.CHISELED_SANDSTONE);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(face.getOppositeFace());
            w.getRelative(face).setBlockData((BlockData)stair);
            stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(face.getOppositeFace());
            stair.setHalf(Bisected.Half.TOP);
            w.getRelative(face).getRelative(0, room.getHeight() - 2, 0).setBlockData((BlockData)stair);
        }
        w.getRelative(0, room.getHeight() / 2 - 1, 0).setType(GenUtils.randMaterial(this.rand, Material.GOLD_BLOCK, Material.LAPIS_BLOCK, Material.LAPIS_BLOCK, Material.EMERALD_BLOCK, Material.IRON_BLOCK));
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() >= 6 && room.getWidthZ() >= 6;
    }
}

