/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;

public class TerracottaRoom
extends RoomPopulatorAbstract {
    public TerracottaRoom(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        ArrayList<Wall> entrances = new ArrayList<Wall>();
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 1).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                if (i != 0 && i != entry.getValue() - 1) {
                    if (w.getRear().getType().isSolid()) {
                        if (i != 1 && i != entry.getValue() - 2) {
                            if (!w.getRear().getLeft().getType().isSolid() || !w.getRear().getRight().getType().isSolid()) {
                                w.Pillar(room.getHeight(), this.rand, Material.CHISELED_SANDSTONE);
                            } else if (i % 3 == 0) {
                                w.Pillar(room.getHeight(), true, this.rand, Material.BLUE_TERRACOTTA, Material.YELLOW_TERRACOTTA);
                            } else {
                                w.Pillar(room.getHeight(), true, this.rand, Material.YELLOW_TERRACOTTA, Material.BLUE_TERRACOTTA);
                            }
                        }
                    } else {
                        entrances.add(w.clone());
                        w.getRelative(0, 3, 0).Pillar(room.getHeight() - 3, this.rand, Material.CHISELED_SANDSTONE);
                    }
                }
                w = w.getLeft();
            }
        }
        for (Wall w : entrances) {
            w.Pillar(room.getHeight() - 1, this.rand, Material.AIR);
        }
        int[] lowerCorner = room.getLowerCorner(2);
        int[] upperCorner = room.getUpperCorner(2);
        for (int x = lowerCorner[0]; x <= upperCorner[0]; x += 2) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; z += 2) {
                BlockUtils.horizontalGlazedTerracotta(data, x, room.getY(), z, Material.YELLOW_GLAZED_TERRACOTTA);
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() % 2 == 1 && room.getWidthZ() % 2 == 1;
    }
}

