/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PyramidDungeonPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;
    private final int height;

    public PyramidDungeonPathPopulator(Random rand) {
        this.rand = rand;
        this.height = 3;
    }

    public PyramidDungeonPathPopulator(Random rand, int height) {
        this.rand = rand;
        this.height = height;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        if (GenUtils.chance(this.rand, 1, 300)) {
            ppd.base.setType(Material.GRAVEL);
            ppd.base.getRelative(0, -1, 0).setType(Material.TNT);
            ppd.base.getRelative(0, 1, 0).setType(Material.STONE_PRESSURE_PLATE);
            for (int i = -2; i > -8; --i) {
                ppd.base.getRelative(0, i, 0).setType(Material.AIR);
                BlockFace[] blockFaceArray = BlockUtils.directBlockFaces;
                int n = blockFaceArray.length;
                for (int j = 0; j < n; ++j) {
                    BlockFace face = blockFaceArray[j];
                    ppd.base.getRelative(face).getRelative(0, i, 0).setType(Material.AIR);
                }
            }
            for (BlockFace face : BlockUtils.directBlockFaces) {
                Directional torch = (Directional)Bukkit.createBlockData((Material)Material.WALL_TORCH);
                torch.setFacing(face);
                ppd.base.getRelative(0, -1, 0).getRelative(face).setBlockData((BlockData)torch);
                ppd.base.getRelative(face).setType(Material.GRAVEL);
            }
        }
        if (GenUtils.chance(this.rand, 1, 100) && ppd.base.getRelative(0, this.height + 1, 0).getType().isSolid()) {
            ppd.base.getRelative(0, this.height, 0).setType(Material.COBWEB);
        }
    }

    @Override
    public int getPathWidth() {
        return 1;
    }

    @Override
    public int getPathHeight() {
        return this.height;
    }
}

