/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MainEntrancePopulator
extends RoomPopulatorAbstract {
    private final BlockFace entranceFace;

    public MainEntrancePopulator(Random rand, boolean forceSpawn, boolean unique, BlockFace entranceFace) {
        super(rand, forceSpawn, unique);
        this.entranceFace = entranceFace;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int nx;
        int entranceHeightOffsetFromBase = room.getHeight() - 5;
        int[] upperRoomCorner = room.getUpperCorner();
        int[] lowerRoomCorner = room.getLowerCorner();
        for (int h2 = 0; h2 <= 6; ++h2) {
            int[] upperCorner = room.getUpperCorner(-(6 - h2));
            int[] lowerCorner = room.getLowerCorner(-(6 - h2));
            for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
                for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                    if (x > lowerRoomCorner[0] && x < upperRoomCorner[0] && z > lowerRoomCorner[1] && z < upperRoomCorner[1] || h2 == 6) continue;
                    if (h2 == 2) {
                        data.setType(x, room.getY() + entranceHeightOffsetFromBase + 2, z, Material.CHISELED_RED_SANDSTONE);
                    } else {
                        data.setType(x, room.getY() + entranceHeightOffsetFromBase + h2, z, GenUtils.randMaterial(Material.SANDSTONE, Material.SMOOTH_SANDSTONE));
                    }
                    if (h2 == 0) {
                        BlockUtils.setDownUntilSolid(x, room.getY() + entranceHeightOffsetFromBase - 1, z, data, Material.SANDSTONE);
                    }
                    if (x != lowerCorner[0] + 1 && x != upperCorner[0] - 1 || z != lowerCorner[1] + 1 && z != upperCorner[1] - 1 || data.getType(x, room.getY() + entranceHeightOffsetFromBase + h2 + 1, z) != Material.AIR) continue;
                    data.setType(x, room.getY() + entranceHeightOffsetFromBase + h2 + 1, z, Material.SANDSTONE_WALL);
                }
            }
        }
        SimpleBlock b = new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ());
        for (nx = -1; nx <= 1; ++nx) {
            for (int nz = -1; nz <= 1; ++nz) {
                b.getRelative(nx, 0, nz).setType(Material.ORANGE_TERRACOTTA);
                b.getRelative(nx, 1, nz).setType(Material.CUT_RED_SANDSTONE);
            }
        }
        for (nx = -2; nx <= 2; nx += 2) {
            for (int nz = -2; nz <= 2; nz += 2) {
                b.getRelative(nx, 0, nz).setType(Material.ORANGE_TERRACOTTA);
            }
        }
        Wall w = new Wall(new SimpleBlock(data, room.getX(), room.getY() + entranceHeightOffsetFromBase + 1, room.getZ()), this.entranceFace.getOppositeFace());
        w = w.getFront(3);
        for (int depth = 0; depth <= 6; ++depth) {
            w = w.getFront(1);
            w.Pillar(4, this.rand, Material.AIR);
            w.getLeft().Pillar(3, this.rand, Material.AIR);
            w.getRight().Pillar(3, this.rand, Material.AIR);
        }
        for (int h3 = entranceHeightOffsetFromBase; h3 > 0; --h3) {
            w = new Wall(new SimpleBlock(data, room.getX(), room.getY() + h3, room.getZ()), BlockUtils.rotateFace(this.entranceFace.getOppositeFace(), entranceHeightOffsetFromBase - h3));
            if (h3 > 3) {
                for (int i = 1; i <= 3; ++i) {
                    w.getFront(i).setType(Material.CUT_SANDSTONE);
                }
                continue;
            }
            w.getFront().downUntilSolid(new Random(), Material.CUT_SANDSTONE);
        }
        data.setType(room.getX(), room.getY(), room.getZ(), Material.AIR);
        data.setType(room.getX(), room.getY() + room.getHeight(), room.getZ(), Material.LAVA);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() >= 5 && room.getWidthZ() >= 5;
    }
}

