/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.RedstoneWallTorch;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Switch;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class CryptRoom
extends RoomPopulatorAbstract {
    public CryptRoom(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        BlockFace face = BlockUtils.getDirectBlockFace(this.rand);
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 3).entrySet()) {
            Wall w = entry.getKey();
            for (int i = 0; i < entry.getValue(); ++i) {
                w.Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                if (w.getDirection() == face) {
                    w.getFront().Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                    if (i == 1) {
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(face, RedstoneWire.Connection.SIDE);
                        wire.setFace(face.getOppositeFace(), RedstoneWire.Connection.SIDE);
                        w.getFront().setBlockData((BlockData)wire);
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[0], RedstoneWire.Connection.SIDE);
                        wire.setFace(face.getOppositeFace(), RedstoneWire.Connection.UP);
                        w.getFront(2).getRelative(0, -1, 0).setBlockData((BlockData)wire);
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[0], RedstoneWire.Connection.SIDE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[1].getOppositeFace(), RedstoneWire.Connection.SIDE);
                        w.getFront().getRelative(0, 3, 0).setBlockData((BlockData)wire);
                        RedstoneWallTorch rTorch = (RedstoneWallTorch)Bukkit.createBlockData((Material)Material.REDSTONE_WALL_TORCH);
                        rTorch.setFacing(face);
                        w.getFront().getRelative(0, 1, 0).setBlockData((BlockData)rTorch);
                        Switch lever = (Switch)Bukkit.createBlockData((Material)Material.LEVER);
                        lever.setAttachedFace(FaceAttachable.AttachedFace.WALL);
                        lever.setFacing(face.getOppositeFace());
                        lever.setPowered(false);
                        w.getRear().getRelative(0, 1, 0).setBlockData((BlockData)lever);
                        w.getFront(3).Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                    } else if (i == 2) {
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[1], RedstoneWire.Connection.SIDE);
                        wire.setFace(face.getOppositeFace(), RedstoneWire.Connection.SIDE);
                        w.getFront(2).getRelative(0, -1, 0).setBlockData((BlockData)wire);
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(face, RedstoneWire.Connection.SIDE);
                        wire.setFace(face.getOppositeFace(), RedstoneWire.Connection.SIDE);
                        w.getFront().getRelative(0, -1, 0).setBlockData((BlockData)wire);
                        wire = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[0], RedstoneWire.Connection.SIDE);
                        wire.setFace(BlockUtils.getAdjacentFaces(face)[1].getOppositeFace(), RedstoneWire.Connection.SIDE);
                        w.getFront().getRelative(0, 3, 0).setBlockData((BlockData)wire);
                        w.getFront(3).Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                        w.getFront(2).Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                    } else if (i == 3) {
                        w.Pillar(2, this.rand, Material.AIR);
                        w.getFront().Pillar(2, this.rand, Material.AIR);
                        Piston faceDown = (Piston)Bukkit.createBlockData((Material)Material.STICKY_PISTON);
                        faceDown.setFacing(BlockFace.DOWN);
                        w.getFront().getRelative(0, 3, 0).setBlockData((BlockData)faceDown);
                        Piston faceUp = (Piston)Bukkit.createBlockData((Material)Material.STICKY_PISTON);
                        faceUp.setFacing(BlockFace.UP);
                        w.getFront().getRelative(0, -2, 0).setBlockData((BlockData)faceUp);
                        w.getRelative(0, 2, 0).getFront(2).Pillar(room.getHeight() - 2, this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                    } else {
                        w.getFront(2).Pillar(room.getHeight(), this.rand, Material.SANDSTONE, Material.CUT_SANDSTONE, Material.CHISELED_SANDSTONE);
                    }
                } else if (w.getDirection() == face.getOppositeFace() && GenUtils.chance(this.rand, 1, 10)) {
                    SimpleBlock pos = w.getFront().get();
                    Directional chest = (Directional)Bukkit.createBlockData((Material)Material.CHEST);
                    chest.setFacing(face.getOppositeFace());
                    pos.setBlockData((BlockData)chest);
                    data.lootTableChest(pos.getX(), pos.getY(), pos.getZ(), TerraLootTable.DESERT_PYRAMID);
                }
                w = w.getLeft();
            }
        }
        for (int i = 0; i < GenUtils.randInt(this.rand, 1, 4); ++i) {
            data.addEntity(room.getX(), room.getY(), room.getZ(), EntityType.HUSK);
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getWidthX() >= 11 && room.getWidthZ() >= 11;
    }
}

