/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pyramid;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Stairs;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public abstract class Antechamber
extends RoomPopulatorAbstract {
    public Antechamber(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int length;
        int[][] corners;
        for (int[] corner : corners = room.getAllCorners(1)) {
            Wall w = new Wall(new SimpleBlock(data, corner[0], room.getY() + room.getHeight() - 1, corner[1]));
            w.downLPillar(this.rand, 2, Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE);
            for (BlockFace face : BlockUtils.directBlockFaces) {
                w.getRelative(face).setType(GenUtils.randMaterial(Material.CUT_SANDSTONE, Material.SMOOTH_SANDSTONE));
            }
        }
        int[] choices = new int[]{-2, -1, 0, 1, 2};
        int[] steps = new int[15];
        for (int i = 0; i < 15; ++i) {
            steps[i] = choices[this.rand.nextInt(choices.length)];
        }
        SimpleBlock center = new SimpleBlock(data, room.getX(), room.getY(), room.getZ());
        for (BlockFace face : BlockUtils.directBlockFaces) {
            length = room.getWidthX() / 2;
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                length = room.getWidthZ() / 2;
            }
            for (int i = 0; i < length; ++i) {
                if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                    center.getRelative(face, i).getRelative(steps[i] * face.getModZ(), 0, 0).setType(Material.ORANGE_TERRACOTTA);
                    continue;
                }
                center.getRelative(face, i).getRelative(0, 0, steps[i] * face.getModX()).setType(Material.ORANGE_TERRACOTTA);
            }
        }
        center.setType(Material.BLUE_TERRACOTTA);
        center = new SimpleBlock(data, room.getX(), room.getY() + room.getHeight(), room.getZ());
        for (BlockFace face : BlockUtils.directBlockFaces) {
            length = room.getWidthX() / 2;
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                length = room.getWidthZ() / 2;
            }
            for (int i = 0; i < length; ++i) {
                if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                    center.getRelative(face, i).getRelative(steps[i] * face.getModZ(), 0, 0).setType(Material.ORANGE_TERRACOTTA);
                    continue;
                }
                center.getRelative(face, i).getRelative(0, 0, steps[i] * face.getModX()).setType(Material.ORANGE_TERRACOTTA);
            }
        }
        center.setType(Material.BLUE_TERRACOTTA);
    }

    protected void randomRoomPlacement(PopulatorDataAbstract data, CubeRoom room, int lowerbound, int upperbound, Material ... types) {
        for (int i = 0; i < GenUtils.randInt(lowerbound, upperbound); ++i) {
            int[] coords = room.randomCoords(this.rand, 1);
            BlockData bd = Bukkit.createBlockData((Material)GenUtils.randMaterial(types));
            if (bd instanceof Waterlogged) {
                ((Waterlogged)bd).setWaterlogged(false);
            }
            if (!data.getType(coords[0], room.getY() + 1, coords[2]).isSolid()) {
                data.setBlockData(coords[0], room.getY() + 1, coords[2], bd);
                continue;
            }
            data.setBlockData(coords[0], room.getY() + 2, coords[2], bd);
        }
    }

    protected void placeWallDecoration(Wall w, int roomHeight, int patternIndex) {
        if (patternIndex == 0) {
            w.LPillar(roomHeight, this.rand, Material.CHISELED_SANDSTONE);
            Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(w.getDirection().getOppositeFace());
            w.getFront().setBlockData((BlockData)stair);
            stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setHalf(Bisected.Half.TOP);
            stair.setFacing(w.getDirection().getOppositeFace());
            w.getFront().getRelative(0, roomHeight - 2, 0).setBlockData((BlockData)stair);
        } else if (patternIndex == 1) {
            w.LPillar(roomHeight, this.rand, Material.CHISELED_SANDSTONE);
            Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setFacing(w.getDirection().getOppositeFace());
            w.setBlockData((BlockData)stair);
            stair = (Stairs)Bukkit.createBlockData((Material)Material.SANDSTONE_STAIRS);
            stair.setHalf(Bisected.Half.TOP);
            stair.setFacing(w.getDirection().getOppositeFace());
            w.getRelative(0, roomHeight - 2, 0).setBlockData((BlockData)stair);
        } else if (patternIndex == 2) {
            w.LPillar(roomHeight, this.rand, Material.SANDSTONE_WALL);
            for (int i = 0; i < roomHeight; ++i) {
                BlockUtils.correctMultifacingData(w.getRelative(0, i, 0).get());
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

