/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.outpost;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.entity.EntityType;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;
import org.terraform.utils.blockdata.ChestBuilder;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class OutpostTent
extends RoomPopulatorAbstract {
    Material[] edgyWools = new Material[]{Material.BLACK_WOOL, Material.GRAY_WOOL, Material.BROWN_WOOL, Material.LIGHT_GRAY_WOOL, Material.WHITE_WOOL};
    BiomeBank biome;

    public OutpostTent(Random rand, boolean forceSpawn, boolean unique, BiomeBank biome) {
        super(rand, forceSpawn, unique);
        this.biome = biome;
    }

    private void placeProp(int size, SimpleBlock core, BlockFace facing, Material cloth) {
        Material fenceMat = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.FENCE);
        new Wall(core).Pillar(size, this.rand, fenceMat);
        for (BlockFace face : BlockUtils.getAdjacentFaces(facing)) {
            SimpleBlock corner = core.getRelative(face, size - 1);
            corner.getRelative(facing.getOppositeFace()).setType(cloth);
            corner.getRelative(facing.getOppositeFace()).getRelative(0, 1, 0).setType(fenceMat);
            StairBuilder builder = new StairBuilder(WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.STAIRS));
            builder.setFacing(face.getOppositeFace()).apply(corner).setFacing(face).setHalf(Bisected.Half.TOP).apply(corner.getRelative(face.getOppositeFace()));
            corner = corner.getRelative(face.getOppositeFace()).getRelative(0, 1, 0);
            builder.setHalf(Bisected.Half.BOTTOM).setFacing(face.getOppositeFace());
            for (int i = 0; i < size - 2; ++i) {
                builder.apply(corner);
                for (int j = corner.getY() - 1; j > core.getY() - 1; --j) {
                    if (Tag.BEDS.isTagged((Keyed)corner.getAtY(j).getType()) || Tag.STAIRS.isTagged((Keyed)corner.getAtY(j).getType())) continue;
                    corner.getAtY(j).setType(Material.AIR);
                }
                SimpleBlock target = corner.getRelative(facing.getOppositeFace());
                target.setType(cloth);
                for (int j = target.getY() - 1; j > core.getY() - 1; --j) {
                    if (Tag.BEDS.isTagged((Keyed)target.getAtY(j).getType())) continue;
                    target.getAtY(j).setType(Material.AIR);
                }
                target.getRelative(0, 1, 0).setType(fenceMat);
                corner = corner.getRelative(0, 1, 0).getRelative(face.getOppositeFace());
            }
        }
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int relLen;
        Material planks = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.PLANKS);
        Material fence = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.FENCE);
        Material cloth = GenUtils.randMaterial(this.rand, this.edgyWools);
        int height = GenUtils.randInt(this.rand, 4, 6);
        int length = GenUtils.randInt(this.rand, 5, 9);
        BlockFace facing = BlockUtils.getDirectBlockFace(this.rand);
        SimpleBlock firstProp = new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getRelative(facing, length / 2).getGroundOrSeaLevel();
        this.placeProp(height, firstProp.getRelative(0, 1, 0), facing, cloth);
        this.placeProp(height, firstProp.getRelative(0, 1, 0).getRelative(facing.getOppositeFace(), length), facing.getOppositeFace(), cloth);
        Wall wallProp = new Wall(firstProp, facing);
        for (int relWidth = 0; relWidth < height; ++relWidth) {
            for (relLen = 0; relLen <= length; ++relLen) {
                Wall target = wallProp.getLeft(relWidth).getRelative(facing.getOppositeFace(), relLen);
                target.get().lsetType(planks);
                target.getRelative(0, -1, 0).downUntilSolid(this.getRand(), fence);
                target = wallProp.getRight(relWidth).getRelative(facing.getOppositeFace(), relLen);
                target.get().lsetType(planks);
                target.getRelative(0, -1, 0).downUntilSolid(this.getRand(), fence);
            }
        }
        OrientableBuilder ob = new OrientableBuilder(WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.LOG)).setAxis(BlockUtils.getAxisFromBlockFace(facing));
        wallProp = wallProp.getRelative(0, height, 0);
        for (relLen = 0; relLen <= length; ++relLen) {
            ob.apply(wallProp);
            if (relLen != 0 && relLen != length) {
                for (int i = wallProp.getY() - 1; i > firstProp.getY(); --i) {
                    if (Tag.BEDS.isTagged((Keyed)wallProp.getAtY(i).getType())) continue;
                    wallProp.getAtY(i).setType(Material.AIR);
                }
            }
            wallProp = wallProp.getRelative(facing.getOppositeFace());
        }
        for (BlockFace face : BlockUtils.getAdjacentFaces(facing)) {
            for (int relLen2 = 2; relLen2 <= length - 2; ++relLen2) {
                SimpleBlock corner = firstProp.getRelative(face, height - 1).getRelative(facing.getOppositeFace(), relLen2).getRelative(0, 1, 0);
                for (int relWidth = height - 2; relWidth >= 0; --relWidth) {
                    for (int i = corner.getY(); i > firstProp.getY(); --i) {
                        if (!GenUtils.isGroundLike(corner.getAtY(i).getType())) continue;
                        corner.getAtY(i).setType(Material.AIR);
                    }
                    if (relWidth == height - 2) {
                        corner.setType(cloth);
                        SimpleBlock target = corner.getRelative(face.getOppositeFace());
                        if (!target.getType().isSolid() && GenUtils.chance(this.rand, 1, 2)) {
                            switch (this.rand.nextInt(4)) {
                                case 0: {
                                    target.setType(Material.CRAFTING_TABLE);
                                    break;
                                }
                                case 1: {
                                    target.setType(Material.FLETCHING_TABLE);
                                    break;
                                }
                                case 2: {
                                    new ChestBuilder(Material.CHEST).setFacing(face.getOppositeFace()).setLootTable(TerraLootTable.PILLAGER_OUTPOST).apply(target);
                                    break;
                                }
                                case 3: {
                                    BlockUtils.placeBed(target, BlockUtils.pickBed(), face.getOppositeFace());
                                }
                            }
                        }
                        if (GenUtils.chance(this.rand, 1, 4)) {
                            target.getRelative(face.getOppositeFace()).addEntity(EntityType.PILLAGER);
                        }
                    }
                    corner.getRelative(0, 1, 0).setType(cloth);
                    corner = corner.getRelative(face.getOppositeFace()).getRelative(0, 1, 0);
                }
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

