/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.outpost;

import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;
import org.terraform.utils.version.OneOneNineBlockHandler;
import org.terraform.utils.version.Version;

public class OutpostStakeCage
extends RoomPopulatorAbstract {
    private BiomeBank biome;
    private Material[] stakeGravel;

    public OutpostStakeCage(Random rand, boolean forceSpawn, boolean unique, BiomeBank biome, Material ... stakeGravel) {
        super(rand, forceSpawn, unique);
        this.biome = biome;
        this.stakeGravel = stakeGravel;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        block16: {
            block15: {
                Material fenceMat = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.FENCE);
                Material plankMat = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.PLANKS);
                int[] lowerCorner = room.getLowerCorner(2);
                int[] upperCorner = room.getUpperCorner(2);
                int highestHeight = 0;
                for (int nx = lowerCorner[0]; nx <= upperCorner[0]; ++nx) {
                    for (int nz = lowerCorner[1]; nz <= upperCorner[1]; ++nz) {
                        SimpleBlock target = new SimpleBlock(data, nx, 0, nz);
                        int y = target.getGroundOrSeaLevel().getY();
                        if (y > highestHeight) {
                            highestHeight = y;
                        }
                        target.lsetType(plankMat);
                        new Wall(target).downUntilSolid(this.rand, fenceMat);
                    }
                }
                for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 2).entrySet()) {
                    Wall w = entry.getKey().getGroundOrSeaLevel().getRelative(0, 1, 0);
                    for (int i = 0; i < entry.getValue(); ++i) {
                        int baseHeight = 4 + highestHeight - w.getY();
                        if (i % 2 == 0) {
                            this.spawnOneStake(this.rand, baseHeight, w.get());
                        } else {
                            int fenceHeight = baseHeight + 2 + this.rand.nextInt(3);
                            w.RPillar(fenceHeight, this.rand, fenceMat);
                            w.CorrectMultipleFacing(fenceHeight);
                        }
                        w = w.getLeft().getGroundOrSeaLevel().getRelative(0, 1, 0);
                    }
                }
                if (!Version.isAtLeast(19.0)) break block15;
                switch (this.rand.nextInt(3)) {
                    case 0: {
                        data.addEntity(room.getX(), new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getGroundOrDry().getY() + 1, room.getZ(), EntityType.IRON_GOLEM);
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < 1 + this.rand.nextInt(3); ++i) {
                            data.addEntity(room.getX(), new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getGroundOrDry().getY() + 1, room.getZ(), OneOneNineBlockHandler.ALLAY);
                        }
                        for (int nx = lowerCorner[0]; nx <= upperCorner[0]; ++nx) {
                            for (int nz = lowerCorner[1]; nz <= upperCorner[1]; ++nz) {
                                int baseHeight = 6 + highestHeight;
                                SimpleBlock target = new SimpleBlock(data, nx, baseHeight, nz);
                                target.setType(plankMat);
                            }
                        }
                    }
                }
                break block16;
            }
            if (this.rand.nextBoolean()) {
                data.addEntity(room.getX(), new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getGroundOrDry().getY() + 1, room.getZ(), EntityType.IRON_GOLEM);
            }
        }
    }

    public void spawnOneStake(Random rand, int baseHeight, SimpleBlock base) {
        WoodUtils.WoodType type = (new WoodUtils.WoodType[]{WoodUtils.WoodType.LOG, WoodUtils.WoodType.STRIPPED_LOG})[rand.nextInt(2)];
        int h2 = baseHeight + GenUtils.randInt(1, 3);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!rand.nextBoolean()) continue;
            base.getRelative(face).setType(this.stakeGravel);
        }
        new Wall(base).Pillar(h2, rand, WoodUtils.getWoodForBiome(this.biome, type));
        new Wall(base.getRelative(0, h2, 0)).Pillar(GenUtils.randInt(2, 3), rand, WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.FENCE));
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

