/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.outpost;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.WoodUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class OutpostLogpile
extends RoomPopulatorAbstract {
    private BiomeBank biome;

    public OutpostLogpile(Random rand, boolean forceSpawn, boolean unique, BiomeBank biome) {
        super(rand, forceSpawn, unique);
        this.biome = biome;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        Material fenceMat = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.FENCE);
        Material planksMat = WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.PLANKS);
        int stackHeight = GenUtils.randInt(this.rand, 2, 4);
        BlockFace facing = BlockUtils.getDirectBlockFace(this.rand);
        OrientableBuilder ob = new OrientableBuilder(WoodUtils.getWoodForBiome(this.biome, WoodUtils.WoodType.LOG)).setAxis(BlockUtils.getAxisFromBlockFace(facing));
        Wall core = new Wall(new SimpleBlock(data, room.getX(), room.getY(), room.getZ()).getGroundOrSeaLevel(), facing);
        for (int i = 0; i <= stackHeight; ++i) {
            for (int width = 0; width < stackHeight - i; ++width) {
                int logLength = GenUtils.randInt(this.rand, 2, 3);
                for (int len = 0; len <= logLength; ++len) {
                    ob.apply(core.getRelative(0, i + 1, 0).getLeft(width).getFront(len));
                    ob.apply(core.getRelative(0, i + 1, 0).getLeft(width).getRear(len));
                    ob.apply(core.getRelative(0, i + 1, 0).getRight(width).getFront(len));
                    ob.apply(core.getRelative(0, i + 1, 0).getRight(width).getRear(len));
                    if (len != 1) continue;
                    core.getRelative(0, i + 2, 0).getLeft(width).getFront(len).setType(Material.RAIL);
                    core.getRelative(0, i + 2, 0).getRight(width).getFront(len).setType(Material.RAIL);
                    core.getRelative(0, i + 2, 0).getLeft(width).getRear(len).setType(Material.RAIL);
                    core.getRelative(0, i + 2, 0).getRight(width).getRear(len).setType(Material.RAIL);
                    BlockUtils.correctSurroundingRails(core.getRelative(0, i + 2, 0).getLeft(width).getFront(len).get());
                    BlockUtils.correctSurroundingRails(core.getRelative(0, i + 2, 0).getRight(width).getFront(len).get());
                    BlockUtils.correctSurroundingRails(core.getRelative(0, i + 2, 0).getLeft(width).getRear(len).get());
                    BlockUtils.correctSurroundingRails(core.getRelative(0, i + 2, 0).getRight(width).getRear(len).get());
                    if (i != 0) continue;
                    new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(BlockUtils.getRight(core.getDirection())).apply(core.getRelative(0, i + 1, 0).getLeft(width + 1).getFront(len)).apply(core.getRelative(0, i + 1, 0).getLeft(width + 1).getRear(len)).setFacing(BlockUtils.getLeft(core.getDirection())).apply(core.getRelative(0, i + 1, 0).getRight(width + 1).getFront(len)).apply(core.getRelative(0, i + 1, 0).getRight(width + 1).getRear(len));
                }
            }
        }
        core.getRelative(0, stackHeight + 1, 0).getRelative(facing).setType(Material.COBBLESTONE_SLAB);
        core.getRelative(0, stackHeight + 1, 0).getRelative(facing.getOppositeFace()).setType(Material.COBBLESTONE_SLAB);
        for (int nx = -4; nx <= 4; ++nx) {
            for (int nz = -4; nz <= 4; ++nz) {
                core.getRelative(nx, 0, nz).get().lsetType(planksMat);
                core.getRelative(nx, -1, nz).downUntilSolid(new Random(), fenceMat);
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return true;
    }
}

