/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion.secondfloor;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.pillager.mansion.MansionInternalWallState;
import org.terraform.structure.pillager.mansion.MansionRoomPopulator;
import org.terraform.structure.pillager.mansion.MansionRoomSize;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MansionTowerStairwayPopulator
extends MansionRoomPopulator {
    private int towerHeight;

    public MansionTowerStairwayPopulator(CubeRoom room, HashMap<BlockFace, MansionInternalWallState> internalWalls, int towerHeight) {
        super(room, internalWalls);
        this.towerHeight = towerHeight;
    }

    @Override
    public void decorateRoom(PopulatorDataAbstract data, Random random) {
        int bfIndex = 0;
        Wall b = new Wall(this.getRoom().getCenterSimpleBlock(data));
        int height = 8;
        if (this.towerHeight == 2) {
            height = 15;
        }
        for (int i = 1; i < height; ++i) {
            b.getRelative(0, i, 0).setType(Material.STONE_BRICKS);
            BlockFace face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab bottom = (Slab)Bukkit.createBlockData((Material)Material.STONE_BRICK_SLAB);
            bottom.setType(Slab.Type.BOTTOM);
            b.getRelative(face).getRelative(0, i, 0).setBlockData((BlockData)bottom);
            b.getRelative(face).getRelative(0, i + 1, 0).Pillar(3, Material.AIR);
            bfIndex = MansionTowerStairwayPopulator.getNextIndex(bfIndex);
            face = BlockUtils.xzPlaneBlockFaces[bfIndex];
            Slab top = (Slab)Bukkit.createBlockData((Material)Material.STONE_BRICK_SLAB);
            top.setType(Slab.Type.TOP);
            b.getRelative(face).getRelative(0, i, 0).setBlockData((BlockData)top);
            b.getRelative(face).getRelative(0, i + 1, 0).Pillar(3, Material.AIR);
            bfIndex = MansionTowerStairwayPopulator.getNextIndex(bfIndex);
        }
        b = b.getRelative(0, 8, 0);
        for (Map.Entry<Wall, Integer> entry : this.getRoom().getFourWalls(data, 2).entrySet()) {
            Wall w = entry.getKey().getAtY(b.getY());
            for (int i = 0; i < entry.getValue(); ++i) {
                int pileHeight = GenUtils.randInt(random, 1, 2);
                w.Pillar(pileHeight, random, Material.CRAFTING_TABLE, Material.FLETCHING_TABLE, Material.CARTOGRAPHY_TABLE, Material.ANVIL, Material.NOTE_BLOCK, Material.SMITHING_TABLE);
                if (GenUtils.chance(random, 1, 5)) {
                    w.setBlockData(BlockUtils.getRandomBarrel());
                    data.lootTableChest(w.getX(), w.getY(), w.getZ(), TerraLootTable.WOODLAND_MANSION);
                }
                if (GenUtils.chance(random, 1, 5)) {
                    w.getRelative(0, pileHeight, 0).setType(Material.LANTERN);
                }
                w = w.getLeft();
            }
        }
    }

    protected static int getNextIndex(int bfIndex) {
        if (++bfIndex >= 8) {
            bfIndex = 0;
        }
        return bfIndex;
    }

    @Override
    public MansionRoomSize getSize() {
        return new MansionRoomSize(1, 1);
    }
}

