/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion.secondfloor;

import java.util.AbstractMap;
import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.pillager.mansion.MansionJigsawBuilder;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.blockdata.TrapdoorBuilder;

public class MansionSecondFloorWallPiece
extends JigsawStructurePiece {
    public boolean isTentRoofFace = false;
    private MansionJigsawBuilder builder;

    public MansionSecondFloorWallPiece(MansionJigsawBuilder builder, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(widthX, height, widthZ, type, validDirs);
        this.builder = builder;
    }

    public void buildIndividualRoofs(Random random, PopulatorDataAbstract data, int[] lowerBound, int[] upperBound) {
        if (this.builder.countOverlappingPiecesAtLocation(this.getRoom().getSimpleLocation().getRelative(0, -8, 0)) >= 3) {
            return;
        }
        BlockFace walledFace = this.getRotation();
        Wall w = new Wall(new SimpleBlock(data, this.getRoom().getSimpleLocation()).getRelative(walledFace.getOppositeFace(), 3).getRelative(0, 7, 0), walledFace);
        int maxDepth = -1;
        BlockFace roofOuterFace = null;
        if (lowerBound[0] <= w.getX() && lowerBound[1] <= w.getZ() && upperBound[0] >= w.getX() && upperBound[1] >= w.getZ()) {
            this.builder.getRoofedLocations().add(this.getRoom().getSimpleLocation().getRelative(this.getRotation().getOppositeFace(), 9));
            return;
        }
        if (w.getX() >= lowerBound[0] && w.getX() <= upperBound[0]) {
            if (w.getZ() > upperBound[1]) {
                roofOuterFace = BlockFace.SOUTH;
                maxDepth = w.getZ() - upperBound[1];
            } else {
                roofOuterFace = BlockFace.NORTH;
                maxDepth = lowerBound[1] - w.getZ();
            }
        } else if (w.getZ() >= lowerBound[1] && w.getZ() <= upperBound[1]) {
            if (w.getX() > upperBound[0]) {
                roofOuterFace = BlockFace.EAST;
                maxDepth = w.getX() - upperBound[0];
            } else {
                roofOuterFace = BlockFace.WEST;
                maxDepth = lowerBound[0] - w.getX();
            }
        }
        if ((maxDepth *= 2) < 6) {
            maxDepth *= 2;
        }
        if (roofOuterFace == null || walledFace != roofOuterFace) {
            return;
        }
        this.isTentRoofFace = true;
        this.builder.getRoofedLocations().add(this.getRoom().getSimpleLocation().getRelative(this.getRotation().getOppositeFace(), 9));
        for (BlockFace side : BlockUtils.getAdjacentFaces(walledFace)) {
            for (int i = 0; i < 6; ++i) {
                int position = 6 - i;
                Wall roofPiece = w.getRelative(0, position, 0).getRelative(side, i);
                if (i == 0) {
                    roofPiece.setType(Material.COBBLESTONE_SLAB);
                    new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).lapply(roofPiece.getRelative(0, -1, 0));
                } else {
                    StairBuilder builder = new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(side.getOppositeFace()).lapply(roofPiece);
                    if (BlockUtils.isAir(roofPiece.getRelative(0, -1, 0).getType()) || roofPiece.getRelative(0, -1, 0).getType() == Material.COBBLESTONE_STAIRS) {
                        builder.setFacing(side).setHalf(Bisected.Half.TOP).apply(roofPiece.getRelative(0, -1, 0));
                    }
                    if (i == 5 && (roofPiece.getRelative(0, -1, 0).getRelative(side).getType() == Material.COBBLESTONE_STAIRS || roofPiece.getRelative(0, -1, 0).getRelative(side.getOppositeFace()).getType() == Material.COBBLESTONE_STAIRS)) {
                        roofPiece.getRelative(0, -1, 0).setType(Material.AIR);
                        roofPiece.getRelative(0, -1, 0).getRelative(side).setType(Material.AIR);
                        roofPiece.getRelative(0, -1, 0).getRelative(side.getOppositeFace()).setType(Material.AIR);
                    }
                }
                for (int depth = 1; depth < maxDepth; ++depth) {
                    if (i == 0) {
                        roofPiece.getRear(depth).setType(Material.COBBLESTONE_SLAB);
                        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).lapply(roofPiece.getRear(depth).getRelative(0, -1, 0));
                        continue;
                    }
                    new StairBuilder(Material.DARK_OAK_STAIRS).setFacing(side.getOppositeFace()).lapply(roofPiece.getRear(depth));
                }
            }
        }
    }

    @Override
    public void build(PopulatorDataAbstract data, Random rand) {
        AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, this.getRotation().getOppositeFace(), 0);
        Wall w = entry.getKey().getRelative(0, -1, 0);
        for (int i = 0; i < entry.getValue(); ++i) {
            w.getRelative(0, 1, 0).Pillar(this.getRoom().getHeight(), rand, Material.DARK_OAK_PLANKS);
            w = w.getLeft();
        }
    }

    @Override
    public void postBuildDecoration(Random rand, PopulatorDataAbstract data) {
        int i;
        AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, this.getRotation().getOppositeFace(), 0);
        MansionSecondFloorWallType type = MansionSecondFloorWallType.THIN_WINDOWS;
        switch (rand.nextInt(3)) {
            case 0: {
                type = MansionSecondFloorWallType.LARGE_WINDOW;
                break;
            }
            case 1: {
                type = MansionSecondFloorWallType.THIN_WINDOWS;
                break;
            }
            case 2: {
                type = MansionSecondFloorWallType.BALCONY;
            }
        }
        if (type == MansionSecondFloorWallType.BALCONY) {
            int overlappers = 0;
            for (JigsawStructurePiece otherPiece : this.builder.getOverlapperPieces()) {
                int[] center = otherPiece.getRoom().getCenter();
                if (center[0] != this.getRoom().getCenter()[0] || center[2] != this.getRoom().getCenter()[2]) continue;
                ++overlappers;
            }
            if (overlappers > 1) {
                type = MansionSecondFloorWallType.LARGE_WINDOW;
            }
        }
        Wall w = entry.getKey().getRelative(0, -1, 0);
        for (i = 0; i < entry.getValue(); ++i) {
            switch (type) {
                case LARGE_WINDOW: {
                    if (i == 1 || i == entry.getValue() - 2) {
                        w.getRelative(0, 1, 0).Pillar(this.getRoom().getHeight(), new Random(), Material.DARK_OAK_LOG);
                    }
                    if (i == 3 || i == 4 || i == 5) {
                        w.getRelative(0, 2, 0).Pillar(4, new Random(), Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                        w.getRelative(0, 2, 0).CorrectMultipleFacing(4);
                        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getRelative(0, 1, 0).getFront());
                        new TrapdoorBuilder(Material.DARK_OAK_TRAPDOOR).setFacing(w.getDirection()).setOpen(true).apply(w.getRelative(0, 1, 0).getFront(2));
                        new TrapdoorBuilder(Material.DARK_OAK_TRAPDOOR).setFacing(w.getDirection()).apply(w.getRelative(0, 1, 0).getFront().getRelative(0, 1, 0));
                    }
                    if (i == 2 || i == entry.getValue() - 3) {
                        w.getFront().getRelative(0, 1, 0).setType(Material.COBBLESTONE);
                        w.getFront().getRelative(0, 2, 0).Pillar(3, new Random(), Material.STONE_BRICK_WALL);
                        w.getFront().getRelative(0, 2, 0).CorrectMultipleFacing(3);
                        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getFront().getRelative(0, 5, 0));
                    }
                    if (i != 4) break;
                    this.spawnWindowOverhang(w.getFront().getRelative(0, 6, 0));
                    break;
                }
                case BALCONY: {
                    if (i == 4) {
                        w.getRelative(0, 1, 0).getLeft().Pillar(3, Material.AIR);
                        w.getRelative(0, 1, 0).getRight().Pillar(3, Material.AIR);
                        w.getRelative(0, 1, 0).Pillar(4, Material.AIR);
                        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getRelative(0, 5, 0)).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getLeft().getRelative(0, 4, 0)).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getRight().getRelative(0, 4, 0));
                        w.getRelative(0, 6, 0).getFront().setType(Material.COBBLESTONE_SLAB);
                        new SlabBuilder(Material.COBBLESTONE_SLAB).setType(Slab.Type.TOP).apply(w.getRelative(0, 5, 0).getFront().getLeft()).apply(w.getRelative(0, 5, 0).getFront().getRight());
                        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getRelative(0, 6, 0)).apply(w.getRight().getRelative(0, 5, 0)).apply(w.getLeft().getRelative(0, 5, 0));
                        w.getRelative(0, 1, 0).getRight(2).getFront().setType(Material.POLISHED_ANDESITE);
                        w.getRelative(0, 2, 0).getRight(2).getFront().Pillar(2, Material.STONE_BRICK_WALL);
                        w.getRelative(0, 2, 0).getRight(2).getFront().CorrectMultipleFacing(2);
                        w.getRelative(0, 1, 0).getLeft(2).getFront().setType(Material.POLISHED_ANDESITE);
                        w.getRelative(0, 2, 0).getLeft(2).getFront().Pillar(2, Material.STONE_BRICK_WALL);
                        w.getRelative(0, 2, 0).getLeft(2).getFront().CorrectMultipleFacing(2);
                        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(w.getDirection().getOppositeFace()).apply(w.getRelative(0, 1, 0).getRight(2).getFront(2)).apply(w.getRight(2).getFront().getRelative(0, 4, 0)).apply(w.getRelative(0, 1, 0).getLeft(2).getFront(2)).apply(w.getLeft(2).getFront().getRelative(0, 4, 0)).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRelative(0, 1, 0).getRight(3).getFront()).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getRelative(0, 1, 0).getLeft(3).getFront());
                        break;
                    }
                    if (i != 1 && i != entry.getValue() - 2) break;
                    w.getRelative(0, 1, 0).Pillar(this.getRoom().getHeight(), Material.DARK_OAK_LOG);
                    new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getFront().getRelative(0, 5, 0));
                    w.getFront().getRelative(0, 6, 0).setType(Material.LANTERN);
                    break;
                }
                case THIN_WINDOWS: {
                    if (i == 2 || i == entry.getValue() - 3) {
                        w.getRelative(0, 1, 0).Pillar(this.getRoom().getHeight(), new Random(), Material.DARK_OAK_LOG);
                        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getRelative(0, 2, 0).getFront());
                        w.getRelative(0, 3, 0).getFront().setType(Material.STONE_BRICK_WALL);
                        w.getRelative(0, 4, 0).getFront().setType(Material.STONE_BRICK_WALL);
                        w.getRelative(0, 5, 0).getFront().setType(Material.COBBLESTONE_SLAB);
                    }
                    if (i % 2 == 1) {
                        w.getRelative(0, 2, 0).Pillar(4, new Random(), Material.LIGHT_GRAY_STAINED_GLASS_PANE);
                        w.getRelative(0, 2, 0).CorrectMultipleFacing(4);
                    }
                    if (i != entry.getValue() / 2) break;
                    this.spawnWallSupportingPillar(w.getFront().getRelative(0, 1, 0), this.getRoom().getHeight());
                }
            }
            w = w.getLeft();
        }
        entry = this.getRoom().getWall(data, this.getRotation().getOppositeFace(), 0);
        w = entry.getKey().getRelative(0, -1, 0);
        for (i = 0; i < entry.getValue(); ++i) {
            Wall target = w.getRelative(0, this.getRoom().getHeight(), 0);
            if (target.getRelative(0, 1, 0).getType() == Material.DARK_OAK_LOG) {
                target.getRelative(0, 1, 0).setType(Material.AIR);
            }
            if (target.findCeiling(10) != null) {
                int spawnedHeight = target.getRelative(0, 1, 0).LPillar(10, new Random(), target.getType());
                if (!this.isTentRoofFace && spawnedHeight == 0 && target.getRelative(0, 1, 0).getFront().getType().isAir() && Tag.STAIRS.isTagged((Keyed)target.getRelative(0, 1, 0).getType())) {
                    StairBuilder builder = new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(target.getDirection().getOppositeFace()).lapply(target.getFront());
                    for (int depth = 1; depth <= 2; ++depth) {
                        if (Tag.STAIRS.isTagged((Keyed)target.getLeft(depth).getRelative(0, 1, 0).getType()) && target.getLeft(depth).getRelative(0, 1, 0).getFront().getType().isAir()) {
                            builder.lapply(target.getLeft(depth).getFront());
                        }
                        if (!Tag.STAIRS.isTagged((Keyed)target.getRight(depth).getRelative(0, 1, 0).getType()) || !target.getRight(depth).getRelative(0, 1, 0).getFront().getType().isAir()) continue;
                        builder.lapply(target.getRight(depth).getFront());
                    }
                }
            }
            w = w.getLeft();
        }
    }

    private void spawnWallSupportingPillar(Wall w, int height) {
        w.Pillar(height, new Random(), Material.POLISHED_ANDESITE);
        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(w.getDirection().getOppositeFace()).apply(w.getFront());
        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getRelative(BlockUtils.getLeft(w.getDirection())));
        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRelative(BlockUtils.getRight(w.getDirection())));
        new StairBuilder(Material.POLISHED_ANDESITE_STAIRS).setFacing(w.getDirection().getOppositeFace()).apply(w.getRelative(0, height - 1, 0));
        w.getRelative(0, 2, 0).setType(Material.STONE_BRICK_WALL);
        w.getRelative(0, 3, 0).setType(Material.POLISHED_DIORITE);
        w.getRelative(0, 4, 0).setType(Material.STONE_BRICK_WALL);
        w.getRelative(0, 2, 0).CorrectMultipleFacing(3);
    }

    private void spawnWindowOverhang(Wall w) {
        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(BlockUtils.getRight(w.getDirection()))).apply(w).apply(w.getLeft()).apply(w.getRight());
        new StairBuilder(Material.COBBLESTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getFront());
        new SlabBuilder(Material.COBBLESTONE_SLAB).setType(Slab.Type.TOP).apply(w.getFront().getLeft()).apply(w.getFront().getRight());
        new StairBuilder(Material.COBBLESTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRelative(0, -1, 0).getLeft()).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getRelative(0, -1, 0).getRight());
        new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getRight(2)).apply(w.getRight().getRelative(0, 1, 0));
        new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getLeft(2)).apply(w.getLeft().getRelative(0, 1, 0));
        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getRelative(0, 1, 0));
    }

    private static enum MansionSecondFloorWallType {
        THIN_WINDOWS,
        LARGE_WINDOW,
        BALCONY;

    }
}

