/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion.ground;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.pillager.mansion.MansionJigsawBuilder;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public class MansionEntrancePiece
extends JigsawStructurePiece {
    MansionJigsawBuilder builder;

    public MansionEntrancePiece(MansionJigsawBuilder builder, int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(widthX, height, widthZ, type, validDirs);
        this.builder = builder;
    }

    @Override
    public void build(PopulatorDataAbstract data, Random rand) {
        AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, this.getRotation().getOppositeFace(), 0);
        Wall w = entry.getKey().getRelative(0, -1, 0);
        for (int i = 0; i < entry.getValue(); ++i) {
            w.getRelative(0, -1, 0).downUntilSolid(rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
            w.Pillar(1, rand, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE);
            w.getRelative(0, 1, 0).Pillar(this.getRoom().getHeight(), rand, Material.DARK_OAK_PLANKS);
            w = w.getLeft();
        }
        w = w.getRight(5).getRelative(0, 1, 0);
        w.getRight().Pillar(2, new Random(), Material.AIR);
        w.Pillar(3, new Random(), Material.AIR);
        w.getLeft().Pillar(2, new Random(), Material.AIR);
        w.getFront().getRight(3).Pillar(3, new Random(), Material.DARK_OAK_LOG);
        w.getFront().getLeft(3).Pillar(3, new Random(), Material.DARK_OAK_LOG);
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getFront().getRight(2).getRelative(0, 2, 0)).apply(w.getFront().getRight(1).getRelative(0, 3, 0));
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getFront().getLeft(2).getRelative(0, 2, 0)).apply(w.getFront().getLeft(1).getRelative(0, 3, 0));
        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(w.getDirection())).apply(w.getRelative(0, 4, 0).getFront()).apply(w.getRelative(0, 3, 0).getFront().getLeft(2)).apply(w.getRelative(0, 3, 0).getFront().getRight(2));
        new DirectionalBuilder(Material.STONE_BUTTON).setFacing(w.getDirection()).apply(w.getRelative(0, 4, 0).getFront(2)).apply(w.getRelative(0, 3, 0).getFront(2).getLeft(2)).apply(w.getRelative(0, 3, 0).getFront(2).getRight(2));
        new OrientableBuilder(Material.DARK_OAK_LOG).setAxis(BlockUtils.getAxisFromBlockFace(BlockUtils.getRight(w.getDirection()))).apply(w.getRelative(0, 4, 0).getFront().getLeft()).apply(w.getRelative(0, 4, 0).getFront().getRight());
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.BOTTOM).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getFront().getRight(3).getRelative(0, 3, 0)).apply(w.getFront().getRight(2).getRelative(0, 4, 0));
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.BOTTOM).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getFront().getLeft(3).getRelative(0, 3, 0)).apply(w.getFront().getLeft(2).getRelative(0, 4, 0));
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(w.getDirection().getOppositeFace()).apply(w.getRelative(0, 3, 0));
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getRight(w.getDirection())).apply(w.getRight().getRelative(0, 2, 0));
        new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(w.getDirection())).apply(w.getLeft().getRelative(0, 2, 0));
        w.getFront(2).getRight(3).setType(Material.COBBLESTONE);
        w.getFront(2).getLeft(3).setType(Material.COBBLESTONE);
        w.getFront(2).getRight(3).getRelative(0, 1, 0).setType(Material.COBBLESTONE_WALL);
        w.getFront(2).getLeft(3).getRelative(0, 1, 0).setType(Material.COBBLESTONE_WALL);
        w.getFront(2).getRight(3).getRelative(0, 2, 0).setType(Material.LANTERN);
        w.getFront(2).getLeft(3).getRelative(0, 2, 0).setType(Material.LANTERN);
        w = new Wall(new SimpleBlock(data, this.getRoom().getX(), this.getRoom().getY(), this.getRoom().getZ()), w.getDirection());
        ArrayList<BlockFace> directions = new ArrayList<BlockFace>();
        for (JigsawStructurePiece p : this.builder.getOverlapperPieces()) {
            if (!p.getRoom().getSimpleLocation().equals(this.getRoom().getSimpleLocation())) continue;
            directions.add(p.getRotation());
        }
        if (directions.size() == 3) {
            for (BlockFace face : directions) {
                if (directions.contains(face.getOppositeFace())) continue;
                w = new Wall(w.get(), face);
                w = w.getFront(4);
            }
        } else {
            w = w.getRear(3);
        }
        int radius = 10;
        int radiusSquared = radius * radius;
        for (int nx = -radius; nx <= radius; ++nx) {
            for (int nz = -radius; nz <= radius; ++nz) {
                Wall rel = w.getRelative(nx, 0, nz);
                if (!(rel.get().distanceSquared(w.get()) < (double)radiusSquared)) continue;
                if (rel.getType() != Material.STONE_BRICKS) {
                    rel.setType(Material.COBBLESTONE);
                }
                rel.getRelative(0, -1, 0).downUntilSolid(new Random(), Material.COBBLESTONE);
                rel.getRelative(0, this.getRoom().getHeight() + 1, 0).setType(Material.STONE_BRICKS);
            }
        }
        Wall stairway = w.getFront(10);
        BlockUtils.stairwayUntilSolid(stairway.get(), stairway.getDirection(), new Material[]{Material.COBBLESTONE}, Material.COBBLESTONE_STAIRS);
        BlockUtils.stairwayUntilSolid(stairway.getLeft().get(), stairway.getDirection(), new Material[]{Material.COBBLESTONE}, Material.COBBLESTONE_STAIRS);
        BlockUtils.stairwayUntilSolid(stairway.getRight().get(), stairway.getDirection(), new Material[]{Material.COBBLESTONE}, Material.COBBLESTONE_STAIRS);
        BlockUtils.stairwayUntilSolid(stairway.getLeft(2).get(), stairway.getDirection(), new Material[]{Material.COBBLESTONE}, Material.COBBLESTONE_STAIRS);
        BlockUtils.stairwayUntilSolid(stairway.getRight(2).get(), stairway.getDirection(), new Material[]{Material.COBBLESTONE}, Material.COBBLESTONE_STAIRS);
        Wall ceilingCenter = stairway.getRear().getRelative(0, 8, 0);
        ceilingCenter.setType(Material.POLISHED_DIORITE);
        new StairBuilder(Material.COBBLESTONE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(ceilingCenter.getDirection())).apply(ceilingCenter.getLeft()).setFacing(BlockUtils.getRight(ceilingCenter.getDirection())).apply(ceilingCenter.getRight()).setFacing(ceilingCenter.getDirection().getOppositeFace()).apply(ceilingCenter.getRelative(0, -1, 0));
        ceilingCenter.getRelative(0, 1, 0).setType(Material.COBBLESTONE_SLAB);
        for (int i = 1; i <= 3; ++i) {
            ceilingCenter.getRelative(0, 1, 0).getLeft(i).setType(Material.STONE_BRICK_WALL);
            ceilingCenter.getRelative(0, 1, 0).getLeft(i).CorrectMultipleFacing(1);
            ceilingCenter.getRelative(0, 1, 0).getRight(i).setType(Material.STONE_BRICK_WALL);
            ceilingCenter.getRelative(0, 1, 0).getRight(i).CorrectMultipleFacing(1);
        }
        block6: for (BlockFace face : BlockUtils.getAdjacentFaces(stairway.getDirection())) {
            Wall target = stairway.getRear().getRelative(face, 3);
            for (int i = 0; i < 6; ++i) {
                int maxRecursion;
                for (maxRecursion = 3; maxRecursion > 0 && target.getType() != Material.COBBLESTONE; --maxRecursion) {
                    target = target.getRear();
                }
                if (maxRecursion <= 0) continue block6;
                if (i > 1) {
                    target.getRelative(0, 9, 0).setType(Material.COBBLESTONE_WALL);
                    target.getRelative(0, 9, 0).CorrectMultipleFacing(1);
                }
                if (i % 2 == 0 || i > 4) {
                    if (i == 0 || i > 4) {
                        target.Pillar(2, Material.STONE_BRICKS);
                    } else {
                        target.getRear().Pillar(2, Material.STONE_BRICKS);
                    }
                } else {
                    target.getRear().Pillar(8, Material.DARK_OAK_LOG);
                    target.getRelative(0, 1, 0).Pillar(7, Material.COBBLESTONE_WALL);
                    target.getRelative(0, 1, 0).CorrectMultipleFacing(7);
                    target.getRelative(0, 5, 0).Pillar(5, Material.COBBLESTONE);
                    new StairBuilder(Material.STONE_BRICK_STAIRS).setFacing(face).setHalf(Bisected.Half.TOP).apply(target.getRear().getRelative(0, 6, 0).getRelative(face.getOppositeFace())).apply(target.getRear().getRelative(0, 7, 0).getRelative(face.getOppositeFace())).apply(target.getRear().getRelative(0, 7, 0).getRelative(face.getOppositeFace(), 2));
                    new StairBuilder(Material.COBBLESTONE_STAIRS).setFacing(face).setHalf(Bisected.Half.TOP).apply(target.getRelative(0, 7, 0).getRelative(face.getOppositeFace()));
                }
                target = target.getRelative(face);
            }
        }
    }
}

