/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.pillager.mansion.MansionInternalWallState;
import org.terraform.structure.pillager.mansion.MansionRoomPopulator;
import org.terraform.structure.pillager.mansion.MansionRoomSize;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.structure.room.jigsaw.JigsawType;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;

public abstract class MansionStandardRoomPiece
extends JigsawStructurePiece {
    public HashMap<BlockFace, MansionStandardRoomPiece> adjacentPieces = new HashMap();
    public HashMap<BlockFace, MansionInternalWallState> internalWalls = new HashMap();
    private MansionRoomPopulator roomPopulator = null;
    private boolean isPopulating = false;
    public static int spawnedGuards = 0;

    public MansionStandardRoomPiece(int widthX, int height, int widthZ, JigsawType type, BlockFace[] validDirs) {
        super(widthX, height, widthZ, type, validDirs);
    }

    public void setupInternalAttributes(PopulatorDataAbstract data, HashMap<SimpleLocation, JigsawStructurePiece> pieces) {
        for (BlockFace face : BlockUtils.directBlockFaces) {
            SimpleLocation otherLoc = this.getRoom().getSimpleLocation().getRelative(face, 9);
            if (!pieces.containsKey(otherLoc)) {
                SimpleBlock center = this.getRoom().getCenterSimpleBlock(data).getRelative(0, 1, 0);
                if (center.getRelative(face, 5).getType().isSolid()) {
                    this.internalWalls.put(face, MansionInternalWallState.WINDOW);
                    continue;
                }
                this.internalWalls.put(face, MansionInternalWallState.EXIT);
                continue;
            }
            this.adjacentPieces.put(face, (MansionStandardRoomPiece)pieces.get(otherLoc));
            this.internalWalls.put(face, MansionInternalWallState.SOLID);
        }
    }

    public void buildWalls(Random random, PopulatorDataAbstract data) {
        for (BlockFace face : this.internalWalls.keySet()) {
            if (this.internalWalls.get(face) == MansionInternalWallState.WINDOW || this.internalWalls.get(face) == MansionInternalWallState.EXIT) continue;
            AbstractMap.SimpleEntry<Wall, Integer> entry = this.getRoom().getWall(data, face, 0);
            Wall w = (Wall)entry.getKey();
            SimpleBlock center = null;
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                w.Pillar(this.getRoom().getHeight(), Material.DARK_OAK_PLANKS);
                if (i == (Integer)entry.getValue() / 2 && this.internalWalls.get(face) == MansionInternalWallState.ROOM_ENTRANCE) {
                    center = w.clone();
                }
                w = w.getLeft();
            }
            if (center == null) continue;
            center.Pillar(5, Material.AIR);
            ((Wall)center).getLeft().Pillar(5, Material.AIR);
            ((Wall)center).getRight().Pillar(5, Material.AIR);
            ((Wall)center).getLeft(2).Pillar(5, Material.AIR);
            ((Wall)center).getRight(2).Pillar(5, Material.AIR);
            new SlabBuilder(Material.DARK_OAK_SLAB).setType(Slab.Type.TOP).apply(((Wall)center).getRelative(0, 5, 0));
            new StairBuilder(Material.DARK_OAK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(((Wall)center).getDirection())).apply(((Wall)center).getRelative(0, 4, 0).getLeft(2)).setFacing(BlockUtils.getRight(((Wall)center).getDirection())).apply(((Wall)center).getRelative(0, 4, 0).getRight(2));
            ((Wall)center).getLeft(3).Pillar(this.getRoom().getHeight(), Material.DARK_OAK_LOG);
            ((Wall)center).getRight(3).Pillar(this.getRoom().getHeight(), Material.DARK_OAK_LOG);
        }
    }

    public void decorateInternalRoom(Random random, PopulatorDataAbstract data) {
        if (this.roomPopulator != null && this.isPopulating) {
            this.roomPopulator.decorateRoom(data, random);
        }
    }

    public boolean areInternalWallsFullyBlocked() {
        for (BlockFace face : this.internalWalls.keySet()) {
            if (this.internalWalls.get(face) != MansionInternalWallState.ROOM_ENTRANCE) continue;
            return false;
        }
        return true;
    }

    @Override
    public JigsawStructurePiece getInstance(Random rand, int depth) {
        MansionStandardRoomPiece clone = (MansionStandardRoomPiece)super.getInstance(rand, depth);
        if (clone == null) {
            return null;
        }
        clone.adjacentPieces = new HashMap();
        clone.internalWalls = new HashMap();
        return clone;
    }

    public Collection<BlockFace> getShuffledInternalWalls() {
        ArrayList<BlockFace> shuffled = new ArrayList<BlockFace>();
        for (BlockFace face : this.internalWalls.keySet()) {
            shuffled.add(face);
        }
        Collections.shuffle(shuffled);
        return shuffled;
    }

    public MansionRoomPopulator getRoomPopulator() {
        return this.roomPopulator;
    }

    public void setRoomPopulator(MansionRoomPopulator roomPopulator) {
        this.setRoomPopulator(roomPopulator, true);
    }

    public void setRoomPopulator(MansionRoomPopulator roomPopulator, boolean isPopulating) {
        this.roomPopulator = roomPopulator;
        this.isPopulating = isPopulating;
    }

    public void decorateWalls(Random random, PopulatorDataAbstract data) {
        if (this.roomPopulator == null) {
            return;
        }
        block6: for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!this.internalWalls.containsKey(face)) continue;
            switch (this.internalWalls.get(face)) {
                case EXIT: {
                    Wall target = new Wall(this.getRoom().getCenterSimpleBlock(data).getRelative(0, 1, 0), face.getOppositeFace());
                    this.roomPopulator.decorateExit(random, target.getRear(4));
                    continue block6;
                }
                case ROOM_ENTRANCE: {
                    Wall target = new Wall(this.getRoom().getCenterSimpleBlock(data).getRelative(0, 1, 0), face.getOppositeFace());
                    this.roomPopulator.decorateEntrance(random, target.getRear(3));
                    continue block6;
                }
                case SOLID: {
                    Wall target = new Wall(this.getRoom().getCenterSimpleBlock(data).getRelative(0, 1, 0), face.getOppositeFace());
                    this.roomPopulator.decorateWall(random, target.getRear(3));
                    continue block6;
                }
                case WINDOW: {
                    Wall target = new Wall(this.getRoom().getCenterSimpleBlock(data).getRelative(0, 1, 0), face.getOppositeFace());
                    this.roomPopulator.decorateWindow(random, target.getRear(4));
                }
            }
        }
    }

    public boolean isPopulating() {
        return this.isPopulating;
    }

    public void spawnGuards(Random rand, PopulatorDataAbstract data) {
        int limit;
        if (this.roomPopulator == null) {
            return;
        }
        EntityType type = EntityType.VINDICATOR;
        int[] spawnLoc = this.roomPopulator.getSpawnLocation();
        if (this.isPopulating && (this.roomPopulator.getSize().equals(new MansionRoomSize(3, 3)) || this.roomPopulator.getSize().equals(new MansionRoomSize(2, 2)))) {
            type = EntityType.EVOKER;
        }
        if (this.roomPopulator.getSize().equals(new MansionRoomSize(1, 1)) && GenUtils.chance(rand, 4, 5)) {
            return;
        }
        SimpleBlock target = new SimpleBlock(data, spawnLoc[0], spawnLoc[1], spawnLoc[2]);
        BlockFace dir = BlockUtils.getDirectBlockFace(rand);
        for (limit = 5; limit > 0 && (target.getType() != Material.AIR && target.getType() != Material.RED_CARPET || target.getRelative(0, 1, 0).getType() != Material.AIR); --limit) {
            target = target.getRelative(dir).getRelative(0, 1, 0);
        }
        if (limit > 0) {
            target.addEntity(type);
            ++spawnedGuards;
            if (!this.roomPopulator.getSize().equals(new MansionRoomSize(1, 1))) {
                for (int i = 0; i < TConfigOption.STRUCTURES_MANSION_SPAWNAGGRESSION.getInt(); ++i) {
                    if (!rand.nextBoolean()) continue;
                    target.addEntity(EntityType.VINDICATOR);
                    ++spawnedGuards;
                }
            }
        }
    }
}

