/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import org.bukkit.block.BlockFace;
import org.terraform.structure.pillager.mansion.MansionInternalWallState;
import org.terraform.structure.pillager.mansion.MansionStandardRoomPiece;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MansionMazeAlgoUtil {
    private static MansionStandardRoomPiece getStartingPiece(Collection<JigsawStructurePiece> pieces) {
        Iterator<JigsawStructurePiece> iterator = pieces.iterator();
        if (iterator.hasNext()) {
            JigsawStructurePiece p = iterator.next();
            return (MansionStandardRoomPiece)p;
        }
        return null;
    }

    public static void setupPathways(Collection<JigsawStructurePiece> pieces, Random rand) {
        int n = pieces.size();
        Stack<MansionStandardRoomPiece> cellStack = new Stack<MansionStandardRoomPiece>();
        MansionStandardRoomPiece currentCell = MansionMazeAlgoUtil.getStartingPiece(pieces);
        int nv = 1;
        while (nv < n) {
            Map<BlockFace, MansionStandardRoomPiece> neighbours = MansionMazeAlgoUtil.getValidNeighbours(pieces, currentCell);
            if (neighbours.isEmpty()) {
                if (cellStack.isEmpty()) break;
                currentCell = (MansionStandardRoomPiece)cellStack.pop();
                continue;
            }
            Map.Entry entry = (Map.Entry)neighbours.entrySet().toArray()[rand.nextInt(neighbours.size())];
            if (currentCell.internalWalls.get(entry.getKey()) == MansionInternalWallState.SOLID) {
                currentCell.internalWalls.put((BlockFace)entry.getKey(), MansionInternalWallState.ROOM_ENTRANCE);
                MansionStandardRoomPiece otherPiece = currentCell.adjacentPieces.get(entry.getKey());
                if (otherPiece.internalWalls.containsKey(((BlockFace)entry.getKey()).getOppositeFace())) {
                    otherPiece.internalWalls.put(((BlockFace)entry.getKey()).getOppositeFace(), MansionInternalWallState.ROOM_ENTRANCE);
                }
            }
            cellStack.push(currentCell);
            currentCell = (MansionStandardRoomPiece)entry.getValue();
            ++nv;
        }
    }

    public static void knockdownRandomWalls(Collection<JigsawStructurePiece> pieces, Random rand) {
        for (JigsawStructurePiece piece : pieces) {
            MansionStandardRoomPiece spiece = (MansionStandardRoomPiece)piece;
            for (BlockFace face : spiece.getShuffledInternalWalls()) {
                if (spiece.internalWalls.get(face) == MansionInternalWallState.WINDOW || spiece.internalWalls.get(face) == MansionInternalWallState.EXIT || !GenUtils.chance(rand, 1, 10)) continue;
                spiece.adjacentPieces.get((Object)face).internalWalls.put(face.getOppositeFace(), MansionInternalWallState.ROOM_ENTRANCE);
                spiece.internalWalls.put(face, MansionInternalWallState.ROOM_ENTRANCE);
            }
        }
    }

    private static Map<BlockFace, MansionStandardRoomPiece> getValidNeighbours(Collection<JigsawStructurePiece> pieces, MansionStandardRoomPiece piece) {
        EnumMap<BlockFace, MansionStandardRoomPiece> neighbours = new EnumMap<BlockFace, MansionStandardRoomPiece>(BlockFace.class);
        for (BlockFace face : BlockUtils.directBlockFaces) {
            MansionStandardRoomPiece neighbour;
            if (!piece.adjacentPieces.containsKey(face) || (neighbour = piece.adjacentPieces.get(face)) == null || !neighbour.areInternalWallsFullyBlocked()) continue;
            neighbours.put(face, neighbour);
        }
        return neighbours;
    }
}

