/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.pillager.mansion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bukkit.block.BlockFace;
import org.terraform.data.SimpleLocation;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.pillager.mansion.MansionRoomPopulator;
import org.terraform.structure.pillager.mansion.MansionRoomPopulatorRegistry;
import org.terraform.structure.pillager.mansion.MansionRoomSize;
import org.terraform.structure.pillager.mansion.MansionStandardRoomPiece;
import org.terraform.structure.room.jigsaw.JigsawStructurePiece;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MansionCompoundRoomDistributor {
    public static HashMap<MansionRoomSize, ArrayList<MansionRoomPopulator>> groundFloorPopulators = new HashMap<MansionRoomSize, ArrayList<MansionRoomPopulator>>(){
        {
            this.put(new MansionRoomSize(3, 3), MansionRoomPopulatorRegistry.GROUND_3_3.getPopulators());
            this.put(new MansionRoomSize(2, 2), MansionRoomPopulatorRegistry.GROUND_2_2.getPopulators());
            this.put(new MansionRoomSize(1, 2), MansionRoomPopulatorRegistry.GROUND_1_2.getPopulators());
            this.put(new MansionRoomSize(2, 1), MansionRoomPopulatorRegistry.GROUND_2_1.getPopulators());
            this.put(new MansionRoomSize(1, 1), MansionRoomPopulatorRegistry.GROUND_1_1.getPopulators());
        }
    };
    public static HashMap<MansionRoomSize, ArrayList<MansionRoomPopulator>> secondFloorPopulators = new HashMap<MansionRoomSize, ArrayList<MansionRoomPopulator>>(){
        {
            this.put(new MansionRoomSize(3, 3), MansionRoomPopulatorRegistry.SECOND_3_3.getPopulators());
            this.put(new MansionRoomSize(2, 2), MansionRoomPopulatorRegistry.SECOND_2_2.getPopulators());
            this.put(new MansionRoomSize(1, 2), MansionRoomPopulatorRegistry.SECOND_1_2.getPopulators());
            this.put(new MansionRoomSize(2, 1), MansionRoomPopulatorRegistry.SECOND_2_1.getPopulators());
            this.put(new MansionRoomSize(1, 1), MansionRoomPopulatorRegistry.SECOND_1_1.getPopulators());
        }
    };

    public static void distributeRooms(Collection<JigsawStructurePiece> pieces, Random random, boolean isGround) {
        HashMap<MansionRoomSize, ArrayList<MansionRoomPopulator>> activeRoomPool;
        ArrayList<JigsawStructurePiece> shuffledList = new ArrayList<JigsawStructurePiece>();
        shuffledList.addAll(pieces);
        ArrayList<MansionRoomSize> potentialRoomSizes = new ArrayList<MansionRoomSize>();
        int occupiedCells = 13;
        if (isGround) {
            activeRoomPool = groundFloorPopulators;
            potentialRoomSizes.add(new MansionRoomSize(3, 3));
        } else {
            activeRoomPool = secondFloorPopulators;
        }
        potentialRoomSizes.add(new MansionRoomSize(2, 2));
        while ((double)(occupiedCells / pieces.size()) < 0.7 || GenUtils.chance(random, pieces.size() - occupiedCells / 4, pieces.size())) {
            if ((double)(occupiedCells / pieces.size()) < 0.5 && GenUtils.chance(random, 1, 3)) {
                occupiedCells += 4;
                potentialRoomSizes.add(new MansionRoomSize(2, 2));
                continue;
            }
            occupiedCells += 2;
            if (random.nextBoolean()) {
                potentialRoomSizes.add(new MansionRoomSize(2, 1));
                continue;
            }
            potentialRoomSizes.add(new MansionRoomSize(1, 2));
        }
        block1: for (int i = 0; i < potentialRoomSizes.size(); ++i) {
            MansionRoomSize roomSize = (MansionRoomSize)potentialRoomSizes.get(i);
            Collections.shuffle(shuffledList);
            for (JigsawStructurePiece piece : shuffledList) {
                MansionRoomPopulator populator;
                Collections.shuffle((List)activeRoomPool.get(roomSize), random);
                ArrayList<MansionRoomPopulator> populators = activeRoomPool.get(roomSize);
                if (populators.size() <= 0) {
                    activeRoomPool.put(roomSize, MansionRoomPopulatorRegistry.getByRoomSize(roomSize, isGround).getPopulators());
                    populators = activeRoomPool.get(roomSize);
                }
                if (!MansionCompoundRoomDistributor.canRoomSizeFitWithCenter((MansionStandardRoomPiece)piece, pieces, roomSize, populator = populators.get(0).getInstance(piece.getRoom(), ((MansionStandardRoomPiece)piece).internalWalls), false)) continue;
                TerraformGeneratorPlugin.logger.info(populator.getClass().getSimpleName() + " generating at " + piece.getRoom().getSimpleLocation());
                ((MansionStandardRoomPiece)piece).setRoomPopulator(populator);
                populators.remove(0);
                continue block1;
            }
        }
        for (JigsawStructurePiece piece : pieces) {
            MansionRoomSize roomSize = new MansionRoomSize(1, 1);
            if (((MansionStandardRoomPiece)piece).getRoomPopulator() != null) continue;
            Collections.shuffle((List)activeRoomPool.get(roomSize), random);
            MansionRoomPopulator populator = activeRoomPool.get(roomSize).get(0).getInstance(piece.getRoom(), ((MansionStandardRoomPiece)piece).internalWalls);
            TerraformGeneratorPlugin.logger.info(populator.getClass().getSimpleName() + " generating at " + piece.getRoom().getSimpleLocation());
            ((MansionStandardRoomPiece)piece).setRoomPopulator(populator);
        }
    }

    public static boolean canRoomSizeFitWithCenter(MansionStandardRoomPiece piece, Collection<JigsawStructurePiece> pieces, MansionRoomSize roomSize, MansionRoomPopulator defaultPopulator, boolean force) {
        SimpleLocation center = piece.getRoom().getSimpleLocation();
        ArrayList<SimpleLocation> relevantLocations = new ArrayList<SimpleLocation>();
        relevantLocations.add(center);
        if (roomSize.getWidthX() == 2) {
            relevantLocations.add(center.getRelative(BlockFace.EAST, 9));
        }
        if (roomSize.getWidthZ() == 2) {
            relevantLocations.add(center.getRelative(BlockFace.SOUTH, 9));
        }
        if (roomSize.getWidthZ() == 2 && roomSize.getWidthX() == 2) {
            relevantLocations.add(center.getRelative(BlockFace.SOUTH_EAST, 9));
        }
        if (roomSize.getWidthX() == 3 && roomSize.getWidthZ() == 3) {
            for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                relevantLocations.add(center.getRelative(face, 9));
            }
        }
        int hits = 0;
        for (JigsawStructurePiece p : pieces) {
            if (!relevantLocations.contains(p.getRoom().getSimpleLocation())) continue;
            if (!force && ((MansionStandardRoomPiece)p).getRoomPopulator() != null) {
                return false;
            }
            ++hits;
        }
        if (hits < relevantLocations.size()) {
            return false;
        }
        for (JigsawStructurePiece p : pieces) {
            if (!relevantLocations.contains(p.getRoom().getSimpleLocation())) continue;
            MansionStandardRoomPiece spiece = (MansionStandardRoomPiece)p;
            spiece.setRoomPopulator(defaultPopulator.getInstance(p.getRoom(), spiece.internalWalls), false);
            for (BlockFace face : spiece.adjacentPieces.keySet()) {
                if (!relevantLocations.contains(spiece.adjacentPieces.get(face).getRoom().getSimpleLocation())) continue;
                spiece.internalWalls.remove(face);
                spiece.adjacentPieces.get((Object)face).internalWalls.remove(face.getOppositeFace());
            }
        }
        return true;
    }
}

