/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.monument.CoralRoomPopulator;
import org.terraform.structure.monument.FishCageRoomPopulator;
import org.terraform.structure.monument.HollowPillarRoomPopulator;
import org.terraform.structure.monument.LanternPillarRoomPopulator;
import org.terraform.structure.monument.LevelledElderRoomPopulator;
import org.terraform.structure.monument.MiniRoomNetworkPopulator;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.monument.MonumentPathPopulator;
import org.terraform.structure.monument.TreasureRoomPopulator;
import org.terraform.structure.room.RoomLayout;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;

public class MonumentPopulator
extends SingleMegaChunkStructurePopulator {
    public static void arch(Wall w, MonumentDesign design, Random random, int archHalfLength, int height) {
        Wall arch = w.getRelative(0, height, 0);
        BlockFace left = BlockUtils.getAdjacentFaces(w.getDirection())[1];
        BlockFace right = BlockUtils.getAdjacentFaces(w.getDirection())[0];
        Stairs ls = (Stairs)Bukkit.createBlockData((Material)design.stairs());
        ls.setWaterlogged(true);
        ls.setFacing(left);
        Stairs rs = (Stairs)Bukkit.createBlockData((Material)design.stairs());
        rs.setWaterlogged(true);
        rs.setFacing(right);
        for (int i = 0; i < archHalfLength - 1; ++i) {
            if (i <= 1) {
                Slab slab = (Slab)Bukkit.createBlockData((Material)design.slab());
                arch.getLeft(i).setBlockData((BlockData)slab);
                arch.getRight(i).setBlockData((BlockData)slab);
            }
            arch.getLeft(i).setType(design.mat(random));
            arch.getRight(i).setType(design.mat(random));
        }
        arch.getRelative(0, 1, 0).setType(Material.SEA_LANTERN);
        arch.getRelative(0, 2, 0).setType(design.slab());
        arch.getRelative(0, 1, 0).getLeft(1).setType(design.mat(random));
        arch.getRelative(0, 1, 0).getRight(1).setType(design.mat(random));
        arch.getRelative(0, 1, 0).getLeft(2).setBlockData((BlockData)ls);
        arch.getRelative(0, 1, 0).getRight(2).setBlockData((BlockData)rs);
        arch.getLeft(archHalfLength - 2).setBlockData((BlockData)ls);
        arch.getRelative(0, -1, 0).getLeft(archHalfLength).setBlockData((BlockData)ls);
        arch.getRight(archHalfLength - 2).setBlockData((BlockData)rs);
        arch.getRelative(0, -1, 0).getRight(archHalfLength).setBlockData((BlockData)rs);
        arch.getLeft(archHalfLength - 1).setType(design.slab());
        arch.getRight(archHalfLength - 1).setType(design.slab());
        arch.getLeft(archHalfLength - 1).getRelative(0, -1, 0).setType(Material.SEA_LANTERN);
        arch.getRight(archHalfLength - 1).getRelative(0, -1, 0).setType(Material.SEA_LANTERN);
        arch.getLeft(archHalfLength).getRelative(0, -2, 0).downUntilSolid(random, design.tileSet);
        arch.getRight(archHalfLength).getRelative(0, -2, 0).downUntilSolid(random, design.tileSet);
    }

    private static void lightPlatform(PopulatorDataAbstract data, int x, int y, int z) {
        for (int nx = -2; nx <= 2; ++nx) {
            for (int nz = -2; nz <= 2; ++nz) {
                data.setType(x + nx, y, z + nz, Material.PRISMARINE_BRICKS);
            }
        }
    }

    private static void vegetateNearby(Random rand, PopulatorDataAbstract data, int range, int x, int z) {
        int i = 25;
        for (int nx = x - range / 2 - i; nx <= x + range / 2 + i; ++nx) {
            for (int nz = z - range / 2 - i; nz <= z + range / 2 + i; ++nz) {
                int y;
                if (!GenUtils.chance(rand, 2, 5) || data.getType(nx, y = GenUtils.getTrueHighestBlock(data, nx, nz), nz).toString().contains("SLAB") || data.getType(nx, y, nz).toString().contains("STAIR") || data.getType(nx, y, nz).toString().contains("WALL") || y >= TerraformGenerator.seaLevel) continue;
                if (GenUtils.chance(rand, 9, 10)) {
                    CoralGenerator.generateKelpGrowth(data, nx, y + 1, nz);
                    continue;
                }
                CoralGenerator.generateSeaPickles(data, nx, y + 1, nz);
            }
        }
    }

    private static void setupGuardianSpawns(PopulatorDataAbstract data, int range, int x, int y, int z) {
        int i = -5;
        ArrayList<Integer> done = new ArrayList<Integer>();
        for (int nx = x - range / 2 - i; nx <= x + range / 2 + i; ++nx) {
            for (int nz = z - range / 2 - i; nz <= z + range / 2 + i; ++nz) {
                int chunkX = nx >> 4;
                int chunkZ = nz >> 4;
                int hash = Objects.hash(chunkX, chunkZ);
                if (done.contains(hash)) continue;
                done.add(hash);
                TerraformGeneratorPlugin.injector.getICAData(((PopulatorDataPostGen)data).getWorld().getChunkAt(chunkX, chunkZ)).registerNaturalSpawns(NaturalSpawnType.GUARDIAN, x - range / 2, y, z - range / 2, x + range / 2, TerraformGenerator.seaLevel, z + range / 2);
            }
        }
    }

    @Override
    public boolean canSpawn(TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        if (biome.getType() != BiomeType.DEEP_OCEANIC || biome == BiomeBank.MUSHROOM_ISLANDS) {
            return false;
        }
        return this.rollSpawnRatio(tw, chunkX, chunkZ);
    }

    private boolean rollSpawnRatio(TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 92992), (int)(TConfigOption.STRUCTURES_MONUMENT_SPAWNRATIO.getDouble() * 10000.0), 10000);
    }

    @Override
    public void populate(TerraformWorld tw, PopulatorDataAbstract data) {
        int[] coords = new MegaChunk(data.getChunkX(), data.getChunkZ()).getCenterBiomeSectionBlockCoords();
        int x = coords[0];
        int z = coords[1];
        int y = GenUtils.getHighestGround(data, x, z);
        this.spawnMonument(tw, tw.getHashedRand(x, y, z, 9299724L), data, x, y, z);
    }

    public void spawnMonument(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int y, int z) {
        TerraformGeneratorPlugin.logger.info("Spawning Monument at: " + x + "," + z);
        MonumentDesign design = MonumentDesign.values()[random.nextInt(MonumentDesign.values().length)];
        int numRooms = 1000;
        int range = 50;
        this.spawnMonumentBase(tw, design, random, data, x, y, z, range);
        Random hashedRand = tw.getHashedRand(x, y, z);
        RoomLayoutGenerator gen = new RoomLayoutGenerator(hashedRand, RoomLayout.RANDOM_BRUTEFORCE, numRooms, x, y, z, range);
        gen.setPathPopulator(new MonumentPathPopulator(design, tw.getHashedRand(x, y, z, 77L)));
        gen.setRoomMaxX(15);
        gen.setRoomMaxZ(15);
        gen.setRoomMinX(10);
        gen.setRoomMinZ(10);
        gen.setRoomMaxHeight(22);
        gen.setRoomMinHeight(9);
        gen.registerRoomPopulator(new TreasureRoomPopulator(random, design, true, true));
        gen.registerRoomPopulator(new LevelledElderRoomPopulator(random, design, true, true));
        gen.registerRoomPopulator(new LevelledElderRoomPopulator(random, design, true, true));
        gen.registerRoomPopulator(new MiniRoomNetworkPopulator(random, design, false, false));
        gen.registerRoomPopulator(new CoralRoomPopulator(random, design, false, false));
        gen.registerRoomPopulator(new FishCageRoomPopulator(random, design, false, false));
        gen.registerRoomPopulator(new HollowPillarRoomPopulator(random, design, false, false));
        gen.registerRoomPopulator(new LanternPillarRoomPopulator(random, design, false, false));
        gen.generate(false);
        gen.fill(data, tw, Material.PRISMARINE_BRICKS, Material.PRISMARINE_BRICKS, Material.PRISMARINE);
        this.carveBaseHallways(tw, random, data, x, y, z, range);
        this.spawnMonumentEntrance(tw, design, random, data, x, y, z, range);
        MonumentPopulator.vegetateNearby(random, data, range, x, z);
        MonumentPopulator.setupGuardianSpawns(data, range, x, y, z);
    }

    private void entranceSegment(Wall w, Random random, MonumentDesign design) {
        for (int i = 0; i < 12; ++i) {
            w.getRear(i).Pillar(6, random, Material.WATER);
        }
        Stairs stair = (Stairs)Bukkit.createBlockData((Material)Material.PRISMARINE_BRICK_STAIRS);
        stair.setWaterlogged(true);
        stair.setHalf(Bisected.Half.TOP);
        stair.setFacing(w.getDirection().getOppositeFace());
        w.getRear(11).getRelative(0, 5, 0).setBlockData((BlockData)stair);
        w.getFront().Pillar(6, random, Material.WATER);
    }

    public void spawnMonumentEntrance(TerraformWorld tw, MonumentDesign design, Random random, PopulatorDataAbstract data, int x, int y, int z, int range) {
        int i;
        range += 38;
        BlockFace dir = BlockUtils.getDirectBlockFace(random);
        SimpleBlock base = new SimpleBlock(data, x, y + 1, z);
        for (int i2 = 0; i2 < range / 2; ++i2) {
            base = base.getRelative(dir);
        }
        Wall w = new Wall(base, dir);
        Wall leftClone = w.clone();
        Wall rightClone = w.clone();
        int halfLength = 4 + random.nextInt(3);
        for (i = 0; i < halfLength; ++i) {
            this.entranceSegment(leftClone, random, design);
            this.entranceSegment(rightClone, random, design);
            rightClone = rightClone.getRight();
            leftClone = leftClone.getLeft();
        }
        for (i = 0; i < 12; i += 3) {
            MonumentPopulator.arch(w.getRear(i), design, random, halfLength + 2, 10);
        }
    }

    public void spawnMonumentBase(TerraformWorld tw, MonumentDesign design, Random random, PopulatorDataAbstract data, int x, int y, int z, int range) {
        range += 30;
        for (int i = 6; i >= 0; --i) {
            for (int nx = x - range / 2 - i; nx <= x + range / 2 + i; ++nx) {
                for (int nz = z - range / 2 - i; nz <= z + range / 2 + i; ++nz) {
                    if (!(i % 2 != 0 || nx != x - range / 2 - i && nx != x + range / 2 + i || nz != z - range / 2 - i && nz != z + range / 2 + i)) {
                        design.spire(new Wall(new SimpleBlock(data, nx, y + (6 - i) + 1, nz), BlockFace.NORTH), random);
                    }
                    data.setType(nx, y + (6 - i), nz, GenUtils.randMaterial(random, Material.PRISMARINE_BRICKS, Material.PRISMARINE_BRICKS, Material.PRISMARINE));
                }
            }
        }
        int pad = 5;
        MonumentPopulator.lightPlatform(data, x - range / 2 + pad, y + 7, z - range / 2 + pad);
        design.spawnLargeLight(data, x - range / 2 + pad, y + 8, z - range / 2 + pad);
        MonumentPopulator.lightPlatform(data, x + range / 2 - pad, y + 7, z - range / 2 + pad);
        design.spawnLargeLight(data, x + range / 2 - pad, y + 8, z - range / 2 + pad);
        MonumentPopulator.lightPlatform(data, x + range / 2 - pad, y + 7, z + range / 2 - pad);
        design.spawnLargeLight(data, x + range / 2 - pad, y + 8, z + range / 2 - pad);
        MonumentPopulator.lightPlatform(data, x - range / 2 + pad, y + 7, z + range / 2 - pad);
        design.spawnLargeLight(data, x - range / 2 + pad, y + 8, z + range / 2 - pad);
    }

    public void carveBaseHallways(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int y, int z, int range) {
        range += 29;
        for (int ny = y + 1; ny <= y + 4; ++ny) {
            for (int nx = x - range / 2; nx <= x + range / 2; ++nx) {
                for (int nz = z - range / 2; nz <= z + range / 2; ++nz) {
                    if (nx > x + 5 - range / 2 && nx < x - 5 + range / 2 && nz > z + 5 - range / 2 && nz < z - 5 + range / 2) continue;
                    data.setType(nx, ny, nz, Material.WATER);
                }
            }
        }
        for (int nx = x - range / 2 + 3; nx <= x + range / 2 - 3; nx += 2) {
            data.setType(nx, y, z - range / 2 + 3, Material.SEA_LANTERN);
            data.setType(nx, y, z + range / 2 - 3, Material.SEA_LANTERN);
        }
        for (int nz = z - range / 2 + 3; nz <= z + range / 2 - 3; nz += 2) {
            data.setType(x - range / 2 + 3, y, nz, Material.SEA_LANTERN);
            data.setType(x + range / 2 - 3, y, nz, Material.SEA_LANTERN);
        }
    }

    @Override
    public Random getHashedRandom(TerraformWorld world, int chunkX, int chunkZ) {
        return world.getHashedRand(888271981L, chunkX, chunkZ);
    }

    @Override
    public int getChunkBufferDistance() {
        return 4;
    }

    @Override
    public boolean isEnabled() {
        return TConfigOption.STRUCTURES_MONUMENT_ENABLED.getBoolean();
    }
}

