/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Random;
import org.bukkit.Material;
import org.terraform.data.Wall;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.monument.MonumentRoomPopulator;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.GenUtils;

public class MonumentPathPopulator
extends PathPopulatorAbstract {
    Random rand;
    MonumentDesign design;
    private boolean light = true;

    public MonumentPathPopulator(MonumentDesign design, Random rand) {
        this.rand = rand;
        this.design = design;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        Wall w = new Wall(ppd.base, ppd.dir);
        w.getLeft().RPillar(5, this.rand, Material.WATER);
        w.RPillar(5, this.rand, Material.WATER);
        w.getRight().RPillar(5, this.rand, Material.WATER);
        for (int i = 0; i <= 1; ++i) {
            if (w.getLeft(i).getType() != Material.SEA_LANTERN) {
                w.getLeft(i).setType(Material.PRISMARINE);
            }
            if (w.getRight(i).getType() == Material.SEA_LANTERN) continue;
            w.getRight(i).setType(Material.PRISMARINE);
        }
        if (this.light) {
            w.setType(Material.SEA_LANTERN);
        }
        boolean bl = this.light = !this.light;
        if (GenUtils.chance(this.rand, 1, 20)) {
            w.RPillar(5, this.rand, GenUtils.mergeArr(this.design.tileSet, {Material.SEA_LANTERN}));
        }
        if (GenUtils.chance(this.rand, 1, 50)) {
            MonumentRoomPopulator.setThickPillar(this.rand, this.design, w.get().getRelative(0, -1, 0));
        }
        if (GenUtils.chance(this.rand, 1, 50) && w.getRelative(0, 6, 0).getType().isSolid() && !w.getRelative(0, 7, 0).getType().isSolid()) {
            this.design.spire(w.getRelative(0, 7, 0), this.rand);
        }
    }

    @Override
    public int getPathWidth() {
        return 3;
    }
}

