/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.monument.CageRoomPopulator;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BlockUtils;

public class LevelledRoomPopulator
extends CageRoomPopulator {
    public LevelledRoomPopulator(Random rand, MonumentDesign design, boolean forceSpawn, boolean unique) {
        super(rand, design, forceSpawn, unique);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getHeight() > 9;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        super.populate(data, room);
        int[] lowerBounds = room.getLowerCorner();
        int[] upperBounds = room.getUpperCorner();
        for (int x = lowerBounds[0] + 1; x <= upperBounds[0] - 1; ++x) {
            for (int i = lowerBounds[1] + 1; i <= upperBounds[1] - 1; ++i) {
                data.setType(x, room.getY() + 4, i, Material.PRISMARINE_BRICKS);
                if (Math.abs(x - room.getX()) > 2 || Math.abs(i - room.getZ()) > 2) continue;
                data.setType(x, room.getY() + 4, i, Material.DARK_PRISMARINE);
                if (Math.abs(x - room.getX()) > 1 || Math.abs(i - room.getZ()) > 1) continue;
                data.setType(x, room.getY() + 4, i, Material.WATER);
            }
        }
        Wall cent = new Wall(new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ()), BlockFace.NORTH);
        for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
            cent.getRelative(0, 1, 0).getRelative(face).getRelative(face).Pillar(2, this.rand, Material.DARK_PRISMARINE);
            cent.getRelative(face).setType(Material.DARK_PRISMARINE);
        }
        for (int[] corner : room.getAllCorners(1)) {
            for (int y = room.getY() + 5; y < room.getY() + room.getHeight(); ++y) {
                if (y == room.getY() + 5 || y == room.getY() + room.getHeight() - 1) {
                    data.setType(corner[0], y, corner[1], Material.DARK_PRISMARINE);
                    continue;
                }
                if (y % 2 == 0) {
                    Waterlogged wall = (Waterlogged)Bukkit.createBlockData((Material)Material.PRISMARINE_WALL);
                    wall.setWaterlogged(y <= TerraformGenerator.seaLevel);
                    data.setBlockData(corner[0], y, corner[1], (BlockData)wall);
                    continue;
                }
                data.setType(corner[0], y, corner[1], Material.SEA_LANTERN);
            }
        }
        for (int[] corner : room.getAllCorners(2)) {
            data.setType(corner[0], room.getY() + 3, corner[1], Material.SEA_LANTERN);
            data.setType(corner[0], room.getY() + 2, corner[1], Material.PRISMARINE_BRICKS);
        }
        for (int[] corner : room.getAllCorners(3)) {
            data.setType(corner[0], room.getY() + 1, corner[1], Material.PRISMARINE_BRICKS);
        }
    }
}

