/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.Wall;
import org.terraform.structure.monument.LevelledRoomPopulator;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.room.CubeRoom;

public class LevelledElderRoomPopulator
extends LevelledRoomPopulator {
    public LevelledElderRoomPopulator(Random rand, MonumentDesign design, boolean forceSpawn, boolean unique) {
        super(rand, design, forceSpawn, unique);
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getHeight() > 12;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int j;
        int length;
        Wall w;
        super.populate(data, room);
        for (Map.Entry<Wall, Integer> walls : room.getFourWalls(data, 1).entrySet()) {
            w = walls.getKey().getRelative(0, 4, 0);
            length = walls.getValue();
            for (j = 0; j < length; ++j) {
                if (j % 2 == 0) {
                    w.LPillar(room.getHeight() - 1, this.rand, Material.PRISMARINE_BRICKS);
                } else {
                    w.LPillar(room.getHeight() - 1, this.rand, Material.PRISMARINE);
                    w.getRelative(0, 3, 0).Pillar(4, this.rand, Material.SEA_LANTERN);
                }
                w.setType(Material.DARK_PRISMARINE);
                w = w.getLeft();
            }
        }
        for (Map.Entry<Wall, Integer> walls : room.getFourWalls(data, 2).entrySet()) {
            w = walls.getKey().getRelative(0, room.getHeight() - 2, 0);
            length = walls.getValue();
            for (j = 0; j < length; ++j) {
                Stairs stair = (Stairs)Bukkit.createBlockData((Material)this.design.stairs());
                stair.setFacing(w.getDirection().getOppositeFace());
                stair.setWaterlogged(true);
                stair.setHalf(Bisected.Half.TOP);
                w.setBlockData((BlockData)stair);
                w = w.getLeft();
            }
        }
        data.addEntity(room.getX() + 3, room.getY() + 8, room.getZ() - 3, EntityType.ELDER_GUARDIAN);
    }
}

