/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.monument;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.monument.MonumentDesign;
import org.terraform.structure.monument.MonumentRoomPopulator;
import org.terraform.structure.room.CubeRoom;
import org.terraform.utils.BlockUtils;

public class LanternPillarRoomPopulator
extends MonumentRoomPopulator {
    public LanternPillarRoomPopulator(Random rand, MonumentDesign design, boolean forceSpawn, boolean unique) {
        super(rand, design, forceSpawn, unique);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        void var5_11;
        super.populate(data, room);
        int y = room.getY() + room.getHeight() - 1;
        for (int i = 0; i < 5; ++i) {
            int z;
            int x;
            int[] nArray = room.getUpperCorner(1);
            int[] lowerBounds = room.getLowerCorner(1);
            for (x = lowerBounds[0]; x <= nArray[0]; ++x) {
                for (z = lowerBounds[1]; z <= nArray[1]; ++z) {
                    data.setType(x, y - i, z, this.design.mat(this.rand));
                }
            }
            int[] nArray2 = room.getUpperCorner(6 - i);
            lowerBounds = room.getLowerCorner(6 - i);
            for (x = lowerBounds[0]; x <= nArray2[0]; ++x) {
                for (z = lowerBounds[1]; z <= nArray2[1]; ++z) {
                    data.setType(x, y - i, z, Material.WATER);
                }
            }
        }
        Wall w = new Wall(new SimpleBlock(data, room.getX(), room.getY() + 1, room.getZ()), BlockFace.NORTH);
        w.LPillar(room.getHeight(), this.rand, Material.SEA_LANTERN);
        for (BlockFace face : BlockUtils.xzDiagonalPlaneBlockFaces) {
            w.getRelative(face).LPillar(room.getHeight(), true, this.rand, Material.DARK_PRISMARINE, Material.PRISMARINE_WALL);
        }
        for (BlockFace face : BlockUtils.directBlockFaces) {
            w.getRelative(face).LPillar(room.getHeight(), true, this.rand, Material.PRISMARINE_WALL, Material.WATER);
            for (int i = 0; i < room.getHeight() - 2; ++i) {
                BlockUtils.correctSurroundingMultifacingData(w.getRelative(face).getRelative(0, i, 0).get());
            }
        }
        int n = -2;
        while (var5_11 <= 2) {
            for (int nz = -2; nz <= 2; ++nz) {
                w.getRelative((int)var5_11, 0, nz).setType(this.design.mat(this.rand));
            }
            ++var5_11;
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return room.getHeight() > 12;
    }
}

