/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleBlock;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class OreLiftSchematicParser
extends SchematicParser {
    boolean isBadlands = false;

    public OreLiftSchematicParser() {
    }

    public OreLiftSchematicParser(boolean isBadlands) {
        this.isBadlands = isBadlands;
    }

    @Override
    public void applyData(SimpleBlock block, BlockData data) {
        PopulatorDataAbstract pop;
        if (BlockUtils.ores.contains(data.getMaterial())) {
            data = Bukkit.createBlockData((Material)GenUtils.randMaterial(BlockUtils.ores));
        }
        if (this.isBadlands && data.getMaterial().toString().contains("OAK")) {
            data = Bukkit.createBlockData((String)data.getAsString().replaceAll("oak_", "dark_oak_"));
            super.applyData(block, data);
        }
        if ((pop = block.getPopData()) instanceof PopulatorDataPostGen) {
            PopulatorDataPostGen gen = (PopulatorDataPostGen)pop;
            gen.noPhysicsUpdateForce(block.getX(), block.getY(), block.getZ(), data);
        } else {
            TerraformGeneratorPlugin.logger.error("Ore-lift generation attempted without PopulatorDataPostGen");
            super.applyData(block, data);
        }
    }
}

