/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.block.data.type.Slab;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class MineshaftPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;

    public MineshaftPathPopulator(Random rand) {
        this.rand = rand;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        boolean hasSupports;
        Wall core = new Wall(ppd.base, ppd.dir);
        if (core.getType() != Material.CAVE_AIR) {
            return;
        }
        Wall ceiling = core.findCeiling(10);
        if (ceiling != null) {
            ceiling = ceiling.getRelative(0, -1, 0);
        }
        Wall left = core.findLeft(10);
        Wall right = core.findRight(10);
        core.setType(GenUtils.randMaterial(Material.COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.ANDESITE, Material.DIORITE, Material.MOSSY_COBBLESTONE));
        core.getRight().setType(GenUtils.randMaterial(this.getPathMaterial()));
        core.getLeft().setType(GenUtils.randMaterial(this.getPathMaterial()));
        if (GenUtils.chance(this.rand, 1, 5)) {
            core.getRelative(0, -1, 0).getRight().downUntilSolid(this.rand, this.getFenceMaterial());
            core.getRelative(0, -1, 0).getLeft().downUntilSolid(this.rand, this.getFenceMaterial());
        }
        if (this.rand.nextBoolean()) {
            core.getRight(2).setType(GenUtils.randMaterial(this.getPathMaterial()));
        }
        if (this.rand.nextBoolean()) {
            core.getLeft(2).setType(GenUtils.randMaterial(this.getPathMaterial()));
        }
        Directional pebble = (Directional)Material.STONE_BUTTON.createBlockData("[face=floor]");
        for (int i = -2; i <= 2; ++i) {
            Wall target;
            if (i == 0 || (target = core.getLeft(i)).getType().toString().contains("SLAB") || !target.getType().isSolid() || target.getType() == Material.GRAVEL || target.getRelative(0, 1, 0).getType() != Material.CAVE_AIR) continue;
            if (GenUtils.chance(1, 10)) {
                pebble.setFacing(BlockUtils.getDirectBlockFace(this.rand));
                target.getRelative(0, 1, 0).setBlockData((BlockData)pebble);
                continue;
            }
            if (!GenUtils.chance(1, 10)) continue;
            target.getRelative(0, 1, 0).setType(GenUtils.randMaterial(Material.BROWN_MUSHROOM, Material.RED_MUSHROOM));
        }
        if (core.getType().isSolid() && this.rand.nextBoolean()) {
            Rail rail = (Rail)Bukkit.createBlockData((Material)Material.RAIL);
            switch (ppd.dir) {
                case NORTH: 
                case SOUTH: {
                    rail.setShape(Rail.Shape.NORTH_SOUTH);
                    break;
                }
                case EAST: 
                case WEST: {
                    rail.setShape(Rail.Shape.EAST_WEST);
                    break;
                }
            }
            if (rail instanceof Waterlogged && BlockUtils.isWet(core.getRelative(0, 1, 0).get())) {
                rail.setWaterlogged(true);
            }
            core.getRelative(0, 1, 0).setBlockData((BlockData)rail);
            BlockUtils.correctSurroundingRails(core.getRelative(0, 1, 0).get());
            if (GenUtils.chance(this.rand, 1, 100)) {
                TerraformGeneratorPlugin.logger.info("Minecart with chest at: " + core.getX() + ", " + core.getY() + ", " + core.getZ());
                PopulatorDataICAAbstract ica = TerraformGeneratorPlugin.injector.getICAData(((PopulatorDataPostGen)core.get().getPopData()).getChunk());
                ica.spawnMinecartWithChest(core.getX(), core.getY() + 1, core.getZ(), TerraLootTable.ABANDONED_MINESHAFT, this.rand);
            }
        }
        if (hasSupports = this.setMineshaftSupport(left, right, ceiling)) {
            return;
        }
        block5: for (int i = -2; i <= 2; ++i) {
            Wall ceil = core.getLeft(i).findCeiling(10);
            Wall floor = core.getLeft(i).findFloor(10);
            if (ceil != null && floor != null) {
                for (int ny = 0; ny <= ceil.getY() - floor.getY(); ++ny) {
                    Wall[] walls;
                    Wall[] wallArray = walls = new Wall[]{floor.getRelative(0, ny, 0).findLeft(10), floor.getRelative(0, ny, 0).findRight(10)};
                    int n = wallArray.length;
                    for (int j = 0; j < n; ++j) {
                        Wall target = wallArray[j];
                        if (target == null || target.getType() != Material.STONE) continue;
                        if (GenUtils.chance(1, 10)) {
                            target.setType(GenUtils.randMaterial(Material.COBBLESTONE, Material.MOSSY_COBBLESTONE));
                        }
                        if (!GenUtils.chance(1, 10)) continue;
                        BlockUtils.vineUp(target.get(), 2);
                    }
                }
            }
            if (ceil != null && !ceil.getType().toString().contains("SLAB") && !ceil.getType().toString().contains("LOG")) {
                ceil = ceil.getRelative(0, -1, 0);
                if (GenUtils.chance(this.rand, 1, 10)) {
                    boolean canSpawn = true;
                    for (BlockFace face : BlockUtils.directBlockFaces) {
                        if (!ceil.getRelative(face).getType().toString().contains("WALL")) continue;
                        canSpawn = false;
                        break;
                    }
                    if (canSpawn) {
                        ceil.downLPillar(this.rand, GenUtils.randInt(this.rand, 1, 3), Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                    }
                } else if (GenUtils.chance(this.rand, 1, 6)) {
                    ceil.setType(Material.COBWEB);
                } else if (GenUtils.chance(this.rand, 1, 10)) {
                    Slab slab = (Slab)Bukkit.createBlockData((Material)GenUtils.randMaterial(Material.COBBLESTONE_SLAB, Material.STONE_SLAB, Material.MOSSY_COBBLESTONE_SLAB));
                    slab.setType(Slab.Type.TOP);
                    ceil.setBlockData((BlockData)slab);
                }
            }
            if (floor == null || floor.getType().toString().contains("SLAB") || floor.getType().toString().contains("LOG")) continue;
            floor = floor.getRelative(0, 1, 0);
            if (GenUtils.chance(this.rand, 1, 10)) {
                boolean canSpawn = true;
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!floor.getRelative(face).getType().toString().contains("WALL")) continue;
                    canSpawn = false;
                    break;
                }
                if (!canSpawn) continue;
                floor.LPillar(GenUtils.randInt(this.rand, 1, 3), false, this.rand, Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL);
                continue;
            }
            if (GenUtils.chance(this.rand, 1, 10)) {
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!floor.getRelative(face).getType().isSolid()) continue;
                    Slab slab = (Slab)Bukkit.createBlockData((Material)GenUtils.randMaterial(Material.COBBLESTONE_SLAB, Material.STONE_SLAB, Material.MOSSY_COBBLESTONE_SLAB));
                    slab.setType(Slab.Type.BOTTOM);
                    floor.setBlockData((BlockData)slab);
                    continue block5;
                }
                continue;
            }
            if (!GenUtils.chance(1, 15)) continue;
            floor.setType(GenUtils.randMaterial(Material.BROWN_MUSHROOM, Material.RED_MUSHROOM));
        }
    }

    public boolean setMineshaftSupport(Wall left, Wall right, Wall ceil) {
        if (left == null || right == null) {
            return false;
        }
        if (left.getDirection().getModX() != 0 ? left.getX() % 5 != 0 : left.getDirection().getModZ() != 0 && left.getZ() % 5 != 0) {
            return false;
        }
        left = left.getRight();
        right = right.getLeft();
        int dist = (int)left.get().toVector().distance(right.get().toVector());
        if (dist >= 3) {
            if (left.LPillar(10, false, this.rand, Material.BARRIER) != 10) {
                left.LPillar(10, false, this.rand, this.getFenceMaterial());
                this.placeSupportFences(left.getRelative(0, -1, 0));
            }
            if (right.LPillar(10, false, this.rand, Material.BARRIER) != 10) {
                right.LPillar(10, false, this.rand, this.getFenceMaterial());
                this.placeSupportFences(right.getRelative(0, -1, 0));
            }
            if (ceil != null) {
                Orientable log = (Orientable)Bukkit.createBlockData((Material)this.getSupportMaterial());
                if (left.getDirection().getModX() != 0) {
                    log.setAxis(Axis.Z);
                }
                if (left.getDirection().getModZ() != 0) {
                    log.setAxis(Axis.X);
                }
                ceil = left.clone().getRelative(0, ceil.getY() - left.getY(), 0).getLeft();
                Lantern lantern = (Lantern)Bukkit.createBlockData((Material)Material.LANTERN);
                lantern.setHanging(true);
                for (int i = 0; i < dist + 2; ++i) {
                    Wall support = ceil.getRight(i);
                    if (support.getType().isSolid() && support.getType() != this.getFenceMaterial() || support.getRelative(0, 1, 0).getType() == this.getSupportMaterial() || support.getRelative(0, -1, 0).getType() == this.getSupportMaterial()) continue;
                    support.setBlockData((BlockData)log);
                    if (GenUtils.chance(this.rand, 1, 100)) {
                        support.getRelative(0, -1, 0).get().lsetBlockData((BlockData)lantern);
                    }
                    if (!GenUtils.chance(this.rand, 1, 10)) continue;
                    BlockUtils.vineUp(support.get(), 3);
                }
            }
        }
        return true;
    }

    private void placeSupportFences(Wall w) {
        while (!w.getType().isSolid()) {
            if (w.getType() == Material.LAVA) {
                w.setType(Material.COBBLESTONE);
            } else {
                w.setType(this.getFenceMaterial());
            }
            w = w.getRelative(0, -1, 0);
        }
    }

    @Override
    public boolean customCarve(SimpleBlock base, BlockFace dir, int pathWidth) {
        Wall core = new Wall(base.getRelative(0, 1, 0), dir);
        int seed = 55 + core.getX() + core.getY() ^ 2 + core.getZ() ^ 3;
        BlockUtils.carveCaveAir(seed, pathWidth, pathWidth + 1, pathWidth, core.get(), false, BlockUtils.badlandsStoneLike);
        return true;
    }

    @Override
    public int getPathWidth() {
        return 3;
    }

    public Material[] getPathMaterial() {
        return new Material[]{Material.OAK_PLANKS, Material.OAK_SLAB, Material.OAK_PLANKS, Material.OAK_SLAB, Material.GRAVEL};
    }

    public Material getFenceMaterial() {
        return Material.OAK_FENCE;
    }

    public Material getSupportMaterial() {
        return Material.OAK_LOG;
    }
}

