/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.mineshaft;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class CaveSpiderDenPopulator
extends RoomPopulatorAbstract {
    public CaveSpiderDenPopulator(Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        SimpleBlock b;
        int z;
        int x;
        int[] lowerCorner = room.getLowerCorner(3);
        int[] upperCorner = room.getUpperCorner(3);
        SimpleBlock center = room.getCenterSimpleBlock(data).getRelative(0, 1, 0);
        if (BlockUtils.isWet(center) || GenUtils.getHighestGround(data, center.getX(), center.getZ()) <= center.getY()) {
            return;
        }
        int y = room.getY();
        for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                b = new SimpleBlock(data, x, y, z);
                if (b.getType() != Material.CAVE_AIR) continue;
                b.setType(GenUtils.randMaterial(Material.OAK_PLANKS, Material.OAK_SLAB, Material.OAK_PLANKS, Material.OAK_SLAB, Material.MOSSY_COBBLESTONE, Material.COBBLESTONE, Material.COBBLESTONE_SLAB));
            }
        }
        for (x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                int limit;
                b = new SimpleBlock(data, x, y, z);
                for (limit = 10; limit > 0 && b.getType() != Material.CAVE_AIR; --limit) {
                    b = b.getRelative(0, 1, 0);
                }
                if (limit < 0) continue;
                if (x == room.getX() && z == room.getZ()) {
                    data.setSpawner(x, b.getY(), z, EntityType.CAVE_SPIDER);
                    continue;
                }
                Wall w = new Wall(b, BlockFace.NORTH);
                w.LPillar(GenUtils.randInt(0, 2), this.rand, Material.COBWEB);
            }
        }
    }

    @Override
    public boolean canPopulate(CubeRoom room) {
        return !room.isBig();
    }
}

