/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.caves;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.SeaPickle;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.caves.GenericLargeCavePopulator;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.MushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class MushroomCavePopulator
extends GenericLargeCavePopulator {
    @Override
    public void createLargeCave(TerraformWorld tw, Random rand, PopulatorDataAbstract data, int rY, int x, int y, int z) {
        int nz;
        int nx;
        TerraformGeneratorPlugin.logger.info("Generating Large Mushroom Cave at " + x + "," + y + "," + z);
        int rX = GenUtils.randInt(rand, 30, 50);
        int rZ = GenUtils.randInt(rand, 30, 50);
        MushroomCavePopulator.carveCaveSphere(tw, rX, rY, rZ, new SimpleBlock(data, x, y, z));
        FastNoise mycelNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_LARGECAVE_RAISEDGROUNDNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 5L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.04f);
            return n;
        });
        int lowestPoint = y - rY;
        for (nx = x - rX; nx <= x + rX; ++nx) {
            for (nz = z - rZ; nz <= z + rZ; ++nz) {
                int h2;
                double noise = mycelNoise.GetNoise(nx, nz);
                if (noise < 0.0) {
                    noise = 0.0;
                }
                if (noise > 0.5) {
                    noise = (noise - 0.5) * 0.5 + 0.5;
                }
                if ((h2 = (int)((double)(rY / 2) * noise) + 2) < 0) {
                    h2 = 0;
                }
                BlockUtils.spawnPillar(rand, data, nx, lowestPoint, nz, Material.DIRT, h2, h2);
                BlockUtils.downPillar(nx, lowestPoint - 1, nz, 20, data, Material.DIRT);
                if (data.getType(nx, lowestPoint + h2 + 1, nz) == Material.WATER) continue;
                data.setType(nx, lowestPoint + h2, nz, Material.MYCELIUM);
            }
        }
        for (nx = x - rX; nx <= x + rX; ++nx) {
            for (nz = z - rZ; nz <= z + rZ; ++nz) {
                int ceil;
                int ground = this.getCaveFloor(data, nx, y, nz);
                if (data.getType(nx, ground, nz).isSolid()) {
                    if (data.getType(nx, ground + 1, nz) == Material.WATER) {
                        if (GenUtils.chance(rand, 4, 100)) {
                            SeaPickle sp = (SeaPickle)Bukkit.createBlockData((Material)Material.SEA_PICKLE);
                            sp.setPickles(GenUtils.randInt(3, 4));
                            data.setBlockData(nx, ground + 1, nz, (BlockData)sp);
                        }
                    } else if (!data.getType(nx, ground + 1, nz).isSolid()) {
                        data.setType(nx, ground, nz, Material.MYCELIUM);
                    }
                }
                if (GenUtils.chance(1, 150) && data.getType(nx, ground, nz) == Material.MYCELIUM && data.getType(nx, ground + 1, nz) == Material.CAVE_AIR) {
                    new MushroomBuilder(switch (rand.nextInt(6)) {
                        case 0 -> FractalTypes.Mushroom.MEDIUM_RED_MUSHROOM;
                        case 1 -> FractalTypes.Mushroom.MEDIUM_BROWN_MUSHROOM;
                        case 2 -> FractalTypes.Mushroom.MEDIUM_BROWN_FUNNEL_MUSHROOM;
                        case 3 -> FractalTypes.Mushroom.SMALL_BROWN_MUSHROOM;
                        case 4 -> FractalTypes.Mushroom.SMALL_POINTY_RED_MUSHROOM;
                        default -> FractalTypes.Mushroom.SMALL_RED_MUSHROOM;
                    }).build(tw, data, nx, ground, nz);
                }
                if (nx > x + rX - 10 || nx < x - rX + 10 || nz > z + rZ - 10 || nz < z - rZ + 10 || !GenUtils.chance(rand, 3, 100) || !rand.nextBoolean() || (ceil = this.getCaveCeiling(data, nx, y, nz)) == -1) continue;
                int r = 2;
                int h3 = GenUtils.randInt(rand, rY / 2, (int)(1.5f * (float)rY));
                MushroomCavePopulator.stalactite(tw, rand, data, nx, ceil, nz, r, h3);
            }
        }
    }
}

