/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.caves;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.SeaPickle;
import org.terraform.biome.cave.LushClusterCavePopulator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.caves.GenericLargeCavePopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class LargeLushCavePopulator
extends GenericLargeCavePopulator {
    @Override
    public void createLargeCave(TerraformWorld tw, Random rand, PopulatorDataAbstract data, int rY, int x, int y, int z) {
        int h2;
        int nz;
        int nx;
        TerraformGeneratorPlugin.logger.info("Generating Large Lush Cave at " + x + "," + y + "," + z);
        int rX = GenUtils.randInt(rand, 30, 50);
        int rZ = GenUtils.randInt(rand, 30, 50);
        int waterY = LargeLushCavePopulator.carveCaveSphere(tw, rX, rY, rZ, new SimpleBlock(data, x, y, z));
        rZ -= 10;
        FastNoise raisedGroundNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.STRUCTURE_LARGECAVE_RAISEDGROUNDNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 5L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.05f);
            return n;
        });
        int lowestPoint = y - rY;
        for (nx = x - (rX -= 10); nx <= x + rX; ++nx) {
            for (nz = z - rZ; nz <= z + rZ; ++nz) {
                double noise = raisedGroundNoise.GetNoise(nx, nz);
                if (noise < 0.0) {
                    noise = 0.0;
                }
                if (noise > 0.5) {
                    noise = (noise - 0.5) * 0.5 + 0.5;
                }
                if ((h2 = (int)((double)(rY / 2) * noise) + 2) < 0) {
                    h2 = 0;
                }
                BlockUtils.spawnPillar(rand, data, nx, lowestPoint, nz, Material.STONE, h2, h2);
                BlockUtils.downPillar(nx, lowestPoint - 1, nz, 20, data, Material.STONE);
                data.setType(nx, lowestPoint + h2, nz, Material.STONE);
            }
        }
        for (nx = x - rX; nx <= x + rX; ++nx) {
            for (nz = z - rZ; nz <= z + rZ; ++nz) {
                int r;
                if (!GenUtils.chance(rand, 3, 100)) continue;
                if (rand.nextBoolean()) {
                    int ceil = this.getCaveCeiling(data, nx, y, nz);
                    if (ceil == -1) continue;
                    r = 2;
                    h2 = GenUtils.randInt(rand, rY / 2, (int)(1.5f * (float)rY));
                    LargeLushCavePopulator.stalactite(tw, rand, data, nx, ceil, nz, r, h2);
                    continue;
                }
                int ground = this.getCaveFloor(data, nx, y, nz);
                if (ground == -1) continue;
                r = 2;
                h2 = GenUtils.randInt(rand, rY / 2, (int)(1.5f * (float)rY));
                LargeLushCavePopulator.stalagmite(tw, rand, data, nx, ground, nz, r, h2);
            }
        }
        for (nx = x - rX; nx <= x + rX; ++nx) {
            for (nz = z - rZ; nz <= z + rZ; ++nz) {
                int groundY = this.getCaveFloor(data, nx, y, nz);
                int ceilingY = this.getCaveCeiling(data, nx, y, nz);
                if (groundY == -1 || ceilingY == -1 || !data.getType(nx, groundY, nz).isSolid()) continue;
                SimpleBlock floor = new SimpleBlock(data, nx, groundY, nz);
                SimpleBlock ceil = new SimpleBlock(data, nx, ceilingY, nz);
                if (data.getType(nx, groundY + 1, nz) == Material.WATER) {
                    if (GenUtils.chance(rand, 7, 100)) {
                        SeaPickle sp = (SeaPickle)Bukkit.createBlockData((Material)Material.SEA_PICKLE);
                        sp.setPickles(GenUtils.randInt(3, 4));
                        data.setBlockData(nx, groundY + 1, nz, (BlockData)sp);
                    }
                    if (GenUtils.chance(rand, 7, 100)) {
                        new SphereBuilder(rand, new SimpleBlock(data, nx, groundY, nz), Material.CLAY).setRadius(3.0f).addToWhitelist(Material.STONE).addToWhitelist(OneOneSevenBlockHandler.DEEPSLATE).build();
                    }
                    if (GenUtils.chance(rand, 7, 100)) {
                        data.setType(nx, waterY + 1, nz, Material.LILY_PAD);
                    }
                } else if (BlockUtils.isAir(data.getType(nx, groundY + 1, nz)) && GenUtils.chance(rand, 5, 100)) {
                    new LushClusterCavePopulator(GenUtils.randInt(rand, 5, 11), true).populate(tw, rand, ceil, floor);
                }
                if (!(data instanceof PopulatorDataICABiomeWriterAbstract)) continue;
                for (int i = groundY; i <= ceilingY; ++i) {
                    ((PopulatorDataICABiomeWriterAbstract)data).setBiome(nx, i, nz, OneOneSevenBlockHandler.LUSH_CAVES);
                }
            }
        }
    }

    @Override
    public int getCaveCeiling(PopulatorDataAbstract data, int x, int y, int z) {
        int ny;
        int highest = GenUtils.getHighestGround(data, x, z);
        for (ny = y; ny < highest && !data.getType(x, ny, z).isSolid(); ++ny) {
        }
        if (ny >= highest) {
            return -1;
        }
        return ny;
    }

    @Override
    public int getCaveFloor(PopulatorDataAbstract data, int x, int y, int z) {
        int ny;
        for (ny = y; ny > 2 && !data.getType(x, ny, z).isSolid(); --ny) {
        }
        return Math.max(ny, 2);
    }
}

