/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.caves;

import java.util.Random;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.caves.GenericLargeCavePopulator;
import org.terraform.structure.caves.LargeLushCavePopulator;
import org.terraform.structure.caves.MushroomCavePopulator;
import org.terraform.utils.GenUtils;

public class LargeCavePopulator
extends SingleMegaChunkStructurePopulator {
    @Override
    public void populate(TerraformWorld tw, PopulatorDataAbstract data) {
        if (!TConfigOption.STRUCTURES_LARGECAVE_ENABLED.getBoolean()) {
            return;
        }
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        int[] spawnCoords = mc.getCenterBiomeSectionBlockCoords();
        int x = spawnCoords[0];
        int z = spawnCoords[1];
        Random rand = tw.getHashedRand(x, z, 999323);
        int highest = HeightMap.getBlockHeight(tw, x, z);
        int rY = (highest - 20) / 2;
        switch (rand.nextInt(3)) {
            case 0: {
                new GenericLargeCavePopulator().createLargeCave(tw, rand, data, rY, x, rY + 6, z);
                break;
            }
            case 1: {
                new MushroomCavePopulator().createLargeCave(tw, rand, data, rY, x, rY + 6, z);
                break;
            }
            default: {
                new LargeLushCavePopulator().createLargeCave(tw, rand, data, rY, x, rY + 6, z);
            }
        }
    }

    private boolean rollSpawnRatio(TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 12345), (int)(TConfigOption.STRUCTURES_LARGECAVE_SPAWNRATIO.getDouble() * 10000.0), 10000);
    }

    @Override
    public boolean canSpawn(TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        if (biome.getType() == BiomeType.DEEP_OCEANIC) {
            return false;
        }
        return this.rollSpawnRatio(tw, chunkX, chunkZ);
    }

    @Override
    public Random getHashedRandom(TerraformWorld tw, int chunkX, int chunkZ) {
        return tw.getHashedRand(123912L, chunkX, chunkZ);
    }

    @Override
    public boolean isEnabled() {
        return TConfigOption.STRUCTURES_LARGECAVE_ENABLED.getBoolean();
    }

    @Override
    public int getChunkBufferDistance() {
        return 0;
    }
}

