/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.terraform.coregen.TerraLootTable;
import org.terraform.data.SimpleBlock;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class AncientCitySchematicParser
extends SchematicParser {
    @Override
    public void applyData(SimpleBlock block, BlockData data) {
        Random rand = new Random();
        if (data.getMaterial() == OneOneSevenBlockHandler.DEEPSLATE_TILES) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)OneOneSevenBlockHandler.CRACKED_DEEPSLATE_TILES);
            }
        } else if (data.getMaterial() == OneOneSevenBlockHandler.DEEPSLATE_BRICKS) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)OneOneSevenBlockHandler.CRACKED_DEEPSLATE_BRICKS);
            }
        } else if (data.getMaterial() == Material.DARK_OAK_PLANKS || data.getMaterial() == Material.DARK_OAK_SLAB) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)Material.AIR);
            }
        } else if (data.getMaterial() == OneOneSevenBlockHandler.CANDLE) {
            try {
                Lightable candle = (Lightable)Bukkit.createBlockData((Material)OneOneSevenBlockHandler.CANDLE);
                candle.setLit(true);
                if (OneOneSevenBlockHandler.setCandlesMethod == null) {
                    OneOneSevenBlockHandler.setCandlesMethod = Class.forName("org.bukkit.block.data.type.Candle").getMethod("setCandles", Integer.TYPE);
                }
                OneOneSevenBlockHandler.setCandlesMethod.invoke((Object)candle, 1 + rand.nextInt(4));
                data = candle;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (data.getMaterial() == Material.CHEST) {
            if (GenUtils.chance(rand, 2, 5)) {
                block.setType(Material.AIR);
                return;
            }
            super.applyData(block, data);
            block.getPopData().lootTableChest(block.getX(), block.getY(), block.getZ(), TerraLootTable.ANCIENT_CITY);
            return;
        }
        super.applyData(block, data);
    }
}

