/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.HashSet;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.MegaChunk;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.ancientcity.AncientCityAltarPopulator;
import org.terraform.structure.ancientcity.AncientCityCenterPlatformPopulator;
import org.terraform.structure.ancientcity.AncientCityLargePillarRoomPopulator;
import org.terraform.structure.ancientcity.AncientCityPathPopulator;
import org.terraform.structure.ancientcity.AncientCityRuinsPlatform;
import org.terraform.structure.ancientcity.AncientCitySchematicPlatform;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.RoomLayout;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.MultipleFacingBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneNineBlockHandler;
import org.terraform.utils.version.Version;

public class AncientCityPopulator
extends SingleMegaChunkStructurePopulator {
    @Override
    public boolean canSpawn(TerraformWorld tw, int chunkX, int chunkZ, BiomeBank biome) {
        if (!TConfigOption.STRUCTURES_ANCIENTCITY_ENABLED.getBoolean()) {
            return false;
        }
        if (biome.getType() != BiomeType.MOUNTAINOUS && biome.getType() != BiomeType.HIGH_MOUNTAINOUS) {
            return false;
        }
        if (!Version.isAtLeast(19.0)) {
            return false;
        }
        return this.rollSpawnRatio(tw, chunkX, chunkZ);
    }

    private boolean rollSpawnRatio(TerraformWorld tw, int chunkX, int chunkZ) {
        return GenUtils.chance(tw.getHashedRand(chunkX, chunkZ, 123122), (int)(TConfigOption.STRUCTURES_ANCIENTCITY_SPAWNRATIO.getDouble() * 10000.0), 10000);
    }

    @Override
    public void populate(TerraformWorld tw, PopulatorDataAbstract data) {
        if (!TConfigOption.STRUCTURES_ANCIENTCITY_ENABLED.getBoolean()) {
            return;
        }
        MegaChunk mc = new MegaChunk(data.getChunkX(), data.getChunkZ());
        int[] coords = mc.getCenterBiomeSectionBlockCoords();
        int x = coords[0];
        int z = coords[1];
        int minY = TConfigOption.STRUCTURES_ANCIENTCITY_MIN_Y.getInt();
        int y = GenUtils.randInt(minY, TConfigOption.STRUCTURES_ANCIENTCITY_MAX_Y.getInt());
        this.spawnAncientCity(tw, tw.getHashedRand(x, y, z, 23412222L), data, x, y + 1, z);
    }

    public void spawnAncientCity(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int y, int z) {
        TerraformGeneratorPlugin.logger.info("Spawning ancient city at: " + x + "," + y + "," + z);
        HashSet<SimpleLocation> occupied = new HashSet<SimpleLocation>();
        Random hashedRand = tw.getHashedRand(x, y, z);
        RoomLayoutGenerator gen = new RoomLayoutGenerator(hashedRand, RoomLayout.RANDOM_BRUTEFORCE, 40, x, y, z, 120);
        gen.setPathPopulator(new AncientCityPathPopulator(tw.getHashedRand(x, y, z, 2L), gen, occupied));
        gen.setRoomMaxX(26);
        gen.setRoomMaxZ(26);
        gen.setRoomMinHeight(14);
        gen.setRoomMinHeight(20);
        gen.setRoomMinX(16);
        gen.setRoomMinZ(16);
        gen.registerRoomPopulator(new AncientCityRuinsPlatform(tw, occupied, gen, random, false, false));
        gen.registerRoomPopulator(new AncientCitySchematicPlatform(tw, occupied, gen, random, false, false));
        gen.registerRoomPopulator(new AncientCityAltarPopulator(tw, occupied, gen, random, false, false));
        gen.registerRoomPopulator(new AncientCityLargePillarRoomPopulator(tw, occupied, gen, random, false, false));
        CubeRoom room = new CubeRoom(50, 50, 40, x, y, z);
        room.setRoomPopulator(new AncientCityCenterPlatformPopulator(tw, occupied, gen, random, true, true));
        gen.getRooms().add(room);
        gen.setCarveRooms(true);
        gen.setCarveRoomsMultiplier(1.5f, 2.0f, 1.5f);
        gen.generate();
        gen.carvePathsOnly(data, tw, Material.CAVE_AIR);
        gen.carveRoomsOnly(data, tw, Material.CAVE_AIR);
        float radius = 80.0f;
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_CAVECLUSTER_CIRCLENOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        SimpleBlock center = new SimpleBlock(data, x, y, z);
        TerraformGeneratorPlugin.logger.info("Spawning sculk...");
        PopulatorDataICABiomeWriterAbstract ica = null;
        if (center.getPopData() instanceof PopulatorDataICABiomeWriterAbstract) {
            ica = (PopulatorDataICABiomeWriterAbstract)center.getPopData();
        }
        for (float nx = -radius; nx <= radius; nx += 1.0f) {
            for (float nz = -radius; nz <= radius; nz += 1.0f) {
                for (float ny = -50.0f; ny <= 50.0f; ny += 1.0f) {
                    float noiseVal;
                    double equationResult;
                    SimpleBlock rel = center.getRelative(Math.round(nx), Math.round(ny), Math.round(nz));
                    if (ica != null) {
                        ica.setBiome(rel.getX(), rel.getY(), rel.getZ(), OneOneNineBlockHandler.DEEP_DARK);
                    }
                    if (!BlockUtils.isStoneLike(rel.getType()) || !((equationResult = Math.pow(nx, 2.0) / Math.pow(radius, 2.0) + Math.pow(nz, 2.0) / Math.pow(radius, 2.0) + Math.pow(ny, 2.0) / Math.pow(50.0, 2.0)) <= 1.0 + 0.7 * (double)(noiseVal = circleNoise.GetNoise(rel.getX(), rel.getY(), rel.getZ())))) continue;
                    if (BlockUtils.isExposedToNonSolid(rel) || !rel.getDown().isSolid() || !rel.getUp().isSolid()) {
                        if (equationResult <= 0.7 * (1.0 + 0.7 * (double)noiseVal)) {
                            rel.setType(OneOneNineBlockHandler.SCULK);
                            if (rel.getUp().isSolid()) continue;
                            if (GenUtils.chance(random, 1, 230)) {
                                rel.getUp().setType(OneOneNineBlockHandler.SCULK_CATALYST);
                                continue;
                            }
                            if (GenUtils.chance(random, 1, 150)) {
                                rel.getUp().setType(OneOneNineBlockHandler.SCULK_SENSOR);
                                continue;
                            }
                            if (!GenUtils.chance(random, 1, 600)) continue;
                            rel.getUp().setBlockData(OneOneNineBlockHandler.getActiveSculkShrieker());
                            continue;
                        }
                        for (BlockFace face : BlockUtils.sixBlockFaces) {
                            SimpleBlock adj = rel.getRelative(face);
                            if (adj.isAir()) {
                                new MultipleFacingBuilder(OneOneNineBlockHandler.SCULK_VEIN).setFace(face.getOppositeFace(), true).apply(adj);
                                continue;
                            }
                            if (!(adj.getBlockData() instanceof MultipleFacing)) continue;
                            MultipleFacing mf = (MultipleFacing)adj.getBlockData();
                            mf.setFace(face.getOppositeFace(), true);
                            adj.setBlockData((BlockData)mf);
                        }
                        continue;
                    }
                    if (rel.getType() != Material.WATER) continue;
                    rel.setType(Material.CAVE_AIR);
                }
            }
        }
        gen.populatePathsOnly();
        gen.runRoomPopulators(data, tw);
    }

    @Override
    public Random getHashedRandom(TerraformWorld world, int chunkX, int chunkZ) {
        return world.getHashedRand(318377L, chunkX, chunkZ);
    }

    @Override
    public boolean isEnabled() {
        return TConfigOption.STRUCTURES_ANCIENTCITY_ENABLED.getBoolean();
    }

    @Override
    public int getChunkBufferDistance() {
        return 0;
    }
}

