/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.terraform.data.SimpleBlock;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.version.OneOneNineBlockHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class AncientCityPillarSchematicParser
extends SchematicParser {
    private int failCount = 0;
    private int totalCount = 0;
    ArrayList<SimpleBlock> touchedOffsets = new ArrayList();

    public ArrayList<SimpleBlock> getTouchedOffsets() {
        return this.touchedOffsets;
    }

    public float calculateFailRate() {
        return (float)this.failCount / (float)this.totalCount;
    }

    @Override
    public void applyData(SimpleBlock block, BlockData data) {
        Random rand = new Random();
        ++this.totalCount;
        if (block.isSolid() && block.getType() != OneOneNineBlockHandler.SCULK_VEIN) {
            ++this.failCount;
            return;
        }
        if (this.touchedOffsets.size() == 0 || this.touchedOffsets.get(0).getY() == block.getY()) {
            this.touchedOffsets.add(block);
        } else if (this.touchedOffsets.get(0).getY() < block.getY()) {
            this.touchedOffsets.clear();
            this.touchedOffsets.add(block);
        }
        if (data.getMaterial() == OneOneSevenBlockHandler.DEEPSLATE_TILES) {
            if (rand.nextBoolean()) {
                data = Bukkit.createBlockData((Material)OneOneSevenBlockHandler.CRACKED_DEEPSLATE_TILES);
            }
        } else if (data.getMaterial() == OneOneSevenBlockHandler.DEEPSLATE_BRICKS && rand.nextBoolean()) {
            data = Bukkit.createBlockData((Material)OneOneSevenBlockHandler.CRACKED_DEEPSLATE_BRICKS);
        }
        super.applyData(block, data);
    }
}

