/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Lantern;
import org.bukkit.block.data.type.Slab;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.Wall;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.ancientcity.AncientCityPathMiniRoomPlacer;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.PathPopulatorAbstract;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.SlabBuilder;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class AncientCityPathPopulator
extends PathPopulatorAbstract {
    private final Random rand;
    private final RoomLayoutGenerator gen;
    private HashSet<SimpleLocation> occupied;

    public AncientCityPathPopulator(Random rand, RoomLayoutGenerator gen, HashSet<SimpleLocation> occupied) {
        this.rand = rand;
        this.gen = gen;
        this.occupied = occupied;
    }

    @Override
    public void populate(PathPopulatorData ppd) {
        Wall core = new Wall(ppd.base, ppd.dir);
        if (this.gen.isInRoom(new int[]{ppd.base.getX(), ppd.base.getZ()})) {
            return;
        }
        if (ppd.isTurn) {
            for (int nx = -1; nx <= 1; ++nx) {
                for (int nz = -1; nz <= 1; ++nz) {
                    core.getRelative(nx, 0, nz).setType(Material.GRAY_WOOL);
                }
            }
            AncientCityUtils.placeSupportPillar(core.getDown());
            for (BlockFace face : BlockUtils.directBlockFaces) {
                core.getRelative(face, 2).lsetType(AncientCityUtils.deepslateBricks);
                for (BlockFace rel : BlockUtils.getAdjacentFaces(face)) {
                    core.getRelative(rel).getRelative(face, 2).lsetType(AncientCityUtils.deepslateBricks);
                }
            }
        } else if (!ppd.isEnd) {
            core.setType(Material.GRAY_WOOL);
            core.getLeft().setType(Material.GRAY_WOOL);
            core.getRight().setType(Material.GRAY_WOOL);
            core.getUp().Pillar(3, Material.AIR);
            new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setHalf(Bisected.Half.TOP).setFacing(BlockUtils.getLeft(ppd.dir)).lapply(core.getRight(2)).setFacing(BlockUtils.getRight(ppd.dir)).lapply(core.getLeft(2));
            int state = ppd.dir == BlockFace.NORTH ? -1 * core.getZ() % 9 : (ppd.dir == BlockFace.SOUTH ? core.getZ() % 9 : (ppd.dir == BlockFace.EAST ? core.getX() % 9 : -1 * core.getX() % 9));
            if (state < 0) {
                state += 9;
            }
            if (!ppd.isOverlapped) {
                this.placeWallArc(core, state);
            }
        } else {
            AncientCityPathMiniRoomPlacer.placeAltar(core, this.rand);
        }
    }

    private void placeWallArc(Wall core, int state) {
        if (this.occupied.contains(core.getLoc()) || this.occupied.contains(core.getRight().getLoc()) || this.occupied.contains(core.getLeft().getLoc())) {
            return;
        }
        this.occupied.add(core.getLoc());
        this.occupied.add(core.getRight().getLoc());
        this.occupied.add(core.getLeft().getLoc());
        BlockFace pathFacing = core.getDirection();
        if (state > 4) {
            pathFacing = core.getDirection().getOppositeFace();
        }
        switch (state) {
            case 0: {
                core.getUp(6).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_WALL);
                core.getUp(5).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICKS);
                Lantern lantern = (Lantern)Bukkit.createBlockData((Material)Material.SOUL_LANTERN);
                lantern.setHanging(true);
                core.getUp(4).lsetBlockData((BlockData)lantern);
                AncientCityUtils.placeSupportPillar(core.getDown());
                for (BlockFace leftRight : BlockUtils.getAdjacentFaces(core.getDirection())) {
                    new StairBuilder(OneOneSevenBlockHandler.POLISHED_DEEPSLATE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(leftRight.getOppositeFace()).apply(core.getRelative(leftRight, 2).getDown());
                    core.getRelative(leftRight, 2).setType(OneOneSevenBlockHandler.CHISELED_DEEPSLATE);
                    core.getRelative(leftRight, 2).getUp().lsetType(OneOneSevenBlockHandler.DEEPSLATE_TILES);
                    core.getRelative(leftRight, 2).getUp(2).LPillar(2, OneOneSevenBlockHandler.POLISHED_DEEPSLATE);
                    core.getRelative(leftRight, 2).getUp(4).lsetType(OneOneSevenBlockHandler.CHISELED_DEEPSLATE);
                    new StairBuilder(OneOneSevenBlockHandler.POLISHED_DEEPSLATE_STAIRS).setFacing(leftRight.getOppositeFace()).lapply(core.getUp(5).getRelative(leftRight, 2));
                    new StairBuilder(OneOneSevenBlockHandler.POLISHED_DEEPSLATE_STAIRS).setFacing(leftRight).setHalf(Bisected.Half.TOP).lapply(core.getUp(4).getRelative(leftRight));
                    core.getRelative(leftRight).getUp(5).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICKS);
                }
                break;
            }
            case 1: 
            case 8: {
                new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_TILE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(pathFacing.getOppositeFace()).lapply(core.getUp(5));
                for (BlockFace leftRight : BlockUtils.getAdjacentFaces(core.getDirection())) {
                    new SlabBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(core.getRelative(leftRight, 2).getDown());
                    new StairBuilder(OneOneSevenBlockHandler.POLISHED_DEEPSLATE_STAIRS).setFacing(pathFacing.getOppositeFace()).lapply(core.getRelative(leftRight, 2).getUp());
                    new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_TILE_STAIRS).setHalf(Bisected.Half.TOP).setFacing(pathFacing.getOppositeFace()).lapply(core.getRelative(leftRight, 2).getUp(4));
                    core.getRelative(leftRight, 2).getUp(5).lsetType(OneOneSevenBlockHandler.DEEPSLATE_TILES);
                    core.getRelative(leftRight).getUp(5).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_WALL);
                    core.getRelative(leftRight).getUp(6).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
                }
                break;
            }
            case 2: 
            case 7: {
                for (BlockFace leftRight : BlockUtils.getAdjacentFaces(core.getDirection())) {
                    new SlabBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(core.getRelative(leftRight, 2).getDown()).lapply(core.getRelative(leftRight).getUp(5));
                    core.getRelative(leftRight, 2).getUp(5).lsetType(OneOneSevenBlockHandler.DEEPSLATE_TILES);
                    core.getRelative(leftRight, 2).getUp(6).lsetType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
                }
                break;
            }
            case 3: 
            case 6: {
                new SlabBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(core.getUp(5));
                for (BlockFace leftRight : BlockUtils.getAdjacentFaces(core.getDirection())) {
                    new SlabBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(core.getRelative(leftRight, 2).getUp(5));
                    new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(pathFacing.getOppositeFace()).lapply(core.getRelative(leftRight, 2).getUp(6));
                }
                break;
            }
            case 4: 
            case 5: {
                new SlabBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB).setType(Slab.Type.TOP).lapply(core.getUp(5));
                for (BlockFace leftRight : BlockUtils.getAdjacentFaces(core.getDirection())) {
                    new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(leftRight).setHalf(Bisected.Half.TOP).lapply(core.getRelative(leftRight, 2).getUp(5));
                    new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(pathFacing.getOppositeFace()).lapply(core.getRelative(leftRight, 2).getUp(6));
                }
                break;
            }
            default: {
                TerraformGeneratorPlugin.logger.info("Ancient City Populator: Irregular path state: " + state);
            }
        }
    }

    @Override
    public boolean customCarve(SimpleBlock base, BlockFace dir, int pathWidth) {
        Wall core = new Wall(base.getRelative(0, 1, 0), dir);
        int seed = 55 + core.getX() + core.getY() ^ 2 + core.getZ() ^ 3;
        Object carveMaterials = BlockUtils.stoneLike.clone();
        ((AbstractCollection)carveMaterials).addAll(BlockUtils.caveDecoratorMaterials);
        BlockUtils.carveCaveAir(seed, pathWidth + 3, pathWidth + 3, pathWidth + 3, 0.09f, core.get(), true, true, (EnumSet<Material>)carveMaterials);
        return true;
    }

    @Override
    public int getPathWidth() {
        return 3;
    }
}

