/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.terraform.data.SimpleBlock;
import org.terraform.data.Wall;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.blockdata.StairBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class AncientCityPathMiniRoomPlacer {
    public static void placeAltar(Wall origin, Random rand) {
        Material[] deepSlateBricks = new Material[]{OneOneSevenBlockHandler.DEEPSLATE_BRICKS, OneOneSevenBlockHandler.CRACKED_DEEPSLATE_BRICKS};
        AncientCityPathMiniRoomPlacer.cylinderDown(origin, 4, deepSlateBricks);
        AncientCityPathMiniRoomPlacer.cylinderDown(origin.getUp(), 3, deepSlateBricks);
        new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(origin.getDirection()).apply(origin.getRear(2).getUp()).apply(origin.getRear().getLeft().getUp()).apply(origin.getRear().getRight().getUp());
        origin.getRear(3).getUp().fluidize();
        origin.getRear(2).getUp().getLeft().fluidize();
        origin.getRear(2).getUp().getRight().fluidize();
        Wall altarCore = origin.getFront(2).getUp(2);
        altarCore.setType(deepSlateBricks);
        altarCore.getLeft().setType(deepSlateBricks);
        altarCore.getRight().setType(deepSlateBricks);
        new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(altarCore.getDirection()).apply(altarCore.getRear()).setFacing(altarCore.getDirection().getOppositeFace()).apply(altarCore.getFront());
        altarCore.getFront().getDown().setType(deepSlateBricks);
        altarCore.getRear().getLeft().setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getRear().getRight().setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getLeft(2).setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getRight(2).setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getUp().Pillar(2, OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL);
        altarCore.getUp().getLeft().Pillar(2, OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL);
        altarCore.getUp().getRight().Pillar(2, OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL);
        altarCore.getUp(3).setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getUp(3).getLeft().setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        altarCore.getUp(3).getRight().setType(OneOneSevenBlockHandler.DEEPSLATE_BRICK_SLAB);
        for (BlockFace adj : BlockUtils.getAdjacentFaces(altarCore.getDirection())) {
            new StairBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setFacing(adj.getOppositeFace()).apply(altarCore.getRelative(adj, 2).getUp(2)).setHalf(Bisected.Half.TOP).apply(altarCore.getRelative(adj, 2).getUp());
        }
    }

    private static void cylinderDown(SimpleBlock core, int radius, Material ... mat) {
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                SimpleBlock rel = core.getRelative(Math.round(x), 0, Math.round(z));
                double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                if (!(equationResult <= 1.0)) continue;
                rel.downUntilSolid(new Random(), mat);
            }
        }
    }
}

