/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.structure.ancientcity;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.structure.ancientcity.AncientCityUtils;
import org.terraform.structure.room.CarvedRoom;
import org.terraform.structure.room.CubeRoom;
import org.terraform.structure.room.PathPopulatorData;
import org.terraform.structure.room.RoomLayoutGenerator;
import org.terraform.structure.room.RoomPopulatorAbstract;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StairwayBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public abstract class AncientCityAbstractRoomPopulator
extends RoomPopulatorAbstract {
    TerraformWorld tw;
    protected HashSet<SimpleLocation> occupied;
    protected int shrunkenWidth = 0;
    protected RoomLayoutGenerator gen;
    protected CubeRoom effectiveRoom = null;

    public AncientCityAbstractRoomPopulator(TerraformWorld tw, HashSet<SimpleLocation> occupied, RoomLayoutGenerator gen, Random rand, boolean forceSpawn, boolean unique) {
        super(rand, forceSpawn, unique);
        this.tw = tw;
        this.occupied = occupied;
        this.gen = gen;
    }

    @Override
    public void populate(PopulatorDataAbstract data, CubeRoom room) {
        int depression = this.shrunkenWidth = GenUtils.randInt(this.rand, 2, 4);
        if (this.rand.nextBoolean()) {
            depression *= -1;
        }
        this.effectiveRoom = new CarvedRoom(new CubeRoom(room.getWidthX() - this.shrunkenWidth * 2 - 1, room.getWidthZ() - this.shrunkenWidth * 2 - 1, room.getHeight(), room.getX(), room.getY() + depression, room.getZ()));
        this.effectiveRoom.fillRoom(data, Material.CAVE_AIR);
        int[] lowerCorner = this.effectiveRoom.getLowerCorner(0);
        int[] upperCorner = this.effectiveRoom.getUpperCorner(0);
        int y = this.effectiveRoom.getY();
        for (int x = lowerCorner[0]; x <= upperCorner[0]; ++x) {
            for (int z = lowerCorner[1]; z <= upperCorner[1]; ++z) {
                SimpleBlock b = new SimpleBlock(data, x, y, z);
                if (x == lowerCorner[0] || x == upperCorner[0] || z == lowerCorner[1] || z == upperCorner[1]) {
                    if (this.rand.nextBoolean()) {
                        b.lsetType(AncientCityUtils.deepslateBricks);
                    }
                } else {
                    b.lsetType(AncientCityUtils.deepslateBricks);
                }
                int relX = this.effectiveRoom.getX() - x;
                int relZ = this.effectiveRoom.getZ() - z;
                if (relX % 5 != 0 || relZ % 5 != 0 || !this.effectiveRoom.isPointInside(b.getRelative(BlockFace.NORTH)) || !this.effectiveRoom.isPointInside(b.getRelative(BlockFace.SOUTH)) || !this.effectiveRoom.isPointInside(b.getRelative(BlockFace.EAST)) || !this.effectiveRoom.isPointInside(b.getRelative(BlockFace.WEST))) continue;
                AncientCityUtils.placeSupportPillar(b.getDown());
            }
        }
        for (Map.Entry<Wall, Integer> entry : room.getFourWalls(data, 0).entrySet()) {
            Wall w = entry.getKey().getDown();
            for (int i = this.shrunkenWidth; i < entry.getValue() - this.shrunkenWidth; ++i) {
                if (this.gen.getPathPopulators().contains(new PathPopulatorData(w.getRear().getAtY(room.getY()), 3))) {
                    w.setType(AncientCityUtils.deepslateBricks);
                    w.getLeft().setType(AncientCityUtils.deepslateBricks);
                    w.getRight().setType(AncientCityUtils.deepslateBricks);
                    if (depression < 0) {
                        new StairwayBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setDownTypes(AncientCityUtils.deepslateBricks).setStairwayDirection(BlockFace.DOWN).setStopAtY(this.effectiveRoom.getY()).build(w.getFront()).build(w.getFront().getLeft()).build(w.getFront().getRight());
                    } else {
                        new StairwayBuilder(OneOneSevenBlockHandler.DEEPSLATE_BRICK_STAIRS).setDownTypes(AncientCityUtils.deepslateBricks).setStairwayDirection(BlockFace.UP).setUpwardsCarveUntilNotSolid(false).setStopAtY(this.effectiveRoom.getY()).build(w.getUp().getFront()).build(w.getUp().getFront().getLeft()).build(w.getUp().getFront().getRight());
                    }
                }
                w = w.getLeft();
            }
        }
    }

    public void sculkUp(TerraformWorld tw, PopulatorDataAbstract data, CubeRoom room) {
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_CAVECLUSTER_CIRCLENOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        for (int i = 0; i <= room.getWidthX() * room.getWidthZ() / 150; ++i) {
            int[] coords = room.randomCoords(this.rand);
            int y = this.rand.nextInt(5);
            SimpleBlock target = new SimpleBlock(data, coords[0], room.getY() + y, coords[2]);
            AncientCityUtils.spreadSculk(circleNoise, this.rand, 5.0f, target);
        }
    }
}

