/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.schematic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.util.Vector;
import org.terraform.coregen.BlockDataFixerAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.schematic.SchematicParser;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.version.Version;

public class TerraSchematic {
    public static HashMap<String, HashMap<Vector, BlockData>> cache = new HashMap();
    public SchematicParser parser = new SchematicParser();
    HashMap<Vector, BlockData> data = new HashMap();
    SimpleBlock refPoint;
    BlockFace face = BlockFace.NORTH;
    private double VERSION_VALUE;

    public TerraSchematic(SimpleBlock vector) {
        this.refPoint = vector;
    }

    public TerraSchematic(Location loc) {
        this.refPoint = new SimpleBlock(loc);
    }

    public TerraSchematic clone(SimpleBlock refPoint) {
        TerraSchematic clone = new TerraSchematic(refPoint);
        clone.data = new HashMap();
        for (Map.Entry<Vector, BlockData> entry : this.data.entrySet()) {
            clone.data.put(entry.getKey(), entry.getValue());
        }
        clone.VERSION_VALUE = this.VERSION_VALUE;
        return clone;
    }

    public static TerraSchematic load(String internalPath, SimpleBlock refPoint) throws FileNotFoundException {
        TerraSchematic schem = new TerraSchematic(refPoint);
        if (cache.containsKey(internalPath)) {
            schem.data = cache.get(internalPath);
            return schem.clone(refPoint);
        }
        InputStream is = ((Object)((Object)TerraformGeneratorPlugin.get())).getClass().getResourceAsStream("/" + internalPath + ".terra");
        Scanner sc = new Scanner(is);
        String line = sc.nextLine();
        schem.VERSION_VALUE = Version.toVersionDouble(line);
        while (sc.hasNextLine()) {
            BlockData value;
            line = sc.nextLine();
            if (line.isEmpty()) continue;
            String[] cont = line.split(":@:");
            String[] v = cont[0].split(",");
            Vector key = new Vector(Integer.parseInt(v[0]), Integer.parseInt(v[1]), Integer.parseInt(v[2]));
            try {
                value = Bukkit.createBlockData((String)cont[1]);
            }
            catch (IllegalArgumentException e) {
                BlockDataFixerAbstract fixer = TerraformGeneratorPlugin.injector.getBlockDataFixer();
                if (fixer != null) {
                    value = Bukkit.createBlockData((String)fixer.updateSchematic(schem.getVersionValue(), cont[1]));
                }
                value = null;
                throw e;
            }
            schem.data.put(key, value);
        }
        sc.close();
        if (schem.data.size() < 100) {
            cache.put(internalPath, schem.data);
        }
        return schem;
    }

    public void registerBlock(Block b) {
        Vector rel = b.getLocation().toVector().subtract(this.refPoint.toVector());
        this.data.put(rel, b.getBlockData());
    }

    /*
     * WARNING - void declaration
     */
    public void apply() {
        BlockDataFixerAbstract bdfa = TerraformGeneratorPlugin.injector.getBlockDataFixer();
        ArrayList<Vector> multiFace = new ArrayList<Vector>();
        for (Map.Entry<Vector, BlockData> entry : this.data.entrySet()) {
            void var6_8;
            Vector pos = entry.getKey().clone();
            BlockData blockData = entry.getValue().clone();
            if (this.face == BlockFace.WEST) {
                int x = pos.getBlockX();
                pos.setX(pos.getZ());
                pos.setZ(x * -1);
            } else if (this.face == BlockFace.SOUTH) {
                pos.setX(pos.getX() * -1.0);
                pos.setZ(pos.getZ() * -1.0);
            } else if (this.face == BlockFace.EAST) {
                int x = pos.getBlockX();
                pos.setX(pos.getZ() * -1.0);
                pos.setZ(x);
            }
            if (this.face != BlockFace.NORTH) {
                if (blockData instanceof Orientable) {
                    Orientable o = (Orientable)blockData;
                    if (this.face == BlockFace.EAST || this.face == BlockFace.WEST) {
                        if (o.getAxis() == Axis.X) {
                            o.setAxis(Axis.Z);
                        } else if (o.getAxis() == Axis.Z) {
                            o.setAxis(Axis.X);
                        }
                    }
                } else if (blockData instanceof Rotatable) {
                    Rotatable r = (Rotatable)blockData;
                    if (this.face == BlockFace.SOUTH) {
                        r.setRotation(r.getRotation().getOppositeFace());
                    } else if (this.face == BlockFace.EAST) {
                        r.setRotation(BlockUtils.getAdjacentFaces(r.getRotation())[0]);
                    } else if (this.face == BlockFace.WEST) {
                        r.setRotation(BlockUtils.getAdjacentFaces(r.getRotation())[1]);
                    }
                } else if (blockData instanceof Directional) {
                    Directional r = (Directional)blockData;
                    if (BlockUtils.isDirectBlockFace(r.getFacing())) {
                        if (this.face == BlockFace.SOUTH) {
                            r.setFacing(r.getFacing().getOppositeFace());
                        } else if (this.face == BlockFace.WEST) {
                            r.setFacing(BlockUtils.getAdjacentFaces(r.getFacing())[1]);
                        } else if (this.face == BlockFace.EAST) {
                            r.setFacing(BlockUtils.getAdjacentFaces(r.getFacing())[0]);
                        }
                    }
                } else if (blockData instanceof MultipleFacing) {
                    multiFace.add(pos);
                } else if (blockData instanceof RedstoneWire) {
                    RedstoneWire w = (RedstoneWire)blockData;
                    RedstoneWire newData = (RedstoneWire)Bukkit.createBlockData((Material)Material.REDSTONE_WIRE);
                    newData.setPower(w.getPower());
                    for (BlockFace wireFace : w.getAllowedFaces()) {
                        if (w.getFace(wireFace) == RedstoneWire.Connection.NONE) continue;
                        if (this.face == BlockFace.SOUTH) {
                            newData.setFace(wireFace.getOppositeFace(), w.getFace(wireFace));
                            continue;
                        }
                        if (this.face == BlockFace.WEST) {
                            newData.setFace(BlockUtils.getAdjacentFaces(wireFace)[1], w.getFace(wireFace));
                            continue;
                        }
                        if (this.face == BlockFace.EAST) {
                            newData.setFace(BlockUtils.getAdjacentFaces(wireFace)[0], w.getFace(wireFace));
                            continue;
                        }
                        newData.setFace(wireFace, w.getFace(wireFace));
                    }
                    RedstoneWire redstoneWire = newData;
                }
                if (bdfa != null) {
                    bdfa.correctFacing(pos, null, (BlockData)var6_8, this.face);
                }
            }
            this.parser.applyData(this.refPoint.getRelative(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), (BlockData)var6_8);
        }
        this.parser.applyDelayedData();
        for (Vector pos : multiFace) {
            SimpleBlock b = this.refPoint.getRelative(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ());
            if (!(b.getBlockData() instanceof MultipleFacing)) continue;
            BlockUtils.correctSurroundingMultifacingData(b);
        }
        if (bdfa != null && this.face != BlockFace.NORTH) {
            for (Iterator<Map.Entry<Object, Object>> iterator : bdfa.flush()) {
                SimpleBlock b = this.refPoint.getRelative(iterator.getBlockX(), iterator.getBlockY(), iterator.getBlockZ());
                bdfa.correctFacing((Vector)iterator, b, null, this.face);
            }
        }
    }

    public void export(String path) throws IOException {
        File fout = new File(path);
        fout.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(fout);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
        bw.write("" + Version.DOUBLE);
        bw.newLine();
        for (Map.Entry<Vector, BlockData> entry : this.data.entrySet()) {
            String v = entry.getKey().getBlockX() + "," + entry.getKey().getBlockY() + "," + entry.getKey().getBlockZ();
            bw.write(v + ":@:" + entry.getValue().getAsString());
            bw.newLine();
        }
        bw.close();
    }

    public BlockFace getFace() {
        return this.face;
    }

    public void setFace(BlockFace face) {
        this.face = face;
    }

    public double getVersionValue() {
        return this.VERSION_VALUE;
    }
}

