/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.reflection.PrivateFieldHandler;

public class Pre14PrivateFieldHandler
extends PrivateFieldHandler {
    private static final MethodHandle FIELD_MODIFIERS;

    @Override
    public void injectField(Object obj, String field, Object value) throws Throwable {
        Field targetField = obj.getClass().getField(field);
        targetField.setAccessible(true);
        FIELD_MODIFIERS.invoke(targetField, targetField.getModifiers() & 0xFFFFFFEF);
        targetField.set(obj, value);
        TerraformGeneratorPlugin.logger.info("Pre Java 14 detected.");
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle fieldModifiers = null;
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            fieldModifiers = lookup.unreflectSetter(modifiersField);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        FIELD_MODIFIERS = fieldModifiers;
    }
}

