/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.populators;

import java.util.Objects;
import java.util.Random;
import org.bukkit.Material;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class OrePopulator {
    private final Material type;
    private final int baseChance;
    private final int maxOreSize;
    private final int minOreSize;
    private final int maxNumberOfVeins;
    private final int peakSpawnChanceHeight;
    private final int maxSpawnHeight;
    private int minRange = 5;
    private BiomeBank[] requiredBiomes;
    private int maxDistance;
    private boolean ignorePeakSpawnChance = false;

    public OrePopulator(Material type, int baseChance, int maxOreSize, int maxNumberOfVeins, int peakSpawnChanceHeight, int maxSpawnHeight, boolean ignorePeakSpawnChance, BiomeBank ... requiredBiomes) {
        this.type = type;
        this.baseChance = baseChance;
        this.maxOreSize = maxOreSize;
        this.minOreSize = maxOreSize / 2;
        this.maxNumberOfVeins = maxNumberOfVeins;
        this.peakSpawnChanceHeight = peakSpawnChanceHeight;
        this.maxSpawnHeight = maxSpawnHeight;
        this.requiredBiomes = requiredBiomes;
        this.ignorePeakSpawnChance = ignorePeakSpawnChance;
        this.minRange = TerraformGeneratorPlugin.injector.getMinY() + 1;
        this.maxDistance = Math.max(Math.abs(this.minRange - peakSpawnChanceHeight), Math.abs(maxSpawnHeight - peakSpawnChanceHeight));
    }

    public OrePopulator(Material type, int baseChance, int maxOreSize, int maxNumberOfVeins, int minRange, int peakSpawnChanceHeight, int maxSpawnHeight, boolean ignorePeakSpawnChance, BiomeBank ... requiredBiomes) {
        this.type = type;
        this.baseChance = baseChance;
        this.maxOreSize = maxOreSize;
        this.minOreSize = maxOreSize / 2;
        this.maxNumberOfVeins = maxNumberOfVeins;
        this.minRange = minRange;
        this.peakSpawnChanceHeight = peakSpawnChanceHeight;
        this.maxSpawnHeight = maxSpawnHeight;
        this.requiredBiomes = requiredBiomes;
        this.ignorePeakSpawnChance = ignorePeakSpawnChance;
        this.maxDistance = Math.max(Math.abs(minRange - peakSpawnChanceHeight), Math.abs(maxSpawnHeight - peakSpawnChanceHeight));
    }

    public void populate(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        if (this.requiredBiomes.length > 0) {
            BiomeBank b = BiomeBank.getBiomeSectionFromChunk(world, data.getChunkX(), data.getChunkZ()).getBiomeBank();
            boolean canPopulate = false;
            for (BiomeBank comp : this.requiredBiomes) {
                if (comp != b) continue;
                canPopulate = true;
            }
            if (canPopulate) {
                return;
            }
        }
        for (int i = 0; i < this.maxNumberOfVeins; ++i) {
            int distance;
            if (!GenUtils.chance(random, this.baseChance, 100)) continue;
            int x = GenUtils.randInt(random, 0, 15) + data.getChunkX() * 16;
            int z = GenUtils.randInt(random, 0, 15) + data.getChunkZ() * 16;
            int range = this.maxSpawnHeight;
            if (this.minRange > range) continue;
            if (this.minRange < world.minY) {
                this.minRange = world.minY;
            }
            int y = GenUtils.randInt(random, this.minRange + 64, range + 64) - 64;
            if (!this.ignorePeakSpawnChance && !GenUtils.chance((int)Math.round(100.0 * (1.0 - (double)((float)(distance = Math.abs(y - this.peakSpawnChanceHeight)) / (float)this.maxDistance))), 100)) continue;
            this.placeOre(Objects.hash(world.getSeed(), x, y, z), data, x, y, z);
        }
    }

    public void placeOre(int seed, PopulatorDataAbstract data, int coreX, int coreY, int coreZ) {
        double size = GenUtils.randDouble(new Random(seed), this.minOreSize, this.maxOreSize);
        double radius = Math.pow(0.75 * size * 0.3183098861837907, 0.3333333333333333);
        if (radius <= 0.0 && radius <= 0.0 && radius <= 0.0) {
            return;
        }
        if (radius <= 0.5 && radius <= 0.5 && radius <= 0.5) {
            data.setType(coreX, coreY, coreZ, GenUtils.randMaterial(new Random(seed), this.type));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (double x = -radius; x <= radius; x += 1.0) {
            for (double y = -radius; y <= radius; y += 1.0) {
                for (double z = -radius; z <= radius; z += 1.0) {
                    int relX = (int)Math.round(x) + coreX;
                    int relY = (int)Math.round(y) + coreY;
                    int relZ = (int)Math.round(z) + coreZ;
                    double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(y, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                    Material oreType = data.getType(relX, relY, relZ);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(relX, relY, relZ))) continue;
                    if (oreType == Material.STONE) {
                        data.setType(relX, relY, relZ, this.type);
                        continue;
                    }
                    if (!Version.isAtLeast(17.0)) continue;
                    if (this.type == OneOneSevenBlockHandler.DEEPSLATE && BlockUtils.ores.contains(oreType)) {
                        data.setType(relX, relY, relZ, OneOneSevenBlockHandler.deepSlateVersion(oreType));
                        continue;
                    }
                    if (oreType != OneOneSevenBlockHandler.DEEPSLATE) continue;
                    data.setType(relX, relY, relZ, OneOneSevenBlockHandler.deepSlateVersion(this.type));
                }
            }
        }
    }

    public Material getType() {
        return this.type;
    }

    public int getBaseChance() {
        return this.baseChance;
    }

    public int getMaxOreSize() {
        return this.maxOreSize;
    }

    public int getMinOreSize() {
        return this.minOreSize;
    }

    public int getMaxNumberOfVeins() {
        return this.maxNumberOfVeins;
    }

    public int getPeakSpawnChanceHeight() {
        return this.peakSpawnChanceHeight;
    }

    public int getMaxSpawnHeight() {
        return this.maxSpawnHeight;
    }

    public int getMinRange() {
        return this.minRange;
    }

    public BiomeBank[] getRequiredBiomes() {
        return this.requiredBiomes;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public boolean isIgnorePeakSpawnChance() {
        return this.ignorePeakSpawnChance;
    }
}

