/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main.config;

import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.terraform.main.TerraformGeneratorPlugin;

public class ConfigLoader {
    private HashMap<String, Object> configOptions = new HashMap();
    private TerraformGeneratorPlugin plugin;
    private static final int configVersion = 3;

    public ConfigLoader(TerraformGeneratorPlugin plugin) {
        this.plugin = plugin;
        plugin.getConfig().options().copyDefaults(false);
        plugin.saveConfig();
        this.configOptions.put("lang", "eng.yml");
        this.configOptions.put("config-version", 3);
    }

    public void load() {
        boolean overwrite = false;
        if (!this.plugin.getConfig().isSet("config-version")) {
            overwrite = true;
        } else if (this.plugin.getConfig().getInt("config-version") < 3) {
            overwrite = true;
        }
        if (overwrite) {
            try {
                if (new File("./plugins/TerraformGenerator/config.yml").exists()) {
                    Bukkit.getLogger().info("New config version detected. Overwriting old config. A backup will be made");
                    Files.copy((File)new File("./plugins/TerraformGenerator/config.yml"), (File)new File("./plugins/TerraformGenerator/config.yml-" + System.currentTimeMillis() + ".bak"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getLogger().info("Failed to backup old config before overwrite.");
            }
        }
        for (String key : new ArrayList<String>(this.configOptions.keySet())) {
            if (!overwrite && this.plugin.getConfig().isSet(key)) {
                this.configOptions.put(key, this.plugin.getConfig().get(key));
                continue;
            }
            this.plugin.getConfig().set(key, this.configOptions.get(key));
            this.plugin.saveConfig();
        }
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load();
    }

    public void reg(String key, Object defaultValue) {
        this.configOptions.put(key, defaultValue);
    }

    public void save() {
        for (String key : this.configOptions.keySet()) {
            this.plugin.getConfig().set(key, this.configOptions.get(key));
            this.plugin.saveConfig();
        }
    }

    public String getString(String key) {
        return (String)this.configOptions.get(key);
    }

    public Object get(String key) {
        return this.configOptions.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.configOptions.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.configOptions.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.configOptions.get(key);
    }

    public List<String> getStringList(String key) {
        return (List)this.configOptions.get(key);
    }
}

