/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.ChunkCacheLoader;
import org.terraform.coregen.NMSInjectorAbstract;
import org.terraform.coregen.TerraformPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.LangOpt;
import org.terraform.main.LanguageManager;
import org.terraform.main.TLogger;
import org.terraform.main.TerraformCommandManager;
import org.terraform.main.config.ConfigLoader;
import org.terraform.main.config.TConfigOption;
import org.terraform.reflection.Post14PrivateFieldHandler;
import org.terraform.reflection.Pre14PrivateFieldHandler;
import org.terraform.reflection.PrivateFieldHandler;
import org.terraform.schematic.SchematicListener;
import org.terraform.structure.StructureRegistry;
import org.terraform.tree.SaplingOverrider;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.bstats.TerraformGeneratorMetricsHandler;
import org.terraform.utils.version.Version;
import org.terraform.watchdog.TfgWatchdogSuppressant;

public class TerraformGeneratorPlugin
extends JavaPlugin
implements Listener {
    public static TLogger logger;
    public static final Set<String> INJECTED_WORLDS;
    public static final PrivateFieldHandler privateFieldHandler;
    public static NMSInjectorAbstract injector;
    private static TerraformGeneratorPlugin instance;
    public static TfgWatchdogSuppressant watchdogSuppressant;
    private ConfigLoader config;
    private LanguageManager lang;

    public static TerraformGeneratorPlugin get() {
        return instance;
    }

    public void onEnable() {
        super.onEnable();
        GenUtils.initGenUtils();
        BlockUtils.initBlockUtils();
        instance = this;
        this.config = new ConfigLoader(this);
        this.lang = new LanguageManager(this);
        TConfigOption.loadValues(this.config);
        BiomeBank.initSinglesConfig();
        TerraformGenerator.CHUNK_CACHE = CacheBuilder.newBuilder().maximumSize((long)TConfigOption.DEVSTUFF_CHUNKCACHE_SIZE.getInt()).build((CacheLoader)new ChunkCacheLoader());
        GenUtils.biomeQueryCache = CacheBuilder.newBuilder().maximumSize((long)TConfigOption.DEVSTUFF_CHUNKBIOMES_SIZE.getInt()).build((CacheLoader)new CacheLoader<ChunkCache, EnumSet<BiomeBank>>(){

            public EnumSet<BiomeBank> load(ChunkCache key) {
                EnumSet<BiomeBank> banks = EnumSet.noneOf(BiomeBank.class);
                int gridX = key.chunkX * 16;
                int gridZ = key.chunkZ * 16;
                for (int x = gridX; x < gridX + 16; ++x) {
                    for (int z = gridZ; z < gridZ + 16; ++z) {
                        BiomeBank bank = key.tw.getBiomeBank(x, z);
                        if (banks.contains((Object)bank)) continue;
                        banks.add(bank);
                    }
                }
                return banks;
            }
        });
        LangOpt.init(this);
        logger = new TLogger();
        watchdogSuppressant = new TfgWatchdogSuppressant();
        new TerraformGeneratorMetricsHandler(this);
        TerraformGenerator.updateSeaLevelFromConfig();
        new TerraformCommandManager(this, "terraform", "terra");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SchematicListener(), (Plugin)this);
        String version = Version.getVersionPackage();
        logger.stdout("Detected version: " + version + ", number: " + Version.DOUBLE);
        try {
            injector = (NMSInjectorAbstract)Class.forName("org.terraform." + version + ".NMSInjector").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            logger.stdout("&cNo support for this version has been made yet!");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            logger.stdout("&cSomething went wrong initiating the injector!");
        }
        injector.startupTasks();
        if (TConfigOption.MISC_SAPLING_CUSTOM_TREES_ENABLED.getBoolean()) {
            Bukkit.getPluginManager().registerEvents((Listener)new SaplingOverrider(), (Plugin)this);
        }
        StructureRegistry.init();
    }

    public void onDisable() {
    }

    @Deprecated
    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (event.getWorld().getGenerator() instanceof TerraformGenerator) {
            logger.stdout(event.getWorld().getName() + " loaded.");
            if (!TerraformGenerator.preWorldInitGen.isEmpty()) {
                if (!TConfigOption.DEVSTUFF_ATTEMPT_FIXING_PREMATURE.getBoolean()) {
                    logger.stdout("&cIgnoring " + TerraformGenerator.preWorldInitGen.size() + " pre-maturely generated chunks. You may see a patch of plain land.");
                    return;
                }
                logger.stdout("&6Trying to decorate " + TerraformGenerator.preWorldInitGen.size() + " pre-maturely generated chunks.");
                int fixed = 0;
                TerraformWorld tw = TerraformWorld.get(event.getWorld());
                for (SimpleChunkLocation sc : TerraformGenerator.preWorldInitGen) {
                    if (!sc.getWorld().equals(event.getWorld().getName())) continue;
                    logger.stdout("Populating " + sc);
                    PopulatorDataPostGen data = new PopulatorDataPostGen(sc.toChunk());
                    new TerraformPopulator(tw).populate(tw, new Random(), data);
                    ++fixed;
                }
                logger.stdout("&aSuccessfully finished fixing " + fixed + " pre-mature chunks!");
            }
        }
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        if (event.getWorld().getGenerator() instanceof TerraformGenerator) {
            logger.stdout("Detected world: " + event.getWorld().getName() + ", commencing injection... ");
            if (injector.attemptInject(event.getWorld())) {
                INJECTED_WORLDS.add(event.getWorld().getName());
                TerraformWorld tw = TerraformWorld.get(event.getWorld());
                tw.minY = injector.getMinY();
                tw.maxY = injector.getMaxY();
                logger.stdout("&aInjection success! Proceeding with generation.");
            } else {
                logger.stdout("&cInjection failed.");
            }
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return new TerraformGenerator();
    }

    public ConfigLoader getConfigLoader() {
        return this.config;
    }

    public LanguageManager getLang() {
        return this.lang;
    }

    static {
        PrivateFieldHandler handler;
        INJECTED_WORLDS = new HashSet<String>();
        try {
            Field.class.getDeclaredField("modifiers");
            handler = new Pre14PrivateFieldHandler();
        }
        catch (NoSuchFieldException | SecurityException ex) {
            handler = new Post14PrivateFieldHandler();
        }
        privateFieldHandler = handler;
    }
}

