/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.main;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.terraform.main.TerraformGeneratorPlugin;

public class LanguageManager {
    private FileConfiguration langFile;
    private File file;
    private HashMap<String, String> cache = new HashMap();

    public LanguageManager(TerraformGeneratorPlugin plugin) {
        this.file = new File(plugin.getDataFolder(), plugin.getConfigLoader().getString("lang"));
        this.reloadLangFile();
        this.loadDefaults();
    }

    private void loadDefaults() {
        this.fetchLang("permissions.insufficient", "&cYou don't have enough permissions to perform this action!");
        this.fetchLang("command.wrong-arg-length", "&cToo many or too little arguments provided!");
        this.fetchLang("command.unknown", "&cUnknown subcommand.");
        this.fetchLang("command.help.postive-pages", "&cThe page specified must be a positive number!");
        this.fetchLang("permissions.console-cannot-exec", "&cOnly players can execute this command.");
    }

    public String fetchLang(String langKey) {
        return this.fetchLang(langKey, null);
    }

    public String fetchLang(String langKey, String def) {
        if (this.cache.containsKey(langKey)) {
            return this.cache.get(langKey);
        }
        if (this.langFile.isSet(langKey)) {
            String value = ChatColor.translateAlternateColorCodes((char)'&', (String)this.langFile.getString(langKey));
            this.cache.put(langKey, value);
            return value;
        }
        if (def != null) {
            this.langFile.set(langKey, (Object)def);
            this.saveLangFile();
        }
        this.cache.put(langKey, ChatColor.translateAlternateColorCodes((char)'&', (String)def));
        return ChatColor.translateAlternateColorCodes((char)'&', (String)def);
    }

    public FileConfiguration getLangFile() {
        return this.langFile;
    }

    public void saveLangFile() {
        try {
            this.langFile.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadLangFile() {
        this.cache.clear();
        this.langFile = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

