/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.data;

import org.bukkit.block.BlockFace;
import org.terraform.main.TerraformGeneratorPlugin;

public class SimpleLocation {
    protected int x;
    protected int y;
    protected int z;

    public SimpleLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public SimpleLocation(SimpleLocation other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public SimpleLocation getRelative(int x, int y, int z) {
        return new SimpleLocation(this.x + x, this.y + y, this.z + z);
    }

    public SimpleLocation getRelative(BlockFace face) {
        return new SimpleLocation(this.x + face.getModX(), this.y + face.getModY(), this.z + face.getModZ());
    }

    public SimpleLocation getRelative(BlockFace face, int i) {
        return new SimpleLocation(this.x + face.getModX() * i, this.y + face.getModY() * i, this.z + face.getModZ() * i);
    }

    public float distance(SimpleLocation o) {
        return (float)Math.sqrt(Math.pow(o.x - this.x, 2.0) + Math.pow(o.y - this.y, 2.0) + Math.pow(o.z - this.z, 2.0));
    }

    public float distanceSqr(SimpleLocation o) {
        return (float)(Math.pow(o.x - this.x, 2.0) + Math.pow(o.y - this.y, 2.0) + Math.pow(o.z - this.z, 2.0));
    }

    public float distanceQuad(SimpleLocation o) {
        return (float)Math.pow(Math.pow(o.x - this.x, 2.0) + Math.pow(o.y - this.y, 2.0) + Math.pow(o.z - this.z, 2.0), 4.0);
    }

    public float distanceSqr(int nx, int ny, int nz) {
        return (float)(Math.pow(nx - this.x, 2.0) + Math.pow(ny - this.y, 2.0) + Math.pow(nz - this.z, 2.0));
    }

    public float twoDAngleTo(SimpleLocation o) {
        if (o.x == this.x && o.z == this.z) {
            return 0.0f;
        }
        if (o.x == this.x && o.z > this.z) {
            return 0.0f;
        }
        if (o.x == this.x && o.z < this.z) {
            return (float)Math.PI;
        }
        if (o.x > this.x && o.z == this.z) {
            return 1.5707964f;
        }
        if (o.x < this.x && o.z == this.z) {
            return 4.712389f;
        }
        if (o.x > this.x && o.z > this.z) {
            return (float)Math.atan((o.x - this.x) / (o.z - this.z));
        }
        if (o.x > this.x && o.z < this.z) {
            return (float)(Math.atan((this.z - o.z) / (o.x - this.x)) + 1.5707963267948966);
        }
        if (o.x < this.x && o.z < this.z) {
            return (float)(Math.atan((this.x - o.x) / (this.z - o.z)) + Math.PI);
        }
        if (o.x < this.x && o.z > this.z) {
            return (float)(Math.atan((o.z - this.z) / (this.x - o.x)) + 4.71238898038469);
        }
        TerraformGeneratorPlugin.logger.error("2D Angle calculation failed! Input Values: " + o.x + "," + o.z + ":" + this.x + "," + this.z);
        return 0.0f;
    }

    public float twoDAngleWrapTo(SimpleLocation o) {
        if (o.x == this.x && o.z == this.z) {
            return 0.0f;
        }
        if (o.x == this.x && o.z > this.z) {
            return 0.0f;
        }
        if (o.x == this.x && o.z < this.z) {
            return (float)Math.PI;
        }
        if (o.x > this.x && o.z == this.z) {
            return 1.5707964f;
        }
        if (o.x < this.x && o.z == this.z) {
            return 1.5707964f;
        }
        if (o.x > this.x && o.z > this.z) {
            return (float)Math.atan((o.x - this.x) / (o.z - this.z));
        }
        if (o.x > this.x && o.z < this.z) {
            return (float)(Math.atan((this.z - o.z) / (o.x - this.x)) + 1.5707963267948966);
        }
        if (o.x < this.x && o.z < this.z) {
            return (float)(Math.atan((this.z - o.z) / (this.x - o.x)) + 1.5707963267948966);
        }
        if (o.x < this.x && o.z > this.z) {
            return (float)Math.atan((this.x - o.x) / (o.z - this.z));
        }
        TerraformGeneratorPlugin.logger.error("2D Angle calculation failed! Input Values: " + o.x + "," + o.z + ":" + this.x + "," + this.z);
        return 0.0f;
    }

    public int hashCode() {
        int prime = 93929798;
        int hash = this.x * prime;
        hash = (hash + this.y) * prime;
        hash = (hash + this.z) * prime;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleLocation) {
            SimpleLocation sLoc = (SimpleLocation)obj;
            return sLoc.x == this.x && sLoc.y == this.y && sLoc.z == this.z;
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

