/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.data;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;

public class SimpleChunkLocation
implements Cloneable {
    private final String world;
    private final int x;
    private final int z;

    public SimpleChunkLocation(String world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public SimpleChunkLocation(String world, int x, int y, int z) {
        this.world = world;
        this.x = x >> 4;
        this.z = z >> 4;
    }

    public SimpleChunkLocation(Chunk chunk) {
        this.world = chunk.getWorld().getName();
        this.x = chunk.getX();
        this.z = chunk.getZ();
    }

    public static SimpleChunkLocation of(Block block) {
        return new SimpleChunkLocation(block.getWorld().getName(), block.getX() >> 4, block.getZ() >> 4);
    }

    public static Chunk toChunk(SimpleChunkLocation loc) {
        return Bukkit.getWorld((String)loc.world).getChunkAt(loc.x, loc.z);
    }

    public static SimpleChunkLocation chunkStrToLoc(String chunk) {
        if (chunk == null) {
            return null;
        }
        String[] split = StringUtils.split((String)StringUtils.deleteWhitespace((String)chunk), (char)',');
        String world = split[0];
        int x = Integer.parseInt(split[1]);
        int z = Integer.parseInt(split[2]);
        return new SimpleChunkLocation(world, x, z);
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public SimpleChunkLocation getRelative(int nx, int nz) {
        return new SimpleChunkLocation(this.world, nx + this.x, nz + this.z);
    }

    public SimpleChunkLocation clone() {
        return new SimpleChunkLocation(this.world, this.x, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.world.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleChunkLocation)) {
            return false;
        }
        SimpleChunkLocation other = (SimpleChunkLocation)obj;
        return this.x == other.x && this.z == other.z && Objects.equals(this.world, other.world);
    }

    public String toString() {
        return this.world + ", " + this.x + ", " + this.z;
    }

    public Chunk toChunk() {
        return Bukkit.getWorld((String)this.world).getChunkAt(this.x, this.z);
    }
}

