/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.sqlite;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.block.data.BlockData;

public class SQLiteDB {
    private static final Set<String> PREPARED_WORLDS = new HashSet<String>();
    private static SQLiteDB i;

    public static SQLiteDB get() {
        if (i == null) {
            i = new SQLiteDB();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableIfNotExists(String world) {
        if (PREPARED_WORLDS.contains(world)) {
            return;
        }
        Connection conn = null;
        String dir = "plugins" + File.separator + "TerraformGenerator" + File.separator + world + ".db";
        try {
            String url = "jdbc:sqlite:" + dir;
            conn = DriverManager.getConnection(url);
            Statement stmt = conn.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS CHUNKS (CHUNK STRING PRIMARY KEY     NOT NULL, POPULATED           BOOLEAN     NOT NULL); ";
            stmt.executeUpdate(sql);
            stmt.close();
            stmt = conn.createStatement();
            sql = "CREATE TABLE IF NOT EXISTS BLOCKDATA (CHUNK STRING NOT NULL,COORDS STRING NOT NULL, DATA STRING NOT NULL,PRIMARY KEY (CHUNK,COORDS)); ";
            stmt.executeUpdate(sql);
            stmt.close();
            PREPARED_WORLDS.add(world);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLiteDB.closeConn(conn);
                throw throwable;
            }
            SQLiteDB.closeConn(conn);
        }
        SQLiteDB.closeConn(conn);
    }

    private static void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void updateBlockData(Connection c2, Statement stmt, String world, int chunkX, int chunkZ, int x, int y, int z, BlockData data) {
        SQLiteDB.createTableIfNotExists(world);
        String dir = "plugins" + File.separator + "TerraformGenerator" + File.separator + world + ".db";
        String CHUNK = chunkX + "," + chunkZ;
        String COORDS = x + "," + y + "," + z;
        String DATA = data.toString();
        try {
            Class.forName("org.sqlite.JDBC");
            c2 = DriverManager.getConnection("jdbc:sqlite:" + dir);
            c2.setAutoCommit(false);
            stmt = c2.createStatement();
            String sql = "DELETE from BLOCKDATA where CHUNK='" + CHUNK + "' and COORDS='" + COORDS + "';";
            stmt.executeUpdate(sql);
            sql = "INSERT INTO BLOCKDATA (CHUNK,COORDS,DATA) VALUES ('" + CHUNK + "', '" + COORDS + "', '" + DATA + "');";
            stmt.executeUpdate(sql);
            stmt.close();
            c2.commit();
            c2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean[] fetchFromChunks(String world, int chunkX, int chunkZ) {
        SQLiteDB.createTableIfNotExists(world);
        String dir = "plugins" + File.separator + "TerraformGenerator" + File.separator + world + ".db";
        String key = chunkX + "," + chunkZ;
        boolean[] queryReply = new boolean[]{false, false};
        try {
            Class.forName("org.sqlite.JDBC");
            Connection c2 = DriverManager.getConnection("jdbc:sqlite:" + dir);
            c2.setAutoCommit(false);
            Statement stmt = c2.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM CHUNKS WHERE CHUNK='" + key + "';");
            queryReply = rs.next() ? new boolean[]{true, rs.getBoolean("POPULATED")} : new boolean[]{false, false};
            rs.close();
            stmt.close();
            c2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryReply;
    }

    public void putChunk(String world, int chunkX, int chunkZ, boolean populated) {
        SQLiteDB.createTableIfNotExists(world);
        String dir = "plugins" + File.separator + "TerraformGenerator" + File.separator + world + ".db";
        try {
            Class.forName("org.sqlite.JDBC");
            Connection c2 = DriverManager.getConnection("jdbc:sqlite:" + dir);
            c2.setAutoCommit(false);
            Statement stmt = c2.createStatement();
            String key = chunkX + "," + chunkZ;
            String sql = "DELETE from CHUNKS where CHUNK='" + key + "';";
            stmt.executeUpdate(sql);
            sql = "INSERT INTO CHUNKS (CHUNK,POPULATED) VALUES ('" + key + "', '" + populated + "');";
            stmt.executeUpdate(sql);
            stmt.close();
            c2.commit();
            c2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

